/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.coercion.target;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import net.stickycode.coercion.CoercionTarget;
import net.stickycode.coercion.target.ArrayCoercionTarget;
import net.stickycode.coercion.target.CoercionTargetsDoesNotRecogniseTypeException;
import net.stickycode.coercion.target.ParameterizedArrayCoercionTarget;
import net.stickycode.coercion.target.ParameterizedCoercionTarget;
import net.stickycode.coercion.target.ParentCoercionTargetsAreRequiredToResolveTypeVariables;
import net.stickycode.coercion.target.PrimitiveResolvingCoercionTarget;

public class CoercionTargets {
    public static CoercionTarget find(Class<?> type) {
        return CoercionTargets.find(type, type, type, null);
    }

    private static CoercionTarget find(Class<?> type, AnnotatedElement element, Class<?> owner, CoercionTarget parent) {
        if (type.isArray()) {
            return new ArrayCoercionTarget(type, owner, parent);
        }
        return new PrimitiveResolvingCoercionTarget(type, element, owner, parent);
    }

    public static CoercionTarget find(Type genericType, Class<?> owner) {
        return CoercionTargets.find(null, genericType, null, owner, null);
    }

    public static CoercionTarget find(Class<?> type, Type genericType) {
        return CoercionTargets.find(type, genericType, type, type, null);
    }

    static CoercionTarget find(Class<?> type, Type genericType, AnnotatedElement element, Class<?> owner, CoercionTarget parent) {
        if (genericType instanceof Class) {
            return CoercionTargets.find((Class)genericType, element, owner, parent);
        }
        if (genericType instanceof ParameterizedType) {
            return new ParameterizedCoercionTarget((ParameterizedType)genericType, element, owner, parent);
        }
        if (genericType instanceof GenericArrayType) {
            return new ParameterizedArrayCoercionTarget((GenericArrayType)genericType, owner, parent);
        }
        if (genericType instanceof TypeVariable) {
            return CoercionTargets.resolveTypeVariable((TypeVariable)genericType, element, owner, parent);
        }
        throw new CoercionTargetsDoesNotRecogniseTypeException(genericType);
    }

    private static CoercionTarget resolveTypeVariable(TypeVariable genericType, AnnotatedElement element, Class<?> owner, CoercionTarget parent) {
        if (parent == null) {
            throw new ParentCoercionTargetsAreRequiredToResolveTypeVariables(genericType, owner);
        }
        if (genericType.getGenericDeclaration().equals(parent.getType())) {
            for (Type type : genericType.getGenericDeclaration().getTypeParameters()) {
                if (!parent.getType().equals(type.getGenericDeclaration())) continue;
                return CoercionTargets.find(parent.getComponentCoercionTypes()[0].getType(), element, owner, null);
            }
        }
        for (Type type : ((Class)genericType.getGenericDeclaration()).getInterfaces()) {
            if (!parent.getType().equals(type)) continue;
            for (TypeVariable i : ((Class)type).getTypeParameters()) {
                if (!parent.getType().equals(i.getGenericDeclaration())) continue;
                return CoercionTargets.find(parent.getComponentCoercionTypes()[0].getType(), element, owner, null);
            }
        }
        throw new CoercionTargetsDoesNotRecogniseTypeException(genericType);
    }

    public static CoercionTarget find(Field f) {
        return CoercionTargets.find(f.getType(), f.getGenericType(), f, f.getDeclaringClass(), null);
    }

    public static CoercionTarget find(Method m) {
        return CoercionTargets.find(m.getReturnType(), m.getGenericReturnType(), m, m.getDeclaringClass(), null);
    }

    public static CoercionTarget find(Field f, CoercionTarget parent) {
        return CoercionTargets.find(f.getType(), f.getGenericType(), f, f.getDeclaringClass(), parent);
    }
}

