/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.coercion.target;

import java.lang.reflect.AnnotatedElement;
import net.stickycode.coercion.CoercionTarget;
import net.stickycode.exception.Preconditions;

public abstract class AbstractCoercionTarget
implements CoercionTarget {
    protected final Class<?> type;
    protected final Class<?> owner;
    protected final CoercionTarget parent;

    public AbstractCoercionTarget(Class<?> type, Class<?> owner, CoercionTarget parent) {
        this.type = (Class)Preconditions.notNull(type, (String)"All coercion targets must have a type");
        this.owner = (Class)Preconditions.notNull(owner, (String)"All coercion targets must have an owner");
        this.parent = parent;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean hasComponents() {
        return false;
    }

    @Override
    public CoercionTarget[] getComponentCoercionTypes() {
        throw new UnsupportedOperationException("There are no components on " + this.getClass());
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Class<?> boxedType() {
        throw new UnsupportedOperationException("This target is not primitive hence no boxing " + this);
    }

    @Override
    public boolean canBeAnnotated() {
        return false;
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        throw new UnsupportedOperationException("There are no components on " + this.getClass());
    }

    @Override
    public Class<?> getOwner() {
        return this.owner;
    }

    @Override
    public CoercionTarget getParent() {
        return this.parent;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.type.getSimpleName() + "}";
    }
}

