/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.coercion;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.stickycode.coercion.CoercionTarget;
import net.stickycode.coercion.CoercionType;
import net.stickycode.coercion.UnknownPrimitiveTypeException;

public abstract class AbstractCoercionType
implements CoercionTarget {
    public abstract boolean isGenericType();

    public abstract ParameterizedType getGenericType();

    @Override
    public abstract Class<?> getType();

    @Override
    public boolean isArray() {
        return this.getType().isArray();
    }

    @Override
    public Class<?> getComponentType() {
        if (this.isArray()) {
            return this.getType().getComponentType();
        }
        if (this.isGenericType()) {
            return (Class)this.getGenericType().getActualTypeArguments()[0];
        }
        throw new RuntimeException();
    }

    @Override
    public AbstractCoercionType getComponentCoercionType() {
        return new CoercionType(this.resolve(this.getComponentType()));
    }

    public AbstractCoercionType[] getComponentCoercionTypes() {
        Type[] arguments = this.getGenericType().getActualTypeArguments();
        AbstractCoercionType[] types = new AbstractCoercionType[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            types[i] = new CoercionType(this.resolve((Class)arguments[i]));
        }
        return types;
    }

    protected Class<?> resolve(Class<?> componentType) {
        if (!componentType.isPrimitive()) {
            return componentType;
        }
        if (Boolean.TYPE.equals(componentType)) {
            return Boolean.class;
        }
        if (Integer.TYPE.equals(componentType)) {
            return Integer.class;
        }
        if (Float.TYPE.equals(componentType)) {
            return Float.class;
        }
        if (Double.TYPE.equals(componentType)) {
            return Double.class;
        }
        if (Byte.TYPE.equals(componentType)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(componentType)) {
            return Short.class;
        }
        throw new UnknownPrimitiveTypeException(componentType);
    }
}

