/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.plugin.bounds;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.stickycode.plugin.bounds.StickySerializer;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.ValidityException;
import nu.xom.XPathContext;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.VersionRangeRequest;
import org.sonatype.aether.resolution.VersionRangeResolutionException;
import org.sonatype.aether.resolution.VersionRangeResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.version.Version;

public class StickyBoundsMojo
extends AbstractMojo {
    private MavenProject project;
    private RepositorySystem repository;
    private RepositorySystemSession session;
    private Pattern range = Pattern.compile("\\[[0-9.A-Za-z]+,([0-9]+)\\)");
    private List<RemoteRepository> repositories;

    public void execute() {
        Document pom = this.load();
        boolean changed = false;
        for (Dependency dependency : this.project.getDependencies()) {
            String version = dependency.getVersion();
            Matcher versionMatch = this.range.matcher(version);
            if (!versionMatch.matches()) continue;
            DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getType(), dependency.getClassifier(), version);
            Version highestVersion = this.highestVersion(version, (Artifact)artifact);
            String newVersion = "[" + highestVersion.toString() + "," + versionMatch.group(1) + ")";
            if (newVersion.equals(version)) continue;
            this.getLog().info((CharSequence)("Updating " + artifact.toString() + " to " + newVersion));
            this.update(pom, (Artifact)artifact, newVersion);
            changed |= true;
        }
        if (changed) {
            this.writeChanges(pom);
        }
    }

    private void writeChanges(Document pom) {
        Serializer serializer = this.createSerialiser();
        try {
            serializer.write(pom);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Serializer createSerialiser() {
        try {
            StickySerializer serializer = new StickySerializer(new FileOutputStream(this.project.getFile()), "UTF-8");
            return serializer;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Version highestVersion(String version, Artifact artifact) {
        VersionRangeRequest request = new VersionRangeRequest(artifact, this.repositories, null);
        VersionRangeResult v = this.resolve(request);
        Version highestVersion = v.getHighestVersion();
        return highestVersion;
    }

    void update(Document pom, Artifact artifact, String newVersion) {
        XPathContext context = new XPathContext("mvn", "http://maven.apache.org/POM/4.0.0");
        Nodes nodes = pom.query(this.dependencyPath(artifact.getArtifactId()), context);
        if (nodes.size() == 0) {
            throw new RuntimeException("Got none but was expected one matching dependency " + artifact.getArtifactId());
        }
        if (nodes.size() > 1) {
            throw new RuntimeException("Expected one matching dependency " + nodes);
        }
        ParentNode dependency = nodes.get(0).getParent();
        Node version = dependency.query("mvn:version", context).get(0);
        Element newRange = new Element("version", "http://maven.apache.org/POM/4.0.0");
        newRange.appendChild(newVersion);
        dependency.replaceChild(version, (Node)newRange);
    }

    private String dependencyPath(String artifactId) {
        return "//mvn:dependencies/mvn:dependency/mvn:artifactId[text()='" + artifactId + "']";
    }

    private Document load() {
        try {
            return new Builder().build(this.project.getFile());
        }
        catch (ValidityException e) {
            throw new RuntimeException(e);
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private VersionRangeResult resolve(VersionRangeRequest request) {
        try {
            return this.repository.resolveVersionRange(this.session, request);
        }
        catch (VersionRangeResolutionException e) {
            throw new RuntimeException(e);
        }
    }
}

