/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.plugin.bounds;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.stickycode.plugin.bounds.StickyBoundsUpgradeMojo;
import net.stickycode.plugin.bounds.StickySerializer;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import nu.xom.XPathContext;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.assertj.core.api.StrictAssertions;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.version.Version;
import org.junit.Test;

public class StickyBoundsUpgradeMojoIntegrationTest {
    @Test
    public void matchVersionRanges() {
        StickyBoundsUpgradeMojo mojo = new StickyBoundsUpgradeMojo();
        StrictAssertions.assertThat((boolean)mojo.matchVersion("1.0,2").matches()).isFalse();
        StrictAssertions.assertThat((boolean)mojo.matchVersion("[1.0,2]").matches()).isFalse();
        StrictAssertions.assertThat((boolean)mojo.matchVersion("[1.0,2)").matches()).isTrue();
        StrictAssertions.assertThat((boolean)mojo.matchVersion("[1.0,2.0)").matches()).isTrue();
        StrictAssertions.assertThat((boolean)mojo.matchVersion("[1.0,)").matches()).isTrue();
        StrictAssertions.assertThat((boolean)mojo.matchVersion("[1.0,2.3.4)").matches()).isTrue();
        StrictAssertions.assertThat((boolean)mojo.matchVersion("[1.0.4,2.3.4)").matches()).isTrue();
        StrictAssertions.assertThat((boolean)mojo.matchVersion("[1.0.4, 2.3.4)").matches()).isTrue();
        StrictAssertions.assertThat((boolean)mojo.matchVersion("[1.0.4 , 2.3.4)").matches()).isTrue();
        StrictAssertions.assertThat((boolean)mojo.matchVersion("[1.0.4 ,2.3.4)").matches()).isTrue();
        StrictAssertions.assertThat((boolean)mojo.matchVersion("[1.0.4-SNAPSHOT,2.3.4-SNAPSHOT)").matches()).isTrue();
    }

    @Test
    public void upgrade() throws MojoExecutionException {
        StickyBoundsUpgradeMojo mojo = new StickyBoundsUpgradeMojo(){

            protected Version highestVersion(Artifact artifact) throws MojoExecutionException {
                return new Version(){

                    public String toString() {
                        return "6.7";
                    }

                    public int compareTo(Version o) {
                        return 0;
                    }
                };
            }
        };
        Dependency dependency = new Dependency();
        StrictAssertions.assertThat((String)mojo.resolveLatestVersionRange(dependency, "[1.2,2)").getVersion()).isEqualTo((Object)"[6.7,7)");
        StrictAssertions.assertThat((String)mojo.resolveLatestVersionRange(dependency, "[2.2,5)").getVersion()).isEqualTo((Object)"[6.7,7)");
        StrictAssertions.assertThat((String)mojo.resolveLatestVersionRange(dependency, "[6.7,7)").getVersion()).isEqualTo((Object)"[6.7,7)");
    }

    @Test
    public void bump() throws ValidityException, ParsingException, IOException, MojoExecutionException {
        Document pom = new Builder().build(new File(new File("src/it/update"), "pom.xml"));
        XPathContext context = new XPathContext("mvn", "http://maven.apache.org/POM/4.0.0");
        Nodes versions = pom.query("/mvn:project/mvn:version", context);
        StrictAssertions.assertThat((int)versions.size()).isEqualTo(1);
        StrictAssertions.assertThat((int)pom.query("/mvn:project/mvn:version[text()='1.1-SNAPSHOT']", context).size()).isEqualTo(1);
        StrictAssertions.assertThat((int)pom.query("/mvn:project/mvn:version[text()='2.1-SNAPSHOT']", context).size()).isEqualTo(0);
        new StickyBoundsUpgradeMojo().bumpMajorVersion(pom);
        StrictAssertions.assertThat((int)pom.query("/mvn:project/mvn:version[text()='1.1-SNAPSHOT']", context).size()).isEqualTo(0);
        StrictAssertions.assertThat((int)pom.query("/mvn:project/mvn:version[text()='2.1-SNAPSHOT']", context).size()).isEqualTo(1);
    }

    @Test
    public void update() throws ValidityException, ParsingException, IOException, MojoExecutionException {
        Document pom = new Builder().build(new File(new File("src/it/upgrade"), "pom.xml"));
        DefaultArtifact artifact = new DefaultArtifact("net.stickycode", "sticky-coercion", "jar", "", "[3.6,4)");
        new StickyBoundsUpgradeMojo().updateDependency(pom, (Artifact)artifact, "[3.1,4)");
        XPathContext context = new XPathContext("mvn", "http://maven.apache.org/POM/4.0.0");
        Nodes versions = pom.query("//mvn:version", context);
        StrictAssertions.assertThat((int)versions.size()).isEqualTo(3);
        Nodes nodes = pom.query("//mvn:version[text()='[3.6,4)']", context);
        StrictAssertions.assertThat((int)nodes.size()).isEqualTo(1);
        Node node = nodes.get(0);
        StrictAssertions.assertThat((String)node.getValue()).isEqualTo((Object)"[3.6,4)");
    }

    @Test
    public void updateWithClassifier() throws ValidityException, ParsingException, IOException, MojoExecutionException {
        Document pom = new Builder().build((Reader)new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("classifiers.xml"))));
        DefaultArtifact artifact = new DefaultArtifact("net.stickycode", "sticky-coercion", "jar", "", "[2.6,3)");
        new StickyBoundsUpgradeMojo().updateDependency(pom, (Artifact)artifact, "[2.1,3)");
        XPathContext context = new XPathContext("mvn", "http://maven.apache.org/POM/4.0.0");
        Nodes versions = pom.query("//mvn:version", context);
        StrictAssertions.assertThat((int)versions.size()).isEqualTo(4);
        Nodes nodes = pom.query("//mvn:version[text()='[2.6,3)']", context);
        StrictAssertions.assertThat((int)nodes.size()).isEqualTo(1);
        Node node = nodes.get(0);
        StrictAssertions.assertThat((String)node.getValue()).isEqualTo((Object)"[2.6,3)");
    }

    @Test
    public void updateTheClassifier() throws ValidityException, ParsingException, IOException, MojoExecutionException {
        Document pom = new Builder().build((Reader)new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("classifiers.xml"))));
        DefaultArtifact artifact = new DefaultArtifact("net.stickycode", "sticky-coercion", "jar", "test-jar", "[2.6,3)");
        new StickyBoundsUpgradeMojo().updateDependency(pom, (Artifact)artifact, "[2.6,3)");
        XPathContext context = new XPathContext("mvn", "http://maven.apache.org/POM/4.0.0");
        Nodes versions = pom.query("//mvn:version", context);
        StrictAssertions.assertThat((int)versions.size()).isEqualTo(4);
        Nodes nodes = pom.query("//mvn:version[text()='[2.6,3)']", context);
        StrictAssertions.assertThat((int)nodes.size()).isEqualTo(1);
        Node node = nodes.get(0);
        StrictAssertions.assertThat((String)node.getValue()).isEqualTo((Object)"[2.6,3)");
    }

    @Test
    public void writeNamespacesUnchanged() throws ValidityException, ParsingException, IOException {
        Document pom = new Builder().build(new File(new File("src/it/upgrade"), "pom.xml"));
        StickySerializer s = new StickySerializer(new FileOutputStream(new File("target/tmp.xml")), "UTF-8");
        s.write(pom);
    }
}

