/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.plugin.bounds;

import net.stickycode.plugin.bounds.Changes;
import org.assertj.core.api.StrictAssertions;
import org.junit.Test;

public class ChangesTest {
    @Test
    public void nochange() {
        this.nochange("1.1");
        this.nochange("2.1");
        this.nochange("1.2");
        this.nochange("1");
        this.nochange("11");
        this.nochange("0.1.1");
    }

    private void nochange(String version) {
        StrictAssertions.assertThat((boolean)new Changes().change(version, version)).isFalse();
    }

    @Test
    public void updates() {
        this.updates("1.1", "1.2");
        this.updates("2.1", "2.2");
        this.updates("1.1", "1.11");
    }

    private void updates(String v1, String v2) {
        Changes changes = new Changes();
        StrictAssertions.assertThat((boolean)changes.change(v1, v2)).isTrue();
        StrictAssertions.assertThat((boolean)changes.updated()).isTrue();
        StrictAssertions.assertThat((boolean)changes.upgraded()).isFalse();
    }

    @Test
    public void upgrades() {
        this.upgrades("1.1", "2.2");
        this.upgrades("2.1", "6.2");
        this.upgrades("1.1", "2.1");
        this.upgrades("1.11", "2.12");
        this.upgrades("1.11", "2.1");
    }

    private void upgrades(String v1, String v2) {
        Changes changes = new Changes();
        StrictAssertions.assertThat((boolean)changes.change(v1, v2)).isTrue();
        StrictAssertions.assertThat((boolean)changes.updated()).isTrue();
        StrictAssertions.assertThat((boolean)changes.upgraded()).isTrue();
    }
}

