/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.deploy.tomcat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.naming.directory.DirContext;
import net.stickycode.deploy.tomcat.DeploymentConfiguration;
import net.stickycode.deploy.tomcat.EmbeddedResources;
import net.stickycode.deploy.tomcat.FailedToStartDeploymentException;
import net.stickycode.deploy.tomcat.FailedToStopDeploymentException;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Embedded;

public class TomcatDeployer {
    private EmbeddedDeployer container;
    private Engine engine;
    private StandardHost host;
    private final Loader loader;
    private final DeploymentConfiguration configuration;

    public TomcatDeployer(DeploymentConfiguration configuration, Loader loader) {
        this.loader = loader;
        this.configuration = configuration;
    }

    public void deploy() {
        this.createContainer();
        this.createEngine();
        this.createDefaultHost();
        this.createContextForWar();
        this.listenToHttpOnPort();
        try {
            this.container.start();
        }
        catch (LifecycleException e) {
            throw new FailedToStartDeploymentException(e);
        }
        if (!this.container.isStarted()) {
            throw new FailedToStartDeploymentException();
        }
        this.verifyListening();
    }

    private void verifyListening() {
        try {
            Socket s = new Socket(this.configuration.getBindAddress(), this.configuration.getPort());
            PrintWriter w = new PrintWriter(s.getOutputStream());
            w.print("OPTIONS * HTTP/1.1\r\nHOST: web\r\n\r\n");
            w.flush();
            BufferedReader r = new BufferedReader(new InputStreamReader(s.getInputStream(), "UTF-8"));
            String pingResult = r.readLine();
            s.close();
            if (!"HTTP/1.1 200 OK".equals(pingResult)) {
                throw new FailedToStartDeploymentException("Options test after start returned '" + pingResult + "'");
            }
        }
        catch (UnknownHostException e) {
            throw new FailedToStartDeploymentException(e);
        }
        catch (IOException e) {
            throw new FailedToStartDeploymentException(e);
        }
    }

    private void listenToHttpOnPort() {
        Connector connector = this.container.createConnector(this.configuration.getBindAddress(), this.configuration.getPort(), "http");
        this.container.addConnector(connector);
    }

    private void createContextForWar() {
        StandardContext context = new StandardContext();
        context.setDocBase(this.configuration.getDocumentBase());
        context.setPath(this.configuration.getContextPath());
        context.setResources((DirContext)new EmbeddedResources());
        context.setLoader(this.loader);
        context.setProcessTlds(false);
        context.setTldNamespaceAware(false);
        context.setAntiResourceLocking(false);
        ContextConfig listener = new ContextConfig();
        listener.setDefaultWebXml("META-INF/sticky/stripped-web.xml");
        context.addLifecycleListener((LifecycleListener)listener);
        this.host.addChild((Container)context);
    }

    private void createDefaultHost() {
        this.host = new StandardHost();
        this.host.setName("sticky-host");
        this.host.setUnpackWARs(false);
        this.host.setCreateDirs(false);
        this.engine.addChild((Container)this.host);
        this.engine.setDefaultHost(this.host.getName());
    }

    private void createEngine() {
        this.engine = this.container.createEngine();
        this.engine.setName("sticky-" + System.currentTimeMillis());
        this.engine.setService((Service)this.container);
        this.container.addEngine(this.engine);
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (LifecycleException e) {
            throw new FailedToStopDeploymentException(e);
        }
    }

    private void createContainer() {
        this.container = new EmbeddedDeployer();
        this.container.setName("sticky-container");
        this.container.setUseNaming(true);
        this.container.setCatalinaHome(this.configuration.getWorkingDirectory().getAbsolutePath());
        this.container.setCatalinaBase(this.configuration.getWorkingDirectory().getAbsolutePath());
    }

    public class EmbeddedDeployer
    extends Embedded {
        boolean started = false;

        public boolean isStarted() {
            return this.started;
        }

        protected void startInternal() throws LifecycleException {
            super.startInternal();
            this.started = true;
        }
    }
}

