/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.deploy.tomcat;

import net.stickycode.deploy.signal.StickyShutdownHandler;
import net.stickycode.deploy.signal.StickySignalTrap;
import net.stickycode.deploy.tomcat.EmbeddedDeploymentConfiguration;
import net.stickycode.deploy.tomcat.EmbeddedWebappLoader;
import net.stickycode.deploy.tomcat.TomcatDeployer;
import net.stickycode.deploy.tomcat.TomcatShutdownHandler;

public class EmbeddedTomcat {
    public static void main(String[] args) {
        System.out.println("Configuring Embedded Tomcat ");
        EmbeddedDeploymentConfiguration configuration = new EmbeddedDeploymentConfiguration();
        TomcatDeployer deployer = new TomcatDeployer(configuration, new EmbeddedWebappLoader());
        System.out.println("Starting Embedded Tomcat");
        EmbeddedTomcat.launch(deployer, new TomcatShutdownHandler(deployer));
    }

    private static void launch(TomcatDeployer deployer, TomcatShutdownHandler tomcatShutdownHandler) {
        long time = System.currentTimeMillis();
        deployer.deploy();
        System.out.println("started in " + (System.currentTimeMillis() - time) + "ms");
        System.out.println("CTRL-C to exit");
        StickySignalTrap trap = EmbeddedTomcat.signalTrap();
        trap.shutdown((StickyShutdownHandler)tomcatShutdownHandler);
        trap.noHangup();
        trap.waitForExit();
    }

    public static StickySignalTrap signalTrap() {
        return new StickySignalTrap();
    }
}

