/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(StaticServlet.class);
    protected static final int bufferSize = 4096;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.lookup(req).respondGet(resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doGet(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        try {
            this.lookup(req).respondHead(resp);
        }
        catch (UnsupportedOperationException e) {
            super.doHead(req, resp);
        }
    }

    protected long getLastModified(HttpServletRequest req) {
        return this.lookup(req).getLastModified();
    }

    protected LookupResult lookup(HttpServletRequest req) {
        LookupResult r = (LookupResult)req.getAttribute("lookupResult");
        if (r == null) {
            r = this.lookupNoCache(req);
            req.setAttribute("lookupResult", (Object)r);
        }
        return r;
    }

    protected LookupResult lookupNoCache(HttpServletRequest req) {
        URL url;
        String path = this.getPath(req);
        if (this.isForbidden(path)) {
            return new Error(403, "Forbidden");
        }
        try {
            url = this.getServletContext().getResource(path);
        }
        catch (MalformedURLException e) {
            return new Error(400, "Malformed path");
        }
        if (url == null) {
            return new Error(404, "Not found");
        }
        String mimeType = this.getMimeType(path);
        String realpath = this.getServletContext().getRealPath(path);
        if (realpath != null) {
            File f = new File(realpath);
            if (!f.isFile()) {
                return new Error(403, "Forbidden");
            }
            return new StaticFile(f.lastModified(), mimeType, (int)f.length(), StaticServlet.acceptsDeflate(req), url);
        }
        try {
            JarEntry ze = ((JarURLConnection)url.openConnection()).getJarEntry();
            if (ze != null) {
                if (ze.isDirectory()) {
                    return new Error(403, "Forbidden");
                }
                return new StaticFile(ze.getTime(), mimeType, (int)ze.getSize(), StaticServlet.acceptsDeflate(req), url);
            }
            return new StaticFile(-1L, mimeType, -1, StaticServlet.acceptsDeflate(req), url);
        }
        catch (ClassCastException e) {
            return new StaticFile(-1L, mimeType, -1, StaticServlet.acceptsDeflate(req), url);
        }
        catch (IOException e) {
            return new Error(500, "Internal server error");
        }
    }

    protected String getPath(HttpServletRequest req) {
        String servletPath = req.getServletPath();
        String pathInfo = StaticServlet.coalesce(req.getPathInfo(), "");
        return servletPath + pathInfo;
    }

    protected boolean isForbidden(String path) {
        String lpath = path.toLowerCase();
        return lpath.startsWith("/web-inf/") || lpath.startsWith("/meta-inf/");
    }

    public static <T> T coalesce(T ... ts) {
        for (T t : ts) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    protected String getMimeType(String path) {
        String defaultMimeType = "application/octet-stream";
        if (this.getServletConfig().getInitParameter("defaultMimeType").length() > 0) {
            defaultMimeType = this.getServletConfig().getInitParameter("defaultMimeType");
        }
        return StaticServlet.coalesce(this.getServletContext().getMimeType(path), defaultMimeType);
    }

    protected static boolean acceptsDeflate(HttpServletRequest req) {
        String ae = req.getHeader("Accept-Encoding");
        return ae != null && ae.contains("gzip");
    }

    protected static boolean deflatable(String mimetype) {
        return mimetype.startsWith("text/") || mimetype.equals("application/json") || mimetype.equals("application/postscript") || mimetype.startsWith("application/ms") || mimetype.startsWith("application/vnd") || mimetype.endsWith("xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void transferStreams(InputStream is, OutputStream os) throws IOException {
        try {
            int bytesRead;
            byte[] buf = new byte[4096];
            while ((bytesRead = is.read(buf)) != -1) {
                os.write(buf, 0, bytesRead);
            }
        }
        finally {
            is.close();
            os.close();
        }
    }

    public static class StaticFile
    implements LookupResult {
        protected final long lastModified;
        protected final String mimeType;
        protected final int contentLength;
        protected final boolean acceptsDeflate;
        protected final URL url;

        public StaticFile(long lastModified, String mimeType, int contentLength, boolean acceptsDeflate, URL url) {
            this.lastModified = lastModified;
            this.mimeType = mimeType;
            this.contentLength = contentLength;
            this.acceptsDeflate = acceptsDeflate;
            this.url = url;
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        protected boolean willDeflate() {
            return this.acceptsDeflate && StaticServlet.deflatable(this.mimeType);
        }

        protected void setHeaders(HttpServletResponse resp) {
            resp.setStatus(200);
            resp.setContentType(this.mimeType);
            if (this.contentLength >= 0 && !this.willDeflate()) {
                resp.setContentLength(this.contentLength);
            }
        }

        @Override
        public void respondGet(HttpServletResponse resp) throws IOException {
            Object os;
            this.setHeaders(resp);
            if (this.willDeflate()) {
                resp.setHeader("Content-Encoding", "gzip");
                os = new GZIPOutputStream((OutputStream)resp.getOutputStream(), 4096);
            } else {
                os = resp.getOutputStream();
            }
            StaticServlet.transferStreams(this.url.openStream(), (OutputStream)os);
        }

        @Override
        public void respondHead(HttpServletResponse resp) {
            if (this.willDeflate()) {
                throw new UnsupportedOperationException();
            }
            this.setHeaders(resp);
        }
    }

    public static class Error
    implements LookupResult {
        protected final int statusCode;
        protected final String message;

        public Error(int statusCode, String message) {
            this.statusCode = statusCode;
            this.message = message;
        }

        @Override
        public long getLastModified() {
            return -1L;
        }

        @Override
        public void respondGet(HttpServletResponse resp) throws IOException {
            resp.sendError(this.statusCode, this.message);
        }

        @Override
        public void respondHead(HttpServletResponse resp) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface LookupResult {
        public void respondGet(HttpServletResponse var1) throws IOException;

        public void respondHead(HttpServletResponse var1);

        public long getLastModified();
    }
}

