/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.config.dataSource.database;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import javax.sql.DataSource;
import net.stepniak.api.config.dataSource.ConnectionData;
import net.stepniak.api.config.dataSource.DatabaseConfig;
import net.stepniak.api.config.dataSource.connectionData.ConnectionDataConfigInterface;
import net.stepniak.api.config.dataSource.database.DatabaseConfigInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"mysql"})
public class MysqlDatabaseConfig
implements DatabaseConfigInterface {
    private static final Logger logger = LoggerFactory.getLogger(MysqlDatabaseConfig.class);
    @Autowired
    private ConnectionDataConfigInterface connectionDataConfig;

    @Override
    @Bean
    public DatabaseConfig databaseConfig() {
        logger.debug("connect to myql");
        ConnectionData connectionData = this.connectionDataConfig.connectionData();
        String dbUrl = "jdbc:mysql://" + connectionData.getDbHost() + connectionData.getDbPath();
        try {
            ComboPooledDataSource ds = new ComboPooledDataSource();
            ds.setDriverClass("com.mysql.jdbc.Driver");
            ds.setJdbcUrl(dbUrl);
            ds.setUser(connectionData.getDbUsername());
            ds.setPassword(connectionData.getDbPassword());
            return new DatabaseConfig("mysql-unit", (DataSource)ds);
        }
        catch (Exception e) {
            logger.warn("unable to connect mysql ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

