/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.config.dataSource.connectionData;

import java.net.URI;
import net.stepniak.api.config.dataSource.ConnectionData;
import net.stepniak.api.config.dataSource.connectionData.ConnectionDataConfigInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"heroku"})
class HerokuConnectionDataConfig
implements ConnectionDataConfigInterface {
    private static final Logger logger = LoggerFactory.getLogger(HerokuConnectionDataConfig.class);

    HerokuConnectionDataConfig() {
    }

    @Override
    @Bean
    public ConnectionData connectionData() {
        logger.debug("connectionData on heroku");
        try {
            String databaseUrl = System.getenv("DATABASE_URL");
            URI dbUri = new URI(databaseUrl);
            String username = dbUri.getUserInfo().split(":")[0];
            String password = dbUri.getUserInfo().split(":")[1];
            return new ConnectionData(username, password, dbUri.getHost(), dbUri.getPath());
        }
        catch (Exception e) {
            logger.error("failed to connect on heroku", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

