/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.config.dataSource;

import java.net.URISyntaxException;
import net.stepniak.api.config.dataSource.DatabaseConfig;
import net.stepniak.api.config.dataSource.database.DatabaseConfigInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(value={"net.stepniak.api"})
@Profile(value={"mysql", "postgres"})
public abstract class DataSourceConfig
extends WebMvcConfigurerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceConfig.class);
    @Autowired
    private DatabaseConfigInterface databaseConfig;

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory() throws URISyntaxException {
        logger.debug("init entity manager factory");
        if (this.databaseConfig == null) {
            throw new RuntimeException("Missing configuration for storage (pick mysql, postgres or memory)");
        }
        DatabaseConfig database = this.databaseConfig.databaseConfig();
        HibernateJpaVendorAdapter vendor = new HibernateJpaVendorAdapter();
        vendor.setShowSql(false);
        vendor.setGenerateDdl(true);
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendor);
        em.setPackagesToScan(new String[]{"net.stepniak.api"});
        em.setDataSource(database.getDataSource());
        em.setPersistenceUnitName(database.getPersistenceUnitName());
        em.afterPropertiesSet();
        return em;
    }

    @Bean
    public JpaTransactionManager transactionManager() throws URISyntaxException {
        logger.debug("init transaction manager");
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(this.entityManagerFactory().getObject());
        return transactionManager;
    }
}

