/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.config;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;
import org.springframework.web.servlet.mvc.annotation.ResponseStatusExceptionResolver;

public class ApplicationContext
extends WebMvcConfigurerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationContext.class);

    @Bean
    public static PropertySourcesPlaceholderConfigurer properties() {
        logger.debug("load spring.properties");
        PropertySourcesPlaceholderConfigurer propertySources = new PropertySourcesPlaceholderConfigurer();
        ClassPathResource[] resources = new ClassPathResource[]{new ClassPathResource("spring.properties")};
        propertySources.setLocations((Resource[])resources);
        propertySources.setIgnoreUnresolvablePlaceholders(true);
        return propertySources;
    }

    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
        configurer.enable();
    }

    public void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        exceptionResolvers.add((HandlerExceptionResolver)new ResponseStatusExceptionResolver());
        SimpleMappingExceptionResolver simpleMappingExceptionResolver = new SimpleMappingExceptionResolver();
        exceptionResolvers.add((HandlerExceptionResolver)simpleMappingExceptionResolver);
        super.configureHandlerExceptionResolvers(exceptionResolvers);
    }
}

