/*
 * Decompiled with CFR 0.152.
 */
package net.stamfest.rrd;

import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.stamfest.rrd.CommandResult;
import net.stamfest.rrd.RRD;
import net.stamfest.rrd.RRDCachedClient;
import net.stamfest.rrd.RRDCommand;
import net.stamfest.rrd.RRDCommandPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RRDToolService
implements RRD {
    RRDCommandPool pool;
    private RRDCachedClient cachedClient = null;
    static final String[] pwd = new String[]{"pwd"};

    public RRDToolService(RRDCommandPool pool) {
        this.pool = pool;
    }

    @Override
    public CommandResult info(String filename) throws Exception {
        return this.pool.command(new String[]{"info", filename});
    }

    public CommandResult update(String filename, String arg) throws Exception {
        if (this.cachedClient != null) {
            return this.cachedClient.update(filename, new String[]{arg});
        }
        String[] cmd = new String[]{"update", filename, arg};
        return this.pool.command(cmd);
    }

    @Override
    public CommandResult update(String filename, String[] args) throws Exception {
        String[] cmd = new String[args.length + 2];
        cmd[0] = "update";
        cmd[1] = filename;
        int i = 0;
        int j = 2;
        while (i < args.length) {
            cmd[j] = args[i];
            ++i;
            ++j;
        }
        return this.pool.command(cmd);
    }

    @Override
    public CommandResult graphv(String[] cmdin) throws Exception {
        String[] cmd = new String[cmdin.length + 2];
        cmd[0] = "graphv";
        cmd[1] = "-";
        int i = 0;
        int j = 2;
        while (i < cmdin.length) {
            cmd[j] = cmdin[i];
            ++i;
            ++j;
        }
        return this.pool.command(cmd);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.pool.finish();
    }

    public static String getCwd(RRDCommand rrdcmd) throws Exception {
        CommandResult r = rrdcmd.command(pwd);
        if (!r.ok) {
            throw new Exception("Problem executing 'pwd' command");
        }
        return r.output.trim();
    }

    public static boolean chdir(RRDCommand rrdcmd, String dir) throws Exception {
        String[] cmd = new String[]{"cd", dir};
        CommandResult r = rrdcmd.command(cmd);
        return r.ok;
    }

    private List<String> splitFilename(String filename) {
        int i;
        ArrayList<String> l = new ArrayList<String>();
        int st = 0;
        int len = filename.length();
        for (i = 0; i < len; ++i) {
            if (filename.charAt(i) != File.separatorChar) continue;
            if (st != i) {
                this.addPathElement(l, filename.substring(st, i));
            }
            st = i + 1;
        }
        if (st != i) {
            this.addPathElement(l, filename.substring(st, i));
        }
        return l;
    }

    private void addPathElement(ArrayList<String> l, String e) {
        if (!e.equals(".")) {
            if (e.equals("..")) {
                if (l.size() > 0) {
                    l.remove(l.size() - 1);
                }
            } else {
                l.add(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CommandResult create(String filename, String[] args) throws Exception {
        List<String> pel = this.splitFilename(filename);
        RRDCommand rrdcmd = this.pool.getConnection();
        String cwd = null;
        try {
            cwd = RRDToolService.getCwd(rrdcmd);
            if (pel.size() > 0) {
                pel.remove(pel.size() - 1);
            }
            for (String pe : pel) {
                if (RRDToolService.chdir(rrdcmd, pe)) continue;
                if (!RRDToolService.mkdir(rrdcmd, pe)) {
                    throw new Exception("Cannot mkdir directory");
                }
                RRDToolService.chdir(rrdcmd, pe);
            }
        }
        catch (Throwable throwable) {
            try {
                if (cwd == null) throw throwable;
                rrdcmd.command(new String[]{"cd", cwd});
                throw throwable;
            }
            finally {
                this.pool.done(rrdcmd);
            }
        }
        try {
            if (cwd != null) {
                rrdcmd.command(new String[]{"cd", cwd});
            }
        }
        finally {
            this.pool.done(rrdcmd);
        }
        String[] cmd = new String[args.length + 2];
        cmd[0] = "create";
        cmd[1] = filename;
        int i = 0;
        int j = 2;
        while (i < args.length) {
            cmd[j] = args[i];
            ++i;
            ++j;
        }
        return this.pool.command(cmd);
    }

    @Override
    public CommandResult tune(String filename, String[] args) throws Exception {
        String[] cmd = new String[args.length + 2];
        cmd[0] = "tune";
        cmd[1] = filename;
        int i = 0;
        int j = 2;
        while (i < args.length) {
            cmd[j] = args[i];
            ++i;
            ++j;
        }
        return this.pool.command(cmd);
    }

    public static boolean mkdir(RRDCommand rrdcmd, String dir) throws Exception {
        CommandResult r = rrdcmd.command(new String[]{"mkdir", dir});
        if (r == null) {
            return false;
        }
        return r.ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String filename) throws Exception {
        if (!filename.endsWith(".rrd")) {
            throw new Exception("Can only check for the existance of .rrd files");
        }
        File f = new File(filename);
        File dir = f.getParentFile();
        String dirstr = dir.getPath();
        String await = "- " + f.getName();
        RRDCommand rrdcmd = this.pool.getConnection();
        String current = null;
        try {
            String line;
            current = RRDToolService.getCwd(rrdcmd);
            String[] cmd = new String[]{"ls"};
            if (!RRDToolService.chdir(rrdcmd, dirstr)) {
                boolean bl = false;
                return bl;
            }
            CommandResult r = rrdcmd.command(cmd);
            if (!r.ok) {
                boolean bl = false;
                return bl;
            }
            BufferedReader br = new BufferedReader(new StringReader(r.output));
            while ((line = br.readLine()) != null) {
                if (!line.equals(await)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (current != null) {
                    RRDToolService.chdir(rrdcmd, current);
                }
            }
            finally {
                this.pool.done(rrdcmd);
            }
        }
    }

    public RRDCachedClient getCachedClient() {
        return this.cachedClient;
    }

    public void setCachedClient(RRDCachedClient cachedClient) {
        this.cachedClient = cachedClient;
    }
}

