/*
 * Decompiled with CFR 0.152.
 */
package net.stamfest.rrd;

import net.stamfest.rrd.CommandResult;
import net.stamfest.rrd.RRDCommand;
import net.stamfest.rrd.RRDCommandFactory;
import net.stamfest.rrd.RRDPoolMember;
import net.stamfest.rrd.RRDPoolMemberWrapper;
import net.stamfest.rrd.RRDp;

public class RRDCommandPool
implements RRDCommand {
    private int poolsize = 4;
    private int maxRequestsPerMember = 100;
    private boolean finished = false;
    private RRDCommandFactory factory = null;
    RRDPoolMember[] pool = null;

    public RRDCommandPool(String basedir, String cachedAddress) {
        this.init(4, basedir, cachedAddress);
    }

    public RRDCommandPool(int poolsize, String basedir, String cachedAddress) {
        this.init(poolsize, basedir, cachedAddress);
    }

    public RRDCommandPool(int poolsize, RRDCommandFactory factory) {
        this.init(poolsize, factory);
    }

    private void init(int poolsize, final String basedir, final String cachedAddress) {
        this.init(poolsize, new RRDCommandFactory(){

            public RRDp createRRDCommand() throws Exception {
                return new RRDp(basedir, cachedAddress);
            }
        });
    }

    private void init(int poolsize, RRDCommandFactory factory) {
        this.poolsize = poolsize;
        this.factory = factory;
        this.pool = new RRDPoolMember[poolsize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RRDCommand getConnection() throws Exception {
        if (this.finished) {
            throw new Exception("Already finished");
        }
        RRDPoolMember member = null;
        RRDCommandPool rRDCommandPool = this;
        synchronized (rRDCommandPool) {
            while (true) {
                for (int i = 0; i < this.poolsize; ++i) {
                    if (this.pool[i] == null) {
                        this.pool[i] = new RRDPoolMember();
                        member = this.pool[i];
                        break;
                    }
                    if (this.pool[i].inuse) continue;
                    member = this.pool[i];
                    break;
                }
                if (member != null) break;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            member.inuse = true;
        }
        ++member.requestcount;
        if (member.rrdp == null) {
            member.requestcount = 0;
            member.rrdp = this.factory.createRRDCommand();
        }
        return new RRDPoolMemberWrapper(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(RRDCommand cmd) {
        if (cmd instanceof RRDPoolMemberWrapper) {
            RRDPoolMember member = ((RRDPoolMemberWrapper)cmd).member;
            if (member.requestcount > this.maxRequestsPerMember) {
                if (member.rrdp != null) {
                    member.rrdp.finish();
                }
                member.requestcount = 0;
                member.rrdp = null;
            }
            RRDCommandPool rRDCommandPool = this;
            synchronized (rRDCommandPool) {
                member.inuse = false;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kick(RRDCommand cmd) {
        if (cmd instanceof RRDPoolMemberWrapper) {
            RRDPoolMember member = ((RRDPoolMemberWrapper)cmd).member;
            if (member.rrdp != null) {
                member.rrdp.finish();
            }
            member.requestcount = 0;
            member.rrdp = null;
            RRDCommandPool rRDCommandPool = this;
            synchronized (rRDCommandPool) {
                member.inuse = false;
                this.notify();
            }
        }
    }

    public CommandResult command(String[] cmd) throws Exception {
        RRDCommand rrdcmd = this.getConnection();
        try {
            CommandResult commandResult = rrdcmd.command(cmd);
            return commandResult;
        }
        catch (Exception e) {
            this.kick(rrdcmd);
            throw e;
        }
        finally {
            this.done(rrdcmd);
        }
    }

    public int getMaxRequestsPerMember() {
        return this.maxRequestsPerMember;
    }

    public void setMaxRequestsPerMember(int maxRequestsPerMember) {
        this.maxRequestsPerMember = maxRequestsPerMember;
    }

    public int getPoolsize() {
        return this.poolsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        this.finished = true;
        RRDCommandPool rRDCommandPool = this;
        synchronized (rRDCommandPool) {
            boolean alldone = false;
            block5: while (!alldone) {
                alldone = true;
                for (int i = 0; i < this.poolsize; ++i) {
                    if (this.pool[i] == null) continue;
                    if (!this.pool[i].inuse) {
                        if (this.pool[i].rrdp == null) continue;
                        this.pool[i].rrdp.finish();
                        this.pool[i].rrdp = null;
                        this.pool[i] = null;
                        continue;
                    }
                    alldone = false;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                    continue block5;
                }
            }
        }
    }

    public RRDCommandFactory getFactory() {
        return this.factory;
    }

    public void setFactory(RRDCommandFactory factory) {
        this.factory = factory;
    }
}

