/*
 * Decompiled with CFR 0.152.
 */
package net.stamfest.rrd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.stamfest.rrd.CommandResult;
import net.stamfest.rrd.RRDUpdate;

public class RRDCachedClient
implements RRDUpdate {
    private Socket socket;
    private OutputStream writer;
    private InputStream reader;
    private String host;
    private int port;
    private static Pattern response = Pattern.compile("^(-?\\d+) (.*)$");

    public RRDCachedClient(String host, int port) throws UnknownHostException, IOException {
        this.init(host, port);
    }

    private void init(String host, int port) throws UnknownHostException, IOException {
        this.host = host;
        this.port = port;
        this.socket = new Socket(host, port);
        this.socket.setKeepAlive(true);
        this.socket.setSoTimeout(60000);
        this.writer = this.socket.getOutputStream();
        this.reader = this.socket.getInputStream();
    }

    private void reconnect() throws UnknownHostException, IOException {
        try {
            this.writer = null;
            this.reader = null;
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init(this.host, this.port);
    }

    private String readLine() throws IOException {
        int c;
        byte[] b = new byte[128];
        int pos = 0;
        while ((c = this.reader.read()) != -1 && c != 10) {
            if (pos == b.length) {
                b = Arrays.copyOf(b, b.length * 2);
            }
            b[pos++] = (byte)c;
        }
        return new String(b, 0, pos);
    }

    private synchronized CommandResult sendCommand(String[] cmd1, String[] cmd2) throws Exception {
        CommandResult r;
        block21: {
            int i;
            if (this.writer == null) {
                this.reconnect();
            }
            r = new CommandResult();
            StringBuffer sb = new StringBuffer();
            if (cmd1 != null) {
                for (i = 0; i < cmd1.length; ++i) {
                    if (sb.length() > 0) {
                        sb.append(' ');
                    }
                    sb.append(cmd1[i]);
                }
            }
            if (cmd2 != null) {
                for (i = 0; i < cmd2.length; ++i) {
                    if (sb.length() > 0) {
                        sb.append(' ');
                    }
                    sb.append(cmd2[i]);
                }
            }
            if (sb.length() == 0) {
                return null;
            }
            sb.append('\n');
            try {
                this.writer.write(sb.toString().getBytes());
                this.writer.flush();
            }
            catch (Exception e) {
                this.reconnect();
                if (this.writer == null) {
                    throw e;
                }
                this.writer.write(sb.toString().getBytes());
                this.writer.flush();
            }
            try {
                String line = this.readLine();
                Matcher m = response.matcher(line);
                if (m.find()) {
                    int rc = Integer.parseInt(m.group(1));
                    r.error = line;
                    if (rc < 0) {
                        r.ok = false;
                    } else {
                        sb.setLength(0);
                        r.ok = true;
                        while (rc-- > 0) {
                            sb.append(this.readLine()).append('\n');
                        }
                        r.output = sb.toString();
                    }
                    break block21;
                }
                try {
                    this.writer = null;
                    this.reader = null;
                    this.socket.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw new Exception("Protocol error");
            }
            catch (Exception e) {
                try {
                    this.writer = null;
                    this.reader = null;
                    this.socket.close();
                    throw e;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }
        return r;
    }

    public CommandResult update(String filename, String[] args) throws Exception {
        return this.sendCommand(new String[]{"UPDATE", filename}, args);
    }

    public CommandResult flush(String filename) throws Exception {
        return this.sendCommand(new String[]{"FLUSH", filename}, null);
    }

    public CommandResult flushall(String filename) throws Exception {
        return this.sendCommand(new String[]{"FLUSHALL"}, null);
    }

    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
        this.writer = null;
        this.reader = null;
    }
}

