/*
 * Decompiled with CFR 0.152.
 */
package net.sozal.stackwriter.api.domain;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sozal.stackwriter.api.domain.LocalVariable;

public final class Frame {
    private final Class clazz;
    private final Method method;
    private final int line;
    private final LocalVariable[] locals;

    public Frame(Class<?> clazz, Method method, int line, LocalVariable[] locals) {
        this.clazz = clazz;
        this.method = method;
        this.line = line;
        this.locals = locals;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public Method getMethod() {
        return this.method;
    }

    public int getLine() {
        return this.line;
    }

    public Map<String, LocalVariable> getLocals() {
        if (this.locals == null || this.locals.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, LocalVariable> localsMap = new HashMap<String, LocalVariable>();
        for (LocalVariable localVariable : this.locals) {
            if (localVariable == null) continue;
            localsMap.put(localVariable.getName(), localVariable);
        }
        return localsMap;
    }

    public String toString() {
        return "Frame{class=" + this.clazz.getName() + ", method=" + this.method.getDeclaringClass().getName() + "." + this.method.getName() + ", lineNo=" + this.line + ", locals=" + Arrays.toString(this.locals) + '}';
    }
}

