/*
 * Decompiled with CFR 0.152.
 */
package net.sozal.stackwriter.api;

import net.sozal.stackwriter.api.ErrorFilter;
import net.sozal.stackwriter.api.ErrorListener;
import net.sozal.stackwriter.api.domain.Frame;
import net.sozal.stackwriter.api.internal.StackWriterService;

public final class StackWriter {
    private static StackWriterService stackWriterService = new NoOpStackWriterService();

    private StackWriter() {
    }

    public static StackWriterService getStackWriterService() {
        return stackWriterService;
    }

    public static void setStackWriterService(StackWriterService stackWriterService) {
        StackWriter.stackWriterService = stackWriterService;
    }

    public static Frame[] takeSnapshot() {
        return stackWriterService.takeSnapshot();
    }

    public static Frame[] takeSnapshot(int startDepth, int maxFrameCount) {
        return stackWriterService.takeSnapshot(startDepth, maxFrameCount);
    }

    public static Frame[] takeSnapshotWithStartDepth(int startDepth) {
        return stackWriterService.takeSnapshotWithStartDepth(startDepth);
    }

    public static Frame[] takeSnapshotWithMaxFrameCount(int maxFrameCount) {
        return stackWriterService.takeSnapshotWithMaxFrameCount(maxFrameCount);
    }

    public static void addAppPackage(String newAppPackage) {
        stackWriterService.addAppPackage(newAppPackage);
    }

    public static void addIgnoredExceptionType(Class<? extends Throwable> exceptionType) {
        stackWriterService.addIgnoredExceptionType(exceptionType);
    }

    public static void useErrorFilter(ErrorFilter errorFilter) {
        stackWriterService.useErrorFilter(errorFilter);
    }

    public static void registerErrorListener(ErrorListener errorListener) {
        stackWriterService.registerErrorListener(errorListener);
    }

    private static class NoOpStackWriterService
    implements StackWriterService {
        private static final Frame[] EMPTY_FRAME = new Frame[0];

        private NoOpStackWriterService() {
        }

        @Override
        public Frame[] takeSnapshot() {
            return EMPTY_FRAME;
        }

        @Override
        public Frame[] takeSnapshot(int startDepth, int maxFrameCount) {
            return EMPTY_FRAME;
        }

        @Override
        public Frame[] takeSnapshotWithStartDepth(int startDepth) {
            return EMPTY_FRAME;
        }

        @Override
        public Frame[] takeSnapshotWithMaxFrameCount(int maxFrameCount) {
            return EMPTY_FRAME;
        }

        @Override
        public void addAppPackage(String appPackage) {
        }

        @Override
        public void addIgnoredExceptionType(Class<? extends Throwable> exceptionType) {
        }

        @Override
        public void useErrorFilter(ErrorFilter errorFilter) {
        }

        @Override
        public void registerErrorListener(ErrorListener errorListener) {
        }
    }
}

