package net.sozal.stackwriter.api.internal;

import net.sozal.stackwriter.api.ErrorFilter;
import net.sozal.stackwriter.api.ErrorListener;
import net.sozal.stackwriter.api.domain.Frame;

/**
 * @author serkan
 */
public interface StackWriterService {

    Frame[] takeSnapshot();
    Frame[] takeSnapshot(int startDepth, int maxFrameCount);
    Frame[] takeSnapshotWithStartDepth(int startDepth);
    Frame[] takeSnapshotWithMaxFrameCount(int maxFrameCount);

    void addAppPackage(String appPackage);
    void addIgnoredExceptionType(Class<? extends Throwable> exceptionType);
    void useErrorFilter(ErrorFilter errorFilter);
    void registerErrorListener(ErrorListener errorListener);

}
