package net.sozal.stackwriter.api.domain;

/**
 * @author serkan
 */
public class LocalVariable {

    private final String name;
    private final Object value;
    private final Class<?> type;

    public LocalVariable(String name, Object value, char typeSignature) {
        this.name = name;
        this.value = value;
        this.type = getType(value, typeSignature);
    }

    private static Class<?> getType(Object value, char typeSignature) {
        switch(typeSignature) {
            case 'B':
                return byte.class;
            case 'Z':
                return boolean.class;
            case 'C':
                return char.class;
            case 'S':
                return short.class;
            case 'I':
                return int.class;
            case 'F':
                return float.class;
            case 'J':
                return long.class;
            case 'D':
                return double.class;
            default:
                return value != null ? value.getClass() : null;
        }
    }

    public String getName() {
        return name;
    }

    public Object getValue() {
        return value;
    }

    public Class<?> getType() {
        return type;
    }

    @Override
    public String toString() {
        return "LocalVariable{"
                + "name='" + name + '\''
                + ", value=" + value
                + ", type=" + (type != null ? type.getName() : "?")
                + '}';
    }

}
