package net.sozal.stackwriter.api.domain;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author serkan
 */
public final class Frame {

    private final Class clazz;
    private final Method method;
    private final int line;
    private final LocalVariable[] locals;

    public Frame(Class<?> clazz, Method method, int line, LocalVariable[] locals) {
        this.clazz = clazz;
        this.method = method;
        this.line = line;
        this.locals = locals;
    }

    public Class getClazz() {
        return clazz;
    }

    public Method getMethod() {
        return method;
    }

    public int getLine() {
        return line;
    }

    public Map<String, LocalVariable> getLocals() {
        if (locals == null || locals.length == 0) {
            return Collections.emptyMap();
        }

        Map<String, LocalVariable> localsMap = new HashMap<>();
        for (LocalVariable localVariable : locals) {
            if (localVariable != null) {
                localsMap.put(localVariable.getName(), localVariable);
            }
        }

        return localsMap;
    }

    @Override
    public String toString() {
        return "Frame{"
            + "class=" + clazz.getName()
            + ", method=" + method.getDeclaringClass().getName() + "." + method.getName()
            + ", lineNo=" + line
            + ", locals=" + Arrays.toString(locals)
            + '}';
    }

}
