/*
 * Decompiled with CFR 0.152.
 */
package net.sozal.stackwriter.api.domain;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Frame {
    private final Class clazz;
    private final Method method;
    private final int line;
    private final LocalVariable[] locals;

    public Frame(Class<?> clazz, Method method, int line, LocalVariable[] locals) {
        this.clazz = clazz;
        this.method = method;
        this.line = line;
        this.locals = locals;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public Method getMethod() {
        return this.method;
    }

    public int getLine() {
        return this.line;
    }

    public Map<String, LocalVariable> getLocals() {
        if (this.locals == null || this.locals.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, LocalVariable> localsMap = new HashMap<String, LocalVariable>();
        for (LocalVariable localVariable : this.locals) {
            if (localVariable == null) continue;
            localsMap.put(localVariable.getName(), localVariable);
        }
        return localsMap;
    }

    public String toString() {
        return "Frame{class=" + this.clazz.getName() + ", method=" + this.method.getDeclaringClass().getName() + "." + this.method.getName() + ", lineNo=" + this.line + ", locals=" + Arrays.toString(this.locals) + '}';
    }

    public static final class LocalVariable {
        final String name;
        final Object value;
        final Class<?> type;

        public LocalVariable(String name, Object value, char typeSignature) {
            this.name = name;
            this.value = value;
            this.type = LocalVariable.getType(value, typeSignature);
        }

        private static Class<?> getType(Object value, char typeSignature) {
            switch (typeSignature) {
                case 'B': {
                    return Byte.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
            }
            return value != null ? value.getClass() : null;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String toString() {
            return "LocalVariable{name='" + this.name + '\'' + ", value=" + this.value + ", type=" + (this.type != null ? this.type.getName() : "?") + '}';
        }
    }
}

