package net.sozal.stackwriter.api.domain;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author serkan
 */
public final class Frame {

    private final Method method;
    private final LocalVariable[] locals;

    public Frame(Method method, LocalVariable[] locals) {
        this.method = method;
        this.locals = locals;
    }

    public Method getMethod() {
        return method;
    }

    public Map<String, Object> getLocals() {
        if (locals == null || locals.length == 0) {
            return Collections.emptyMap();
        }

        Map<String, Object> localsMap = new HashMap<>();
        for (Frame.LocalVariable localVariable : locals) {
            if (localVariable != null) {
                localsMap.put(localVariable.getName(), localVariable.getValue());
            }
        }

        return localsMap;
    }

    @Override
    public String toString() {
        return "Frame{"
            + "method=" + method.getDeclaringClass().getName() + "." + method.getName()
            + ", locals=" + Arrays.toString(locals)
            + '}';
    }

    public static final class LocalVariable {

        final String name;
        final Object value;

        public LocalVariable(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return name;
        }

        public Object getValue() {
            return value;
        }

        @Override
        public String toString() {
            return "LocalVariable{"
                + "name='" + name + '\''
                + ", value=" + value
                + '}';
        }

    }

}
