/*
 * Decompiled with CFR 0.152.
 */
package net.sozal.stackwriter.agent;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sozal.stackwriter.agent.logger.Logger;
import net.sozal.stackwriter.api.ErrorFilter;
import net.sozal.stackwriter.api.ErrorListener;
import net.sozal.stackwriter.api.domain.Frame;

public final class ExceptionSnapshotSupport {
    private static final ThreadLocal<WeakHashMap<Throwable, Frame[]>> cache;
    private static final ThreadLocal<Boolean> onErrorInProgress;
    private static final Set<String> appPackages;
    private static final Set<Class<? extends Throwable>> ignoredExceptionTypes;
    private static ErrorFilter errorFilter;
    private static final List<ErrorListener> errorListeners;

    private ExceptionSnapshotSupport() {
    }

    public static boolean shouldTakeSnapshot(Throwable error, int numFrames) {
        if (Boolean.TRUE.equals(onErrorInProgress.get())) {
            return false;
        }
        if (ignoredExceptionTypes.contains(error.getClass())) {
            return false;
        }
        try {
            ErrorFilter ef = errorFilter;
            if (appPackages.isEmpty() && ef == null) {
                return false;
            }
            Map weakMap = cache.get();
            Frame[] existing = (Frame[])weakMap.get(error);
            if (existing != null && numFrames <= existing.length) {
                return false;
            }
            if (!appPackages.isEmpty()) {
                boolean inAppPackages = false;
                block2: for (StackTraceElement stackTraceElement : error.getStackTrace()) {
                    for (String appFrame : appPackages) {
                        if (!stackTraceElement.getClassName().startsWith(appFrame)) continue;
                        inAppPackages = true;
                        continue block2;
                    }
                }
                if (!inAppPackages) {
                    return false;
                }
            }
            if (ef == null) {
                return true;
            }
            return ef.shouldTakeSnapshot(error);
        }
        catch (Throwable t) {
            Logger.error("<ExceptionSnapshotSupport> Error occurred while checking whether snapshot should be take on error: " + error.getMessage(), t);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onError(Throwable error, Frame[] frames) {
        if (Boolean.TRUE.equals(onErrorInProgress.get())) {
            return;
        }
        try {
            onErrorInProgress.set(true);
            Map weakMap = cache.get();
            weakMap.put(error, frames);
            for (ErrorListener el : errorListeners) {
                el.onError(error, frames);
            }
        }
        catch (Throwable t) {
            Logger.error("<ExceptionSnapshotSupport> Error occurred on error: " + error.getMessage(), t);
        }
        finally {
            onErrorInProgress.set(false);
        }
    }

    public static void addAppPackage(String appPackage) {
        appPackages.add(appPackage);
    }

    public static void addIgnoredExceptionType(Class<? extends Throwable> exceptionType) {
        Logger.debug(String.format("<ExceptionSnapshotSupport> Adding ignored exception type (in classloader=%s): %s", exceptionType.getClassLoader(), exceptionType));
        ignoredExceptionTypes.add(exceptionType);
    }

    public static void useErrorFilter(ErrorFilter errorFilter) {
        Logger.debug(String.format("<ExceptionSnapshotSupport> Using error filter (in classloader=%s): %s", errorFilter.getClass().getClassLoader(), errorFilter));
        ExceptionSnapshotSupport.errorFilter = errorFilter;
    }

    public static void registerErrorListener(ErrorListener errorListener) {
        Logger.debug(String.format("<ExceptionSnapshotSupport> Registering error listener (in classloader=%s): %s", errorListener.getClass().getClassLoader(), errorListener));
        errorListeners.add(errorListener);
    }

    static {
        Logger.debug("<ExceptionSnapshotSupport> Loaded by classloader " + ExceptionSnapshotSupport.class.getClassLoader());
        cache = new ThreadLocal<WeakHashMap<Throwable, Frame[]>>(){

            @Override
            protected WeakHashMap<Throwable, Frame[]> initialValue() {
                return new WeakHashMap<Throwable, Frame[]>();
            }
        };
        onErrorInProgress = new ThreadLocal();
        appPackages = new HashSet<String>();
        ignoredExceptionTypes = new HashSet<Class<? extends Throwable>>(){
            {
                this.add(ClassNotFoundException.class);
            }
        };
        errorListeners = new CopyOnWriteArrayList<ErrorListener>();
    }
}

