/*
 * Decompiled with CFR 0.152.
 */
package net.sozal.stackwriter.agent;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sozal.stackwriter.agent.logger.Logger;
import net.sozal.stackwriter.api.ErrorListener;
import net.sozal.stackwriter.api.domain.Frame;

public final class ExceptionSnapshotSupport {
    private static final ThreadLocal<WeakHashMap<Throwable, Frame[]>> cache;
    private static final ThreadLocal<Boolean> onErrorInProgress;
    private static final Set<String> appPackages;
    private static final Set<Class<? extends Throwable>> ignoredExceptionTypes;
    private static ErrorListener errorListener;

    private ExceptionSnapshotSupport() {
    }

    public static boolean shouldTakeSnapshot(Throwable error, int numFrames) {
        if (Boolean.TRUE.equals(onErrorInProgress.get())) {
            return false;
        }
        if (ignoredExceptionTypes.contains(error.getClass())) {
            return false;
        }
        try {
            if (appPackages.isEmpty()) {
                return false;
            }
            Map weakMap = cache.get();
            Frame[] existing = (Frame[])weakMap.get(error);
            if (existing != null && numFrames <= existing.length) {
                return false;
            }
            boolean inAppPackages = false;
            block2: for (StackTraceElement stackTraceElement : error.getStackTrace()) {
                for (String appFrame : appPackages) {
                    if (!stackTraceElement.getClassName().startsWith(appFrame)) continue;
                    inAppPackages = true;
                    continue block2;
                }
            }
            if (!inAppPackages) {
                return false;
            }
            ErrorListener ec = errorListener;
            if (ec == null) {
                return true;
            }
            return ec.shouldTakeSnapshot(error);
        }
        catch (Throwable t) {
            Logger.error("<ExceptionSnapshotSupport> Error occurred while checking whether snapshot should be take on error: " + error.getMessage(), t);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onError(Throwable error, Frame[] frames) {
        if (Boolean.TRUE.equals(onErrorInProgress.get())) {
            return;
        }
        try {
            onErrorInProgress.set(true);
            Map weakMap = cache.get();
            weakMap.put(error, frames);
            ErrorListener el = errorListener;
            if (el != null) {
                el.onError(error, frames);
            }
        }
        catch (Throwable t) {
            Logger.error("<ExceptionSnapshotSupport> Error occurred on error: " + error.getMessage(), t);
        }
        finally {
            onErrorInProgress.set(false);
        }
    }

    public static void addAppPackage(String appPackage) {
        appPackages.add(appPackage);
    }

    public static void addIgnoredExceptionType(Class<? extends Throwable> exceptionType) {
        Logger.debug(String.format("<ExceptionSnapshotSupport> Adding ignored exception type (in classloader=%s): %s", exceptionType.getClassLoader(), exceptionType));
        ignoredExceptionTypes.add(exceptionType);
    }

    public static void setErrorListener(ErrorListener errorListener) {
        Logger.debug(String.format("<ExceptionSnapshotSupport> Setting error listener (in classloader=%s): %s", errorListener.getClass().getClassLoader(), errorListener));
        ExceptionSnapshotSupport.errorListener = errorListener;
    }

    static {
        Logger.debug("<ExceptionSnapshotSupport> Loaded by classloader " + ExceptionSnapshotSupport.class.getClassLoader());
        cache = new ThreadLocal<WeakHashMap<Throwable, Frame[]>>(){

            @Override
            protected WeakHashMap<Throwable, Frame[]> initialValue() {
                return new WeakHashMap<Throwable, Frame[]>();
            }
        };
        onErrorInProgress = new ThreadLocal();
        appPackages = new HashSet<String>();
        ignoredExceptionTypes = new HashSet<Class<? extends Throwable>>(){
            {
                this.add(ClassNotFoundException.class);
            }
        };
    }
}

