package net.sozal.stackwriter.agent;

import net.sozal.stackwriter.api.ErrorListener;
import net.sozal.stackwriter.api.domain.Frame;
import net.sozal.stackwriter.api.internal.StackWriterService;

/**
 * @author serkan
 */
public class StackWriterServiceImpl implements StackWriterService {

    private static final int START_DEPTH_MARGIN = 2;

    @Override
    public Frame[] takeSnapshot() {
        return SnapshotSupport.takeSnapshotWithStartDepth(START_DEPTH_MARGIN);
    }

    @Override
    public Frame[] takeSnapshot(int startDepth, int maxFrameCount) {
        return SnapshotSupport.takeSnapshot(startDepth + START_DEPTH_MARGIN, maxFrameCount);
    }

    @Override
    public Frame[] takeSnapshotWithStartDepth(int startDepth) {
        return SnapshotSupport.takeSnapshot(startDepth + START_DEPTH_MARGIN, -1);
    }

    @Override
    public Frame[] takeSnapshotWithMaxFrameCount(int maxFrameCount) {
        return SnapshotSupport.takeSnapshot(START_DEPTH_MARGIN, maxFrameCount);
    }

    @Override
    public void addAppPackage(String appPackage) {
        ExceptionSnapshotSupport.addAppPackage(appPackage);
    }

    @Override
    public void addIgnoredExceptionType(Class<? extends Throwable> exceptionType) {
        ExceptionSnapshotSupport.addIgnoredExceptionType(exceptionType);
    }

    @Override
    public void useErrorListener(ErrorListener errorChecker) {
        ExceptionSnapshotSupport.setErrorListener(errorChecker);
    }

}
