package net.sozal.stackwriter.agent;

import net.sozal.stackwriter.agent.logger.Logger;
import net.sozal.stackwriter.api.domain.Frame;

/**
 * @author serkan
 */
public final class SnapshotSupport {

    static {
        Logger.debug("<SnapshotSupport> Loaded by classloader " +
                SnapshotSupport.class.getClassLoader());
    }

    private static final int START_DEPTH_MARGIN = 2;

    private SnapshotSupport() {
    }

    private static native Frame[] takeSnapshot0(Thread thread, int startDepth, int maxFrameCount);

    public static Frame[] takeSnapshot() {
        return takeSnapshot0(Thread.currentThread(), START_DEPTH_MARGIN, -1);
    }

    public static Frame[] takeSnapshot(int startDepth, int maxFrameCount) {
        return takeSnapshot0(Thread.currentThread(), startDepth + START_DEPTH_MARGIN, maxFrameCount);
    }

    public static Frame[] takeSnapshotWithStartDepth(int startDepth) {
        return takeSnapshot0(Thread.currentThread(), startDepth + START_DEPTH_MARGIN, -1);
    }

    public static Frame[] takeSnapshotWithMaxFrameCount(int maxFrameCount) {
        return takeSnapshot0(Thread.currentThread(), START_DEPTH_MARGIN, maxFrameCount);
    }

}
