package net.sozal.stackwriter.agent;

import net.sozal.stackwriter.agent.logger.Logger;
import net.sozal.stackwriter.api.StackWriter;

/**
 * @author serkan
 */
public final class Initializer {

    static {
        Logger.debug("<Initializer> Loaded by classloader " +
                Initializer.class.getClassLoader());
    }

    private static boolean initialized = false;

    private Initializer() {
    }

    public static synchronized void init() {
        Logger.debug("<Initializer> Initializing ...");
        if (!initialized) {
            try {
                doInit();
                Logger.debug("<Initializer> Initialized");
            } finally {
                initialized = true;
            }
        } else {
            Logger.debug("<Initializer> Already initialized");
        }
    }

    private static void doInit() {
        StackWriter.setStackWriterService(new StackWriterServiceImpl());
    }

}
