/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

final class J8Collections {
    static <T> Iterator<T> emptyIterator() {
        return EmptyIt.EMPTY_ITERATOR;
    }

    static <E> Iterator<E> singletonIterator(final E e) {
        return new ImmutableIt<E>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return e;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private J8Collections() {
    }

    static abstract class ImmutableIt<T>
    implements Iterator<T> {
        ImmutableIt() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    static final class EmptyIt<E>
    extends ImmutableIt<E> {
        static final EmptyIt<Object> EMPTY_ITERATOR = new EmptyIt();

        EmptyIt() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }
    }
}

