/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java8.util.CollSer;
import java8.util.J8Collections;
import java8.util.KeyValueHolder;
import java8.util.Objects;
import java8.util.concurrent.ThreadLocalRandom;

final class ImmutableCollections {
    static final int SALT = ThreadLocalRandom.current().nextInt();
    static final double EXPAND_FACTOR = 2.0;

    private ImmutableCollections() {
    }

    static UnsupportedOperationException uoe() {
        return new UnsupportedOperationException();
    }

    static void rangeCheckForAdd(int index, int size) {
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
    }

    static <E> List<E> listOf(E[] elements) {
        Objects.requireNonNull(elements);
        switch (elements.length) {
            case 0: {
                return List0.EMPTY_LIST;
            }
            case 1: {
                return new List1<E>(elements[0]);
            }
            case 2: {
                return new List2<E>(elements[0], elements[1]);
            }
        }
        return new ListN<E>(elements);
    }

    static <E> Set<E> setOf() {
        return Set0.EMPTY_SET;
    }

    static <E> Set<E> setOf(E e1) {
        return new Set1<E>(e1);
    }

    static <E> Set<E> setOf(E[] elements) {
        Objects.requireNonNull(elements);
        switch (elements.length) {
            case 0: {
                return ImmutableCollections.setOf();
            }
            case 1: {
                return new Set1<E>(elements[0]);
            }
            case 2: {
                return new Set2<E>(elements[0], elements[1]);
            }
        }
        return new SetN<E>(elements);
    }

    private static int floorMod(int x, int y) {
        return x - ImmutableCollections.floorDiv(x, y) * y;
    }

    private static int floorDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) < 0 && r * y != x) {
            --r;
        }
        return r;
    }

    static final class MapN<K, V>
    extends AbstractImmutableMap<K, V> {
        final Object[] table;
        final int size;

        MapN(Object ... input) {
            Objects.requireNonNull((Object)input);
            if ((input.length & 1) != 0) {
                throw new AssertionError((Object)"length is odd");
            }
            this.size = input.length >> 1;
            int len = (int)Math.ceil(2.0 * (double)input.length);
            len = len + 1 & 0xFFFFFFFE;
            this.table = new Object[len];
            for (int i = 0; i < input.length; i += 2) {
                Object k = Objects.requireNonNull((Object)input[i]);
                Object v = Objects.requireNonNull((Object)input[i + 1]);
                int idx = this.probe(k);
                if (idx >= 0) {
                    throw new IllegalArgumentException("duplicate key: " + k);
                }
                int dest = -(idx + 1);
                this.table[dest] = k;
                this.table[dest + 1] = v;
            }
        }

        @Override
        public boolean containsKey(Object o) {
            return this.probe(Objects.requireNonNull((Object)o)) >= 0;
        }

        @Override
        public boolean containsValue(Object o) {
            return super.containsValue(Objects.requireNonNull((Object)o));
        }

        @Override
        public V get(Object o) {
            int i = this.probe(o);
            if (i >= 0) {
                return (V)this.table[i + 1];
            }
            return null;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return MapN.this.size;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new J8Collections.ImmutableIt<Map.Entry<K, V>>(){
                        int idx = 0;

                        @Override
                        public boolean hasNext() {
                            while (this.idx < MapN.this.table.length) {
                                if (MapN.this.table[this.idx] != null) {
                                    return true;
                                }
                                this.idx += 2;
                            }
                            return false;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (this.hasNext()) {
                                KeyValueHolder<Object, Object> e = new KeyValueHolder<Object, Object>(MapN.this.table[this.idx], MapN.this.table[this.idx + 1]);
                                this.idx += 2;
                                return e;
                            }
                            throw new NoSuchElementException();
                        }
                    };
                }
            };
        }

        private int probe(Object pk) {
            int idx = ImmutableCollections.floorMod(pk.hashCode() ^ SALT, this.table.length >> 1) << 1;
            Object ek;
            while ((ek = this.table[idx]) != null) {
                if (pk.equals(ek)) {
                    return idx;
                }
                if ((idx += 2) != this.table.length) continue;
                idx = 0;
            }
            return -idx - 1;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            Object[] array = new Object[2 * this.size];
            int len = this.table.length;
            int dest = 0;
            for (int i = 0; i < len; i += 2) {
                if (this.table[i] == null) continue;
                array[dest++] = this.table[i];
                array[dest++] = this.table[i + 1];
            }
            return new CollSer(3, array);
        }
    }

    static final class Map1<K, V>
    extends AbstractImmutableMap<K, V> {
        private final K k0;
        private final V v0;

        Map1(K k0, V v0) {
            this.k0 = Objects.requireNonNull(k0);
            this.v0 = Objects.requireNonNull(v0);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return ImmutableCollections.setOf(new KeyValueHolder<K, V>(this.k0, this.v0));
        }

        @Override
        public boolean containsKey(Object o) {
            return super.containsKey(Objects.requireNonNull((Object)o));
        }

        @Override
        public boolean containsValue(Object o) {
            return super.containsValue(Objects.requireNonNull((Object)o));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(3, this.k0, this.v0);
        }
    }

    static final class Map0<K, V>
    extends AbstractImmutableMap<K, V> {
        static final Map0<Object, Object> EMPTY_MAP = new Map0();

        Map0() {
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return ImmutableCollections.setOf();
        }

        @Override
        public boolean containsKey(Object o) {
            return super.containsKey(Objects.requireNonNull((Object)o));
        }

        @Override
        public boolean containsValue(Object o) {
            return super.containsValue(Objects.requireNonNull((Object)o));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(3, new Object[0]);
        }
    }

    static abstract class AbstractImmutableMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        AbstractImmutableMap() {
        }

        @Override
        public void clear() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V put(K key, V value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V remove(Object key) {
            throw ImmutableCollections.uoe();
        }
    }

    static final class SetN<E>
    extends AbstractImmutableSet<E> {
        final E[] elements;
        private final int size;

        SetN(E ... input) {
            this.size = input.length;
            this.elements = new Object[(int)Math.ceil(2.0 * (double)input.length)];
            for (int i = 0; i < input.length; ++i) {
                Object e = Objects.requireNonNull(input[i]);
                int idx = this.probe(e);
                if (idx >= 0) {
                    throw new IllegalArgumentException("duplicate element: " + e);
                }
                this.elements[-(idx + 1)] = e;
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean contains(Object o) {
            return this.probe(Objects.requireNonNull((Object)o)) >= 0;
        }

        @Override
        public Iterator<E> iterator() {
            return new J8Collections.ImmutableIt<E>(){
                private int idx = 0;

                @Override
                public boolean hasNext() {
                    while (this.idx < SetN.this.elements.length) {
                        if (SetN.this.elements[this.idx] != null) {
                            return true;
                        }
                        ++this.idx;
                    }
                    return false;
                }

                @Override
                public E next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return SetN.this.elements[this.idx++];
                }
            };
        }

        private int probe(Object pe) {
            int idx = ImmutableCollections.floorMod(pe.hashCode() ^ SALT, this.elements.length);
            E ee;
            while ((ee = this.elements[idx]) != null) {
                if (pe.equals(ee)) {
                    return idx;
                }
                if (++idx != this.elements.length) continue;
                idx = 0;
            }
            return -idx - 1;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            Object[] array = new Object[this.size];
            int dest = 0;
            for (E o : this.elements) {
                if (o == null) continue;
                array[dest++] = o;
            }
            return new CollSer(2, array);
        }
    }

    static final class Set2<E>
    extends AbstractImmutableSet<E> {
        final E e0;
        final E e1;

        Set2(E e0, E e1) {
            Objects.requireNonNull(e0);
            Objects.requireNonNull(e1);
            if (e0.equals(e1)) {
                throw new IllegalArgumentException("duplicate element: " + e0);
            }
            if (SALT >= 0) {
                this.e0 = e0;
                this.e1 = e1;
            } else {
                this.e0 = e1;
                this.e1 = e0;
            }
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean contains(Object o) {
            return super.contains(Objects.requireNonNull((Object)o));
        }

        @Override
        public Iterator<E> iterator() {
            return new J8Collections.ImmutableIt<E>(){
                private int idx = 0;

                @Override
                public boolean hasNext() {
                    return this.idx < 2;
                }

                @Override
                public E next() {
                    if (this.idx == 0) {
                        this.idx = 1;
                        return Set2.this.e0;
                    }
                    if (this.idx == 1) {
                        this.idx = 2;
                        return Set2.this.e1;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(2, this.e0, this.e1);
        }
    }

    static final class Set1<E>
    extends AbstractImmutableSet<E> {
        private final E e0;

        Set1(E e0) {
            this.e0 = Objects.requireNonNull(e0);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object o) {
            return super.contains(Objects.requireNonNull((Object)o));
        }

        @Override
        public Iterator<E> iterator() {
            return J8Collections.singletonIterator(this.e0);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(2, this.e0);
        }
    }

    static final class Set0<E>
    extends AbstractImmutableSet<E> {
        static final Set0<Object> EMPTY_SET = new Set0();

        Set0() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object o) {
            return super.contains(Objects.requireNonNull((Object)o));
        }

        @Override
        public Iterator<E> iterator() {
            return J8Collections.emptyIterator();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(2, new Object[0]);
        }
    }

    static abstract class AbstractImmutableSet<E>
    extends AbstractSet<E>
    implements Serializable {
        AbstractImmutableSet() {
        }

        @Override
        public boolean add(E e) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void clear() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean remove(Object o) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }
    }

    static final class ListN<E>
    extends AbstractImmutableList<E> {
        private final E[] elements;

        ListN(E ... input) {
            Object[] tmp = new Object[input.length];
            for (int i = 0; i < input.length; ++i) {
                tmp[i] = Objects.requireNonNull(input[i]);
            }
            this.elements = tmp;
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public E get(int index) {
            Objects.checkIndex((int)index, (int)this.elements.length);
            return this.elements[index];
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(1, this.elements);
        }
    }

    static final class List2<E>
    extends AbstractImmutableList<E> {
        private final E e0;
        private final E e1;

        List2(E e0, E e1) {
            this.e0 = Objects.requireNonNull(e0);
            this.e1 = Objects.requireNonNull(e1);
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public E get(int index) {
            Objects.checkIndex((int)index, (int)2);
            if (index == 0) {
                return this.e0;
            }
            return this.e1;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(1, this.e0, this.e1);
        }
    }

    static final class List1<E>
    extends AbstractImmutableList<E> {
        private final E e0;

        List1(E e0) {
            this.e0 = Objects.requireNonNull(e0);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public E get(int index) {
            Objects.checkIndex((int)index, (int)1);
            return this.e0;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(1, this.e0);
        }
    }

    static final class List0<E>
    extends AbstractImmutableList<E> {
        static final List0<Object> EMPTY_LIST = new List0();

        List0() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public E get(int index) {
            Objects.checkIndex((int)index, (int)0);
            return null;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(1, new Object[0]);
        }
    }

    static abstract class AbstractImmutableList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        AbstractImmutableList() {
        }

        @Override
        public boolean add(E e) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            ImmutableCollections.rangeCheckForAdd(index, this.size());
            throw ImmutableCollections.uoe();
        }

        @Override
        public void clear() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean remove(Object o) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }
    }
}

