/*
 * Decompiled with CFR 0.152.
 */
package java8.util.concurrent.atomic;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java8.util.concurrent.atomic.Striped64;

public class DoubleAdder
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;

    public void add(double x) {
        long b;
        Striped64.Cell[] as = this.cells;
        if (this.cells != null || !this.casBase(b = this.base, Double.doubleToRawLongBits(Double.longBitsToDouble(b) + x))) {
            long v;
            Striped64.Cell a;
            int m;
            boolean uncontended = true;
            if (as == null || (m = as.length - 1) < 0 || (a = as[DoubleAdder.getProbe() & m]) == null || !(uncontended = a.cas(v = a.value, Double.doubleToRawLongBits(Double.longBitsToDouble(v) + x)))) {
                this.doubleAccumulate(x, null, uncontended);
            }
        }
    }

    public double sum() {
        Striped64.Cell[] as = this.cells;
        double sum = Double.longBitsToDouble(this.base);
        if (as != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                sum += Double.longBitsToDouble(a.value);
            }
        }
        return sum;
    }

    public void reset() {
        Striped64.Cell[] as = this.cells;
        this.base = 0L;
        if (as != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                a.reset();
            }
        }
    }

    public double sumThenReset() {
        Striped64.Cell[] as = this.cells;
        double sum = Double.longBitsToDouble(this.base);
        this.base = 0L;
        if (as != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                long v = a.value;
                a.reset();
                sum += Double.longBitsToDouble(v);
            }
        }
        return sum;
    }

    public String toString() {
        return Double.toString(this.sum());
    }

    @Override
    public double doubleValue() {
        return this.sum();
    }

    @Override
    public long longValue() {
        return (long)this.sum();
    }

    @Override
    public int intValue() {
        return (int)this.sum();
    }

    @Override
    public float floatValue() {
        return (float)this.sum();
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream s) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 7249069246863182397L;
        private final double value;

        SerializationProxy(DoubleAdder a) {
            this.value = a.sum();
        }

        private Object readResolve() {
            DoubleAdder a = new DoubleAdder();
            a.base = Double.doubleToRawLongBits(this.value);
            return a;
        }
    }
}

