/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb.util;

import java.nio.ByteBuffer;
import org.rocksdb.AbstractComparator;
import org.rocksdb.ComparatorOptions;
import org.rocksdb.util.ByteUtil;

public final class BytewiseComparator
extends AbstractComparator {
    public BytewiseComparator(ComparatorOptions copt) {
        super(copt);
    }

    @Override
    public String name() {
        return "rocksdb.java.BytewiseComparator";
    }

    @Override
    public int compare(ByteBuffer a, ByteBuffer b) {
        return BytewiseComparator._compare(a, b);
    }

    static int _compare(ByteBuffer a, ByteBuffer b) {
        assert (a != null && b != null);
        int minLen = Math.min(a.remaining(), b.remaining());
        int r = ByteUtil.memcmp(a, b, minLen);
        if (r == 0) {
            if (a.remaining() < b.remaining()) {
                r = -1;
            } else if (a.remaining() > b.remaining()) {
                r = 1;
            }
        }
        return r;
    }

    @Override
    public void findShortestSeparator(ByteBuffer start, ByteBuffer limit) {
        int diffIndex;
        int minLength = Math.min(start.remaining(), limit.remaining());
        for (diffIndex = 0; diffIndex < minLength && start.get(diffIndex) == limit.get(diffIndex); ++diffIndex) {
        }
        if (diffIndex < minLength) {
            int limitByte;
            int startByte = start.get(diffIndex) & 0xFF;
            if (startByte >= (limitByte = limit.get(diffIndex) & 0xFF)) {
                return;
            }
            assert (startByte < limitByte);
            if (diffIndex < limit.remaining() - 1 || startByte + 1 < limitByte) {
                start.put(diffIndex, (byte)((start.get(diffIndex) & 0xFF) + 1));
                start.limit(diffIndex + 1);
            } else {
                ++diffIndex;
                while (diffIndex < start.remaining()) {
                    if ((start.get(diffIndex) & 0xFF) < 255) {
                        start.put(diffIndex, (byte)((start.get(diffIndex) & 0xFF) + 1));
                        start.limit(diffIndex + 1);
                        break;
                    }
                    ++diffIndex;
                }
            }
            assert (this.compare(start.duplicate(), limit.duplicate()) < 0);
        }
    }

    @Override
    public void findShortSuccessor(ByteBuffer key) {
        int n = key.remaining();
        for (int i = 0; i < n; ++i) {
            int byt = key.get(i) & 0xFF;
            if (byt == 255) continue;
            key.put(i, (byte)(byt + 1));
            key.limit(i + 1);
            return;
        }
    }
}

