/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.rocksdb.HistogramData;
import org.rocksdb.HistogramType;
import org.rocksdb.Statistics;
import org.rocksdb.StatisticsCollectorCallback;
import org.rocksdb.StatsCollectorInput;
import org.rocksdb.TickerType;

public class StatisticsCollector {
    final List<StatsCollectorInput> _statsCollectorInputList;
    private final ExecutorService _executorService;
    final int _statsCollectionInterval;
    volatile boolean _isRunning = true;

    public StatisticsCollector(List<StatsCollectorInput> statsCollectorInputList, int statsCollectionIntervalInMilliSeconds) {
        this._statsCollectorInputList = statsCollectorInputList;
        this._statsCollectionInterval = statsCollectionIntervalInMilliSeconds;
        this._executorService = Executors.newSingleThreadExecutor();
    }

    public void start() {
        this._executorService.submit(this.collectStatistics());
    }

    public void shutDown(int shutdownTimeout) throws InterruptedException {
        this._isRunning = false;
        this._executorService.shutdownNow();
        this._executorService.awaitTermination(shutdownTimeout, TimeUnit.MILLISECONDS);
    }

    private Runnable collectStatistics() {
        return new Runnable(){

            @Override
            public void run() {
                while (StatisticsCollector.this._isRunning) {
                    try {
                        if (Thread.currentThread().isInterrupted()) break;
                        for (StatsCollectorInput statsCollectorInput : StatisticsCollector.this._statsCollectorInputList) {
                            Statistics statistics = statsCollectorInput.getStatistics();
                            StatisticsCollectorCallback statsCallback = statsCollectorInput.getCallback();
                            for (TickerType tickerType : TickerType.values()) {
                                if (tickerType == TickerType.TICKER_ENUM_MAX) continue;
                                long tickerValue = statistics.getTickerCount(tickerType);
                                statsCallback.tickerCallback(tickerType, tickerValue);
                            }
                            for (Enum enum_ : HistogramType.values()) {
                                if (enum_ == HistogramType.HISTOGRAM_ENUM_MAX) continue;
                                HistogramData histogramData = statistics.getHistogramData((HistogramType)enum_);
                                statsCallback.histogramCallback((HistogramType)enum_, histogramData);
                            }
                        }
                        Thread.sleep(StatisticsCollector.this._statsCollectionInterval);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error while calculating statistics", e);
                    }
                }
            }
        };
    }
}

