/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.Cache;
import org.rocksdb.ChecksumType;
import org.rocksdb.DataBlockIndexType;
import org.rocksdb.Filter;
import org.rocksdb.IndexShorteningMode;
import org.rocksdb.IndexType;
import org.rocksdb.PersistentCache;
import org.rocksdb.TableFormatConfig;

public class BlockBasedTableConfig
extends TableFormatConfig {
    private boolean cacheIndexAndFilterBlocks = false;
    private boolean cacheIndexAndFilterBlocksWithHighPriority = true;
    private boolean pinL0FilterAndIndexBlocksInCache = false;
    private boolean pinTopLevelIndexAndFilter = true;
    private IndexType indexType = IndexType.kBinarySearch;
    private DataBlockIndexType dataBlockIndexType = DataBlockIndexType.kDataBlockBinarySearch;
    private double dataBlockHashTableUtilRatio = 0.75;
    private ChecksumType checksumType = ChecksumType.kCRC32c;
    private boolean noBlockCache = false;
    private Cache blockCache = null;
    private PersistentCache persistentCache = null;
    private Cache blockCacheCompressed = null;
    private long blockSize = 4096L;
    private int blockSizeDeviation = 10;
    private int blockRestartInterval = 16;
    private int indexBlockRestartInterval = 1;
    private long metadataBlockSize = 4096L;
    private boolean partitionFilters = false;
    private boolean optimizeFiltersForMemory = false;
    private boolean useDeltaEncoding = true;
    private Filter filterPolicy = null;
    private boolean wholeKeyFiltering = true;
    private boolean verifyCompression = false;
    private int readAmpBytesPerBit = 0;
    private int formatVersion = 5;
    private boolean enableIndexCompression = true;
    private boolean blockAlign = false;
    private IndexShorteningMode indexShortening = IndexShorteningMode.kShortenSeparators;
    @Deprecated
    private long blockCacheSize = 0x800000L;
    @Deprecated
    private int blockCacheNumShardBits = 0;
    @Deprecated
    private long blockCacheCompressedSize = 0L;
    @Deprecated
    private int blockCacheCompressedNumShardBits = 0;

    public boolean cacheIndexAndFilterBlocks() {
        return this.cacheIndexAndFilterBlocks;
    }

    public BlockBasedTableConfig setCacheIndexAndFilterBlocks(boolean cacheIndexAndFilterBlocks) {
        this.cacheIndexAndFilterBlocks = cacheIndexAndFilterBlocks;
        return this;
    }

    public boolean cacheIndexAndFilterBlocksWithHighPriority() {
        return this.cacheIndexAndFilterBlocksWithHighPriority;
    }

    public BlockBasedTableConfig setCacheIndexAndFilterBlocksWithHighPriority(boolean cacheIndexAndFilterBlocksWithHighPriority) {
        this.cacheIndexAndFilterBlocksWithHighPriority = cacheIndexAndFilterBlocksWithHighPriority;
        return this;
    }

    public boolean pinL0FilterAndIndexBlocksInCache() {
        return this.pinL0FilterAndIndexBlocksInCache;
    }

    public BlockBasedTableConfig setPinL0FilterAndIndexBlocksInCache(boolean pinL0FilterAndIndexBlocksInCache) {
        this.pinL0FilterAndIndexBlocksInCache = pinL0FilterAndIndexBlocksInCache;
        return this;
    }

    public boolean pinTopLevelIndexAndFilter() {
        return this.pinTopLevelIndexAndFilter;
    }

    public BlockBasedTableConfig setPinTopLevelIndexAndFilter(boolean pinTopLevelIndexAndFilter) {
        this.pinTopLevelIndexAndFilter = pinTopLevelIndexAndFilter;
        return this;
    }

    public IndexType indexType() {
        return this.indexType;
    }

    public BlockBasedTableConfig setIndexType(IndexType indexType) {
        this.indexType = indexType;
        return this;
    }

    public DataBlockIndexType dataBlockIndexType() {
        return this.dataBlockIndexType;
    }

    public BlockBasedTableConfig setDataBlockIndexType(DataBlockIndexType dataBlockIndexType) {
        this.dataBlockIndexType = dataBlockIndexType;
        return this;
    }

    public double dataBlockHashTableUtilRatio() {
        return this.dataBlockHashTableUtilRatio;
    }

    public BlockBasedTableConfig setDataBlockHashTableUtilRatio(double dataBlockHashTableUtilRatio) {
        this.dataBlockHashTableUtilRatio = dataBlockHashTableUtilRatio;
        return this;
    }

    public ChecksumType checksumType() {
        return this.checksumType;
    }

    public BlockBasedTableConfig setChecksumType(ChecksumType checksumType) {
        this.checksumType = checksumType;
        return this;
    }

    public boolean noBlockCache() {
        return this.noBlockCache;
    }

    public BlockBasedTableConfig setNoBlockCache(boolean noBlockCache) {
        this.noBlockCache = noBlockCache;
        return this;
    }

    public BlockBasedTableConfig setBlockCache(Cache blockCache) {
        this.blockCache = blockCache;
        return this;
    }

    public BlockBasedTableConfig setPersistentCache(PersistentCache persistentCache) {
        this.persistentCache = persistentCache;
        return this;
    }

    public BlockBasedTableConfig setBlockCacheCompressed(Cache blockCacheCompressed) {
        this.blockCacheCompressed = blockCacheCompressed;
        return this;
    }

    public long blockSize() {
        return this.blockSize;
    }

    public BlockBasedTableConfig setBlockSize(long blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public int blockSizeDeviation() {
        return this.blockSizeDeviation;
    }

    public BlockBasedTableConfig setBlockSizeDeviation(int blockSizeDeviation) {
        this.blockSizeDeviation = blockSizeDeviation;
        return this;
    }

    public int blockRestartInterval() {
        return this.blockRestartInterval;
    }

    public BlockBasedTableConfig setBlockRestartInterval(int restartInterval) {
        this.blockRestartInterval = restartInterval;
        return this;
    }

    public int indexBlockRestartInterval() {
        return this.indexBlockRestartInterval;
    }

    public BlockBasedTableConfig setIndexBlockRestartInterval(int restartInterval) {
        this.indexBlockRestartInterval = restartInterval;
        return this;
    }

    public long metadataBlockSize() {
        return this.metadataBlockSize;
    }

    public BlockBasedTableConfig setMetadataBlockSize(long metadataBlockSize) {
        this.metadataBlockSize = metadataBlockSize;
        return this;
    }

    public boolean partitionFilters() {
        return this.partitionFilters;
    }

    public BlockBasedTableConfig setPartitionFilters(boolean partitionFilters) {
        this.partitionFilters = partitionFilters;
        return this;
    }

    public boolean optimizeFiltersForMemory() {
        return this.optimizeFiltersForMemory;
    }

    public BlockBasedTableConfig setOptimizeFiltersForMemory(boolean optimizeFiltersForMemory) {
        this.optimizeFiltersForMemory = optimizeFiltersForMemory;
        return this;
    }

    public boolean useDeltaEncoding() {
        return this.useDeltaEncoding;
    }

    public BlockBasedTableConfig setUseDeltaEncoding(boolean useDeltaEncoding) {
        this.useDeltaEncoding = useDeltaEncoding;
        return this;
    }

    public Filter filterPolicy() {
        return this.filterPolicy;
    }

    public BlockBasedTableConfig setFilterPolicy(Filter filterPolicy) {
        this.filterPolicy = filterPolicy;
        return this;
    }

    @Deprecated
    public BlockBasedTableConfig setFilter(Filter filter) {
        return this.setFilterPolicy(filter);
    }

    public boolean wholeKeyFiltering() {
        return this.wholeKeyFiltering;
    }

    public BlockBasedTableConfig setWholeKeyFiltering(boolean wholeKeyFiltering) {
        this.wholeKeyFiltering = wholeKeyFiltering;
        return this;
    }

    public boolean verifyCompression() {
        return this.verifyCompression;
    }

    public BlockBasedTableConfig setVerifyCompression(boolean verifyCompression) {
        this.verifyCompression = verifyCompression;
        return this;
    }

    public int readAmpBytesPerBit() {
        return this.readAmpBytesPerBit;
    }

    public BlockBasedTableConfig setReadAmpBytesPerBit(int readAmpBytesPerBit) {
        this.readAmpBytesPerBit = readAmpBytesPerBit;
        return this;
    }

    public int formatVersion() {
        return this.formatVersion;
    }

    public BlockBasedTableConfig setFormatVersion(int formatVersion) {
        assert (formatVersion >= 0);
        this.formatVersion = formatVersion;
        return this;
    }

    public boolean enableIndexCompression() {
        return this.enableIndexCompression;
    }

    public BlockBasedTableConfig setEnableIndexCompression(boolean enableIndexCompression) {
        this.enableIndexCompression = enableIndexCompression;
        return this;
    }

    public boolean blockAlign() {
        return this.blockAlign;
    }

    public BlockBasedTableConfig setBlockAlign(boolean blockAlign) {
        this.blockAlign = blockAlign;
        return this;
    }

    public IndexShorteningMode indexShortening() {
        return this.indexShortening;
    }

    public BlockBasedTableConfig setIndexShortening(IndexShorteningMode indexShortening) {
        this.indexShortening = indexShortening;
        return this;
    }

    @Deprecated
    public long blockCacheSize() {
        return this.blockCacheSize;
    }

    @Deprecated
    public BlockBasedTableConfig setBlockCacheSize(long blockCacheSize) {
        this.blockCacheSize = blockCacheSize;
        return this;
    }

    @Deprecated
    public int cacheNumShardBits() {
        return this.blockCacheNumShardBits;
    }

    @Deprecated
    public BlockBasedTableConfig setCacheNumShardBits(int blockCacheNumShardBits) {
        this.blockCacheNumShardBits = blockCacheNumShardBits;
        return this;
    }

    @Deprecated
    public long blockCacheCompressedSize() {
        return this.blockCacheCompressedSize;
    }

    @Deprecated
    public BlockBasedTableConfig setBlockCacheCompressedSize(long blockCacheCompressedSize) {
        this.blockCacheCompressedSize = blockCacheCompressedSize;
        return this;
    }

    @Deprecated
    public int blockCacheCompressedNumShardBits() {
        return this.blockCacheCompressedNumShardBits;
    }

    @Deprecated
    public BlockBasedTableConfig setBlockCacheCompressedNumShardBits(int blockCacheCompressedNumShardBits) {
        this.blockCacheCompressedNumShardBits = blockCacheCompressedNumShardBits;
        return this;
    }

    @Deprecated
    public boolean hashIndexAllowCollision() {
        return true;
    }

    @Deprecated
    public BlockBasedTableConfig setHashIndexAllowCollision(boolean hashIndexAllowCollision) {
        return this;
    }

    @Override
    protected long newTableFactoryHandle() {
        long filterPolicyHandle = this.filterPolicy != null ? this.filterPolicy.nativeHandle_ : 0L;
        long blockCacheHandle = this.blockCache != null ? this.blockCache.nativeHandle_ : 0L;
        long persistentCacheHandle = this.persistentCache != null ? this.persistentCache.nativeHandle_ : 0L;
        long blockCacheCompressedHandle = this.blockCacheCompressed != null ? this.blockCacheCompressed.nativeHandle_ : 0L;
        return this.newTableFactoryHandle(this.cacheIndexAndFilterBlocks, this.cacheIndexAndFilterBlocksWithHighPriority, this.pinL0FilterAndIndexBlocksInCache, this.pinTopLevelIndexAndFilter, this.indexType.getValue(), this.dataBlockIndexType.getValue(), this.dataBlockHashTableUtilRatio, this.checksumType.getValue(), this.noBlockCache, blockCacheHandle, persistentCacheHandle, blockCacheCompressedHandle, this.blockSize, this.blockSizeDeviation, this.blockRestartInterval, this.indexBlockRestartInterval, this.metadataBlockSize, this.partitionFilters, this.optimizeFiltersForMemory, this.useDeltaEncoding, filterPolicyHandle, this.wholeKeyFiltering, this.verifyCompression, this.readAmpBytesPerBit, this.formatVersion, this.enableIndexCompression, this.blockAlign, this.indexShortening.getValue(), this.blockCacheSize, this.blockCacheNumShardBits, this.blockCacheCompressedSize, this.blockCacheCompressedNumShardBits);
    }

    private native long newTableFactoryHandle(boolean var1, boolean var2, boolean var3, boolean var4, byte var5, byte var6, double var7, byte var9, boolean var10, long var11, long var13, long var15, long var17, int var19, int var20, int var21, long var22, boolean var24, boolean var25, boolean var26, long var27, boolean var29, boolean var30, int var31, int var32, boolean var33, boolean var34, byte var35, @Deprecated long var36, @Deprecated int var38, @Deprecated long var39, @Deprecated int var41);
}

