/*
 * Decompiled with CFR 0.152.
 */
package net.volcanite.util;

import java.util.Arrays;
import java.util.Objects;
import net.volcanite.util.Hash;

public final class Byte4Key {
    private static final byte[] MIN_KEY = new byte[]{0, 0, 0, 0};
    private static final byte[] MAX_KEY = new byte[]{-1, -1, -1, -1};
    private int curr;

    public static byte[] minKey() {
        return (byte[])MIN_KEY.clone();
    }

    public static byte[] maxKey() {
        return (byte[])MAX_KEY.clone();
    }

    public Byte4Key() {
        this.curr = Integer.MIN_VALUE;
    }

    public Byte4Key(int startAt) {
        this.curr = startAt;
    }

    public Byte4Key(byte[] key) {
        if (Objects.requireNonNull(key).length != 4) {
            throw new IllegalArgumentException("wrong key length: " + key.length);
        }
        this.curr = Byte4Key.getIntB(key);
    }

    public byte[] next() {
        return Byte4Key.create(this.curr++);
    }

    public byte[] current() {
        return Byte4Key.create(this.curr);
    }

    public int currentValue() {
        return this.curr;
    }

    public void increment() {
        ++this.curr;
    }

    public void decrement() {
        --this.curr;
    }

    public int minus(Byte4Key other) {
        return this.curr - Objects.requireNonNull(other, (String)"other").curr;
    }

    public String toString() {
        return Arrays.toString(this.current());
    }

    public int hashCode() {
        int h = 524287 + this.curr;
        return Hash.hash32((h << 19) - h);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Byte4Key other = (Byte4Key)obj;
        return this.curr == other.curr;
    }

    private static byte[] create(int val) {
        return Byte4Key.putIntB(val, new byte[4]);
    }

    private static byte[] putIntB(int x, byte[] bytes) {
        bytes[0] = (byte)(x >> 24);
        bytes[1] = (byte)(x >> 16);
        bytes[2] = (byte)(x >> 8);
        bytes[3] = (byte)x;
        return bytes;
    }

    private static int getIntB(byte[] bytes) {
        return Byte4Key.makeInt(bytes[0], bytes[1], bytes[2], bytes[3]);
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }
}

