/*
 * Decompiled with CFR 0.152.
 */
package org.schwefel.kv.kueue;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.schwefel.kv.KVStore;
import org.schwefel.kv.StoreOps;
import org.schwefel.kv.kueue.Kueue;
import org.schwefel.kv.kueue.KueueImpl;

public final class KueueManager
implements AutoCloseable {
    private final StoreOps ops;
    private final Path dir;
    private final ConcurrentHashMap<String, KueueImpl> kueues = new ConcurrentHashMap();

    public KueueManager(Path directory) {
        this.ops = new KVStore(Objects.requireNonNull(directory));
        this.dir = directory;
    }

    public Kueue get(String identifier) {
        if (!this.isClosed()) {
            return this.kueues.computeIfAbsent(Objects.requireNonNull(identifier), id -> new KueueImpl(this.ops, (String)id, this));
        }
        throw new IllegalStateException(KueueManager.class.getName() + " for " + this.getDirectory() + " is closed");
    }

    public Path getPath() {
        return this.dir;
    }

    public String getDirectory() {
        String directory = "???";
        try {
            directory = this.getPath().toFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return directory;
    }

    public boolean isClosed() {
        return !this.ops.isOpen();
    }

    @Override
    public void close() {
        this.ops.close();
        this.kueues.clear();
    }
}

