/*
 * Decompiled with CFR 0.152.
 */
package org.schwefel.kv;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Transaction;
import org.schwefel.kv.ForEachAll;
import org.schwefel.kv.ForEachKeyValue;
import org.schwefel.kv.ForEachRange;
import org.schwefel.kv.Kind;
import org.schwefel.kv.KindImpl;
import org.schwefel.kv.LexicographicByteArrayComparator;
import org.schwefel.kv.MinMaxKeyIt;
import org.schwefel.kv.Stats;
import org.schwefel.kv.StoreException;
import org.schwefel.kv.Tx;

class Transactional
implements Tx {
    private volatile Transaction txn = null;
    private final ReadOptions readOptions;
    private final Stats stats;

    Transactional(Transaction txn, ReadOptions readOptions, Stats stats) {
        this.txn = Objects.requireNonNull(txn);
        this.stats = Objects.requireNonNull(stats).incOpenTxCount();
        this.readOptions = Objects.requireNonNull(readOptions);
    }

    @Override
    public synchronized void commit() {
        this.validateOwned();
        try {
            this.txn.commit();
        }
        catch (RocksDBException e) {
            try {
                this.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new StoreException(e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public synchronized void rollback() {
        if (this.txn != null) {
            try {
                this.txn.rollback();
            }
            catch (RocksDBException e) {
                throw new StoreException(e);
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.txn != null) {
            try {
                this.txn.close();
            }
            finally {
                this.txn = null;
                this.stats.decOpenTxCount();
            }
        }
    }

    @Override
    public synchronized void disableIndexing() {
        this.validateOwned();
        this.txn.disableIndexing();
    }

    @Override
    public synchronized void enableIndexing() {
        this.validateOwned();
        this.txn.enableIndexing();
    }

    @Override
    public synchronized void setLockTimeout(long lockTimeoutMillis) {
        this.validateOwned();
        this.txn.setLockTimeout(lockTimeoutMillis);
    }

    @Override
    public synchronized void put(Kind kind, byte[] key, byte[] value) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        this.validateOwned();
        try {
            this.txn.put(((KindImpl)kind).handle(), key, value);
        }
        catch (RocksDBException e) {
            throw new StoreException(e);
        }
    }

    @Override
    public synchronized void putIfAbsent(Kind kind, byte[] key, byte[] value) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        this.validateOwned();
        try {
            if (this.get(kind, key) == null) {
                this.txn.put(((KindImpl)kind).handle(), key, value);
            }
        }
        catch (RocksDBException e) {
            throw new StoreException(e);
        }
    }

    @Override
    public synchronized byte[] get(Kind kind, byte[] key) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        this.validateOwned();
        this.validateReadOptions();
        try {
            return this.txn.get(((KindImpl)kind).handle(), this.readOptions, key);
        }
        catch (RocksDBException e) {
            throw new StoreException(e);
        }
    }

    @Override
    public synchronized List<byte[]> multiGet(List<Kind> kinds, List<byte[]> keys) {
        Objects.requireNonNull(kinds, "kinds cannot be null");
        Objects.requireNonNull(keys, "keys cannot be null");
        if (kinds.size() != keys.size()) {
            throw new IllegalArgumentException("Each key must have an associated Kind. kinds = " + kinds.size() + " != keys = " + keys.size());
        }
        Transactional.checkInnerKeys(keys);
        this.validateOwned();
        this.validateReadOptions();
        try {
            return this.txn.multiGetAsList(this.readOptions, Transactional.toCfHandleList(kinds), keys);
        }
        catch (RocksDBException e) {
            throw new StoreException(e);
        }
    }

    @Override
    public synchronized ForEachKeyValue scanAll(Kind kind) {
        Objects.requireNonNull(kind, "kind cannot be null");
        this.validateOwned();
        this.validateReadOptions();
        RocksIterator it = Objects.requireNonNull(this.txn.getIterator(this.readOptions, ((KindImpl)kind).handle()));
        this.stats.incOpenCursorsCount();
        it.seekToFirst();
        return new ForEachAll(it, this.stats, this);
    }

    @Override
    public synchronized ForEachKeyValue scanAll(Kind kind, byte[] beginKey) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(beginKey, "beginKey cannot be null");
        this.validateOwned();
        this.validateReadOptions();
        RocksIterator it = Objects.requireNonNull(this.txn.getIterator(this.readOptions, ((KindImpl)kind).handle()));
        this.stats.incOpenCursorsCount();
        it.seek(beginKey);
        return new ForEachAll(it, this.stats, this);
    }

    @Override
    public synchronized ForEachKeyValue scanRange(Kind kind, byte[] beginKey, byte[] endKey) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(beginKey, "beginKey cannot be null");
        Objects.requireNonNull(endKey, "endKey cannot be null");
        this.validateOwned();
        this.validateReadOptions();
        RocksIterator it = Objects.requireNonNull(this.txn.getIterator(this.readOptions, ((KindImpl)kind).handle()));
        this.stats.incOpenCursorsCount();
        it.seek(beginKey);
        return new ForEachRange(it, endKey, this.stats, this);
    }

    @Override
    public synchronized byte[] findMinKey(Kind kind) {
        Objects.requireNonNull(kind, "kind cannot be null");
        this.validateOwned();
        this.validateReadOptions();
        RocksIterator it = Objects.requireNonNull(this.txn.getIterator(this.readOptions, ((KindImpl)kind).handle()));
        this.stats.incOpenCursorsCount();
        return MinMaxKeyIt.findMinKey(it, this.stats);
    }

    @Override
    public synchronized byte[] findMinKeyByPrefix(Kind kind, byte[] keyPrefix) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(keyPrefix, "keyPrefix cannot be null");
        this.validateOwned();
        this.validateReadOptions();
        RocksIterator it = Objects.requireNonNull(this.txn.getIterator(this.readOptions, ((KindImpl)kind).handle()));
        this.stats.incOpenCursorsCount();
        return MinMaxKeyIt.findMinKey(it, this.stats, keyPrefix);
    }

    @Override
    public synchronized byte[] findMinKeyByLowerBound(Kind kind, byte[] lowerBound) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(lowerBound, "lowerBound cannot be null");
        this.validateOwned();
        return MinMaxKeyIt.findMinKeyByLowerBound(this.txn, ((KindImpl)kind).handle(), this.stats, lowerBound);
    }

    @Override
    public synchronized byte[] findMaxKey(Kind kind) {
        Objects.requireNonNull(kind, "kind cannot be null");
        this.validateOwned();
        this.validateReadOptions();
        RocksIterator it = Objects.requireNonNull(this.txn.getIterator(this.readOptions, ((KindImpl)kind).handle()));
        this.stats.incOpenCursorsCount();
        return MinMaxKeyIt.findMaxKey(it, this.stats);
    }

    @Override
    public synchronized byte[] findMaxKeyByPrefix(Kind kind, byte[] keyPrefix) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(keyPrefix, "keyPrefix cannot be null");
        this.validateOwned();
        this.validateReadOptions();
        RocksIterator it = Objects.requireNonNull(this.txn.getIterator(this.readOptions, ((KindImpl)kind).handle()));
        this.stats.incOpenCursorsCount();
        return MinMaxKeyIt.findMaxKey(it, this.stats, keyPrefix);
    }

    @Override
    public synchronized byte[] findMaxKeyByUpperBound(Kind kind, byte[] upperBound) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(upperBound, "upperBound cannot be null");
        this.validateOwned();
        return MinMaxKeyIt.findMaxKeyByUpperBound(this.txn, ((KindImpl)kind).handle(), this.stats, upperBound);
    }

    @Override
    public synchronized byte[] findMaxKeyLessThan(Kind kind, byte[] keyPrefix, byte[] upperBound) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(keyPrefix, "keyPrefix cannot be null");
        Objects.requireNonNull(upperBound, "upperBound cannot be null");
        this.validateOwned();
        this.validateReadOptions();
        if (keyPrefix.length >= upperBound.length && LexicographicByteArrayComparator.lexicographicalCompare(keyPrefix, upperBound) > 0) {
            return null;
        }
        RocksIterator it = Objects.requireNonNull(this.txn.getIterator(this.readOptions, ((KindImpl)kind).handle()));
        this.stats.incOpenCursorsCount();
        return MinMaxKeyIt.findMaxKeyLessThan(it, this.stats, keyPrefix, upperBound);
    }

    @Override
    public synchronized byte[] findMinKeyGreaterThan(Kind kind, byte[] keyPrefix, byte[] lowerBound) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(keyPrefix, "keyPrefix cannot be null");
        Objects.requireNonNull(lowerBound, "lowerBound cannot be null");
        this.validateOwned();
        this.validateReadOptions();
        if (keyPrefix.length >= lowerBound.length && LexicographicByteArrayComparator.lexicographicalCompare(keyPrefix, lowerBound) < 0) {
            return null;
        }
        RocksIterator it = Objects.requireNonNull(this.txn.getIterator(this.readOptions, ((KindImpl)kind).handle()));
        this.stats.incOpenCursorsCount();
        return MinMaxKeyIt.findMinKeyGreaterThan(it, this.stats, keyPrefix, lowerBound);
    }

    @Override
    public byte[] getForUpdate(Kind kind, byte[] key) {
        return this.getForUpdate(kind, key, true);
    }

    @Override
    public synchronized byte[] getForUpdate(Kind kind, byte[] key, boolean exclusive) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        this.validateOwned();
        this.validateReadOptions();
        try {
            return this.txn.getForUpdate(this.readOptions, ((KindImpl)kind).handle(), key, exclusive);
        }
        catch (RocksDBException e) {
            throw new StoreException(e);
        }
    }

    @Override
    public synchronized List<byte[]> multiGetForUpdate(List<Kind> kinds, List<byte[]> keys) {
        Objects.requireNonNull(kinds, "kinds cannot be null");
        Objects.requireNonNull(keys, "keys cannot be null");
        if (kinds.size() != keys.size()) {
            throw new IllegalArgumentException("Each key must have an associated Kind. kinds = " + kinds.size() + " != keys = " + keys.size());
        }
        Transactional.checkInnerKeys(keys);
        this.validateOwned();
        this.validateReadOptions();
        try {
            return this.txn.multiGetForUpdateAsList(this.readOptions, Transactional.toCfHandleList(kinds), keys);
        }
        catch (RocksDBException e) {
            throw new StoreException(e);
        }
    }

    private static List<ColumnFamilyHandle> toCfHandleList(List<Kind> kinds) {
        return kinds.stream().map(k -> ((KindImpl)k).handle()).collect(Collectors.toList());
    }

    @Override
    public synchronized void undoGetForUpdate(Kind kind, byte[] key) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        this.validateOwned();
        this.txn.undoGetForUpdate(((KindImpl)kind).handle(), key);
    }

    @Override
    public synchronized void delete(Kind kind, byte[] key) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        this.validateOwned();
        try {
            this.txn.delete(((KindImpl)kind).handle(), key);
        }
        catch (RocksDBException e) {
            throw new StoreException(e);
        }
    }

    @Override
    public synchronized byte[] deleteIfPresent(Kind kind, byte[] key) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        this.validateOwned();
        byte[] oldVal = null;
        try {
            oldVal = this.get(kind, key);
            if (oldVal != null) {
                this.txn.delete(((KindImpl)kind).handle(), key);
            }
        }
        catch (RocksDBException e) {
            throw new StoreException(e);
        }
        return oldVal;
    }

    @Override
    public synchronized void singleDelete(Kind kind, byte[] key) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        this.validateOwned();
        try {
            this.txn.singleDelete(((KindImpl)kind).handle(), key);
        }
        catch (RocksDBException e) {
            throw new StoreException(e);
        }
    }

    @Override
    public synchronized byte[] singleDeleteIfPresent(Kind kind, byte[] key) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        this.validateOwned();
        byte[] oldVal = null;
        try {
            oldVal = this.get(kind, key);
            if (oldVal != null) {
                this.txn.singleDelete(((KindImpl)kind).handle(), key);
            }
        }
        catch (RocksDBException e) {
            throw new StoreException(e);
        }
        return oldVal;
    }

    @Override
    public synchronized byte[] updateIfPresent(Kind kind, byte[] key, byte[] value) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        this.validateOwned();
        byte[] oldVal = null;
        try {
            oldVal = this.get(kind, key);
            if (oldVal != null) {
                this.txn.put(((KindImpl)kind).handle(), key, value);
            }
        }
        catch (RocksDBException e) {
            throw new StoreException(e);
        }
        return oldVal;
    }

    private void validateReadOptions() {
        if (!this.readOptions.isOwningHandle()) {
            throw new StoreException("ReadOptions already closed!?");
        }
    }

    private void validateOwned() {
        if (this.txn == null) {
            throw new StoreException("Tx has already lost ownership");
        }
    }

    private static void checkInnerKeys(List<byte[]> keys) {
        for (int i = 0; i < keys.size(); ++i) {
            if (keys.get(i) != null) continue;
            throw new NullPointerException("keys[" + i + "] cannot be null");
        }
    }
}

