/*
 * Decompiled with CFR 0.152.
 */
package org.schwefel.kv;

import java.util.Comparator;

public class LexicographicByteArrayComparator
implements Comparator<byte[]> {
    public static final LexicographicByteArrayComparator COMPARATOR = new LexicographicByteArrayComparator();

    @Override
    public int compare(byte[] a, byte[] b) {
        return LexicographicByteArrayComparator.lexicographicalCompare(a, b);
    }

    public static int lexicographicalCompare(byte[] a, byte[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? -1 : 1;
        }
        int i = LexicographicByteArrayComparator.mismatch(a, b, Math.min(a.length, b.length));
        if (i >= 0) {
            return LexicographicByteArrayComparator.unsignedCompare(a[i], b[i]);
        }
        return a.length - b.length;
    }

    private static int mismatch(byte[] a, byte[] b, int length) {
        for (int i = 0; i < length; ++i) {
            if (a[i] == b[i]) continue;
            return i;
        }
        return -1;
    }

    private static int unsignedCompare(byte x, byte y) {
        return (x & 0xFF) - (y & 0xFF);
    }
}

