/*
 * Decompiled with CFR 0.152.
 */
package org.schwefel.kv;

import java.util.Objects;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.schwefel.kv.Batch;
import org.schwefel.kv.Kind;
import org.schwefel.kv.KindImpl;
import org.schwefel.kv.StoreException;

class BatchImpl
implements Batch,
AutoCloseable {
    private volatile WriteBatch batch = new WriteBatch();

    BatchImpl() {
    }

    @Override
    public synchronized void put(Kind kind, byte[] key, byte[] value) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        this.validateOwned();
        try {
            this.batch.put(((KindImpl)kind).handle(), key, value);
        }
        catch (RocksDBException e) {
            throw new StoreException(e);
        }
    }

    @Override
    public synchronized void delete(Kind kind, byte[] key) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        this.validateOwned();
        try {
            this.batch.delete(((KindImpl)kind).handle(), key);
        }
        catch (RocksDBException e) {
            throw new StoreException(e);
        }
    }

    @Override
    public synchronized void singleDelete(Kind kind, byte[] key) {
        Objects.requireNonNull(kind, "kind cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        this.validateOwned();
        try {
            this.batch.singleDelete(((KindImpl)kind).handle(), key);
        }
        catch (RocksDBException e) {
            throw new StoreException(e);
        }
    }

    synchronized WriteBatch cedeOwnership() {
        WriteBatch b = this.batch;
        this.batch = null;
        return b;
    }

    @Override
    public synchronized void close() {
        if (this.batch != null) {
            try {
                this.batch.close();
            }
            finally {
                this.batch = null;
            }
        }
    }

    private void validateOwned() {
        if (this.batch == null) {
            throw new StoreException("Batch has already lost ownership");
        }
    }
}

