/*
 * Decompiled with CFR 0.152.
 */
package org.schwefel.kv;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.rocksdb.RocksIterator;
import org.schwefel.kv.BasicOps;
import org.schwefel.kv.ForEachKeyValue;
import org.schwefel.kv.Stats;
import org.schwefel.kv.StoreException;

abstract class AbstractForEach
implements ForEachKeyValue {
    volatile RocksIterator iter;
    private volatile BasicOps ops;
    private final Stats stats;

    AbstractForEach(RocksIterator iter, Stats stats, BasicOps ops) {
        this.iter = Objects.requireNonNull(iter);
        this.ops = ops;
        this.stats = stats;
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            try {
                if (this.iter.isOwningHandle()) {
                    this.iter.close();
                    this.stats.decOpenCursorsCount();
                }
            }
            finally {
                this.iter = null;
                this.ops = null;
            }
        }
    }

    @Override
    public abstract void forEachRemaining(BiConsumer<byte[], byte[]> var1);

    @Override
    public abstract void forEachUntilLimit(BiConsumer<byte[], byte[]> var1, long var2);

    @Override
    public abstract boolean tryAdvance(BiConsumer<byte[], byte[]> var1);

    @Override
    public BasicOps ops() {
        return this.ops;
    }

    private boolean isOpen() {
        return this.iter != null;
    }

    void checkOpen() {
        if (!this.isOpen()) {
            throw new StoreException("ForEachKeyValue is exhausted or closed");
        }
    }
}

