/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.Objects;

public class Status {
    private final Code code;
    private final SubCode subCode;
    private final String state;

    public Status(Code code, SubCode subCode, String state) {
        this.code = code;
        this.subCode = subCode;
        this.state = state;
    }

    Status(byte code, byte subCode, String state) {
        this.code = Code.getCode(code);
        this.subCode = SubCode.getSubCode(subCode);
        this.state = state;
    }

    public Code getCode() {
        return this.code;
    }

    public SubCode getSubCode() {
        return this.subCode;
    }

    public String getState() {
        return this.state;
    }

    public String getCodeString() {
        StringBuilder builder = new StringBuilder().append(this.code.name());
        if (this.subCode != null && this.subCode != SubCode.None) {
            builder.append("(").append(this.subCode.name()).append(")");
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Status status = (Status)o;
        return this.code == status.code && this.subCode == status.subCode && Objects.equals(this.state, status.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.subCode, this.state});
    }

    public static enum SubCode {
        None(0),
        MutexTimeout(1),
        LockTimeout(2),
        LockLimit(3),
        NoSpace(4),
        Deadlock(5),
        StaleFile(6),
        MemoryLimit(7),
        Undefined(127);

        private final byte value;

        private SubCode(byte value) {
            this.value = value;
        }

        public static SubCode getSubCode(byte value) {
            for (SubCode subCode : SubCode.values()) {
                if (subCode.value != value) continue;
                return subCode;
            }
            throw new IllegalArgumentException("Illegal value provided for SubCode (" + value + ").");
        }

        public byte getValue() {
            return this.value;
        }
    }

    public static enum Code {
        Ok(0),
        NotFound(1),
        Corruption(2),
        NotSupported(3),
        InvalidArgument(4),
        IOError(5),
        MergeInProgress(6),
        Incomplete(7),
        ShutdownInProgress(8),
        TimedOut(9),
        Aborted(10),
        Busy(11),
        Expired(12),
        TryAgain(13),
        Undefined(127);

        private final byte value;

        private Code(byte value) {
            this.value = value;
        }

        public static Code getCode(byte value) {
            for (Code code : Code.values()) {
                if (code.value != value) continue;
                return code;
            }
            throw new IllegalArgumentException("Illegal value provided for Code (" + value + ").");
        }

        public byte getValue() {
            return this.value;
        }
    }
}

