/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OptionString {
    private static final char kvPairSeparator = ';';
    private static final char kvSeparator = '=';
    private static final char complexValueBegin = '{';
    private static final char complexValueEnd = '}';
    private static final char wrappedValueBegin = '{';
    private static final char wrappedValueEnd = '}';
    private static final char arrayValueSeparator = ':';

    static class Parser {
        final String str;
        final StringBuilder sb;

        private Parser(String str) {
            this.str = str;
            this.sb = new StringBuilder(str);
        }

        private void exception(String message) {
            int pos = this.str.length() - this.sb.length();
            int before = Math.min(pos, 64);
            int after = Math.min(64, this.str.length() - pos);
            String here = this.str.substring(pos - before, pos) + "__*HERE*__" + this.str.substring(pos, pos + after);
            throw new Exception(message + " at [" + here + "]");
        }

        private void skipWhite() {
            while (this.sb.length() > 0 && Character.isWhitespace(this.sb.charAt(0))) {
                this.sb.delete(0, 1);
            }
        }

        private char first() {
            if (this.sb.length() == 0) {
                this.exception("Unexpected end of input");
            }
            return this.sb.charAt(0);
        }

        private char next() {
            if (this.sb.length() == 0) {
                this.exception("Unexpected end of input");
            }
            char c = this.sb.charAt(0);
            this.sb.delete(0, 1);
            return c;
        }

        private boolean hasNext() {
            return this.sb.length() > 0;
        }

        private boolean is(char c) {
            return this.sb.length() > 0 && this.sb.charAt(0) == c;
        }

        private boolean isKeyChar() {
            if (!this.hasNext()) {
                return false;
            }
            char c = this.first();
            return Character.isAlphabetic(c) || Character.isDigit(c) || "_".indexOf(c) != -1;
        }

        private boolean isValueChar() {
            if (!this.hasNext()) {
                return false;
            }
            char c = this.first();
            return Character.isAlphabetic(c) || Character.isDigit(c) || "_-+.[]".indexOf(c) != -1;
        }

        private String parseKey() {
            StringBuilder sbKey = new StringBuilder();
            sbKey.append(this.next());
            while (this.isKeyChar()) {
                sbKey.append(this.next());
            }
            return sbKey.toString();
        }

        private String parseSimpleValue() {
            if (this.is('{')) {
                this.next();
                String result = this.parseSimpleValue();
                if (!this.is('}')) {
                    this.exception("Expected to end a wrapped value with }");
                }
                this.next();
                return result;
            }
            StringBuilder sbValue = new StringBuilder();
            while (this.isValueChar()) {
                sbValue.append(this.next());
            }
            return sbValue.toString();
        }

        private List<String> parseList() {
            ArrayList<String> list = new ArrayList<String>(1);
            while (true) {
                list.add(this.parseSimpleValue());
                if (!this.is(':')) break;
                this.next();
            }
            return list;
        }

        private Entry parseOption() {
            this.skipWhite();
            if (!this.isKeyChar()) {
                this.exception("No valid key character(s) for key in key=value ");
            }
            String key = this.parseKey();
            this.skipWhite();
            if (this.is('=')) {
                this.next();
            } else {
                this.exception("Expected = separating key and value");
            }
            this.skipWhite();
            Value value = this.parseValue();
            return new Entry(key, value);
        }

        private Value parseValue() {
            this.skipWhite();
            if (this.is('{')) {
                this.next();
                this.skipWhite();
                Value value = Value.fromComplex(this.parseComplex());
                this.skipWhite();
                if (this.is('}')) {
                    this.next();
                    this.skipWhite();
                } else {
                    this.exception("Expected } ending complex value");
                }
                return value;
            }
            if (this.isValueChar()) {
                return Value.fromList(this.parseList());
            }
            this.exception("No valid value character(s) for value in key=value");
            return null;
        }

        private List<Entry> parseComplex() {
            ArrayList<Entry> entries = new ArrayList<Entry>();
            this.skipWhite();
            if (this.hasNext()) {
                entries.add(this.parseOption());
                this.skipWhite();
                while (this.is(';')) {
                    this.next();
                    this.skipWhite();
                    if (!this.isKeyChar()) break;
                    entries.add(this.parseOption());
                    this.skipWhite();
                }
            }
            return entries;
        }

        public static List<Entry> parse(String str) {
            Objects.requireNonNull(str);
            Parser parser = new Parser(str);
            List<Entry> result = parser.parseComplex();
            if (parser.hasNext()) {
                parser.exception("Unexpected end of parsing ");
            }
            return result;
        }

        static class Exception
        extends RuntimeException {
            public Exception(String s) {
                super(s);
            }
        }
    }

    static class Entry {
        public final String key;
        public final Value value;

        Entry(String key, Value value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return "" + this.key + "=" + this.value;
        }
    }

    static class Value {
        final List<String> list;
        final List<Entry> complex;

        public Value(List<String> list, List<Entry> complex) {
            this.list = list;
            this.complex = complex;
        }

        public boolean isList() {
            return this.list != null && this.complex == null;
        }

        public static Value fromList(List<String> list) {
            return new Value(list, null);
        }

        public static Value fromComplex(List<Entry> complex) {
            return new Value(null, complex);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.isList()) {
                for (String item : this.list) {
                    sb.append(item).append(':');
                }
                if (sb.length() > 0) {
                    sb.delete(sb.length() - 1, sb.length());
                }
            } else {
                sb.append('[');
                for (Entry entry : this.complex) {
                    sb.append(entry.toString()).append(';');
                }
                sb.append(']');
            }
            return sb.toString();
        }
    }
}

