/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.rocksdb.AbstractMutableOptions;
import org.rocksdb.MutableDBOptionsInterface;
import org.rocksdb.MutableOptionKey;
import org.rocksdb.OptionString;

public class MutableDBOptions
extends AbstractMutableOptions {
    MutableDBOptions(String[] keys, String[] values) {
        super(keys, values);
    }

    public static MutableDBOptionsBuilder builder() {
        return new MutableDBOptionsBuilder();
    }

    public static MutableDBOptionsBuilder parse(String str, boolean ignoreUnknown) {
        Objects.requireNonNull(str);
        List<OptionString.Entry> parsedOptions = OptionString.Parser.parse(str);
        return (MutableDBOptionsBuilder)new MutableDBOptionsBuilder().fromParsed(parsedOptions, ignoreUnknown);
    }

    public static MutableDBOptionsBuilder parse(String str) {
        return MutableDBOptions.parse(str, false);
    }

    public static class MutableDBOptionsBuilder
    extends AbstractMutableOptions.AbstractMutableOptionsBuilder<MutableDBOptions, MutableDBOptionsBuilder, MutableDBOptionKey>
    implements MutableDBOptionsInterface<MutableDBOptionsBuilder> {
        private static final Map<String, MutableDBOptionKey> ALL_KEYS_LOOKUP = new HashMap<String, MutableDBOptionKey>();

        MutableDBOptionsBuilder() {
        }

        @Override
        protected MutableDBOptionsBuilder self() {
            return this;
        }

        @Override
        protected Map<String, MutableDBOptionKey> allKeys() {
            return ALL_KEYS_LOOKUP;
        }

        @Override
        protected MutableDBOptions build(String[] keys, String[] values) {
            return new MutableDBOptions(keys, values);
        }

        @Override
        public MutableDBOptionsBuilder setMaxBackgroundJobs(int maxBackgroundJobs) {
            return (MutableDBOptionsBuilder)this.setInt(DBOption.max_background_jobs, maxBackgroundJobs);
        }

        @Override
        public int maxBackgroundJobs() {
            return this.getInt(DBOption.max_background_jobs);
        }

        @Override
        @Deprecated
        public MutableDBOptionsBuilder setMaxBackgroundCompactions(int maxBackgroundCompactions) {
            return (MutableDBOptionsBuilder)this.setInt(DBOption.max_background_compactions, maxBackgroundCompactions);
        }

        @Override
        @Deprecated
        public int maxBackgroundCompactions() {
            return this.getInt(DBOption.max_background_compactions);
        }

        @Override
        public MutableDBOptionsBuilder setAvoidFlushDuringShutdown(boolean avoidFlushDuringShutdown) {
            return (MutableDBOptionsBuilder)this.setBoolean(DBOption.avoid_flush_during_shutdown, avoidFlushDuringShutdown);
        }

        @Override
        public boolean avoidFlushDuringShutdown() {
            return this.getBoolean(DBOption.avoid_flush_during_shutdown);
        }

        @Override
        public MutableDBOptionsBuilder setWritableFileMaxBufferSize(long writableFileMaxBufferSize) {
            return (MutableDBOptionsBuilder)this.setLong(DBOption.writable_file_max_buffer_size, writableFileMaxBufferSize);
        }

        @Override
        public long writableFileMaxBufferSize() {
            return this.getLong(DBOption.writable_file_max_buffer_size);
        }

        @Override
        public MutableDBOptionsBuilder setDelayedWriteRate(long delayedWriteRate) {
            return (MutableDBOptionsBuilder)this.setLong(DBOption.delayed_write_rate, delayedWriteRate);
        }

        @Override
        public long delayedWriteRate() {
            return this.getLong(DBOption.delayed_write_rate);
        }

        @Override
        public MutableDBOptionsBuilder setMaxTotalWalSize(long maxTotalWalSize) {
            return (MutableDBOptionsBuilder)this.setLong(DBOption.max_total_wal_size, maxTotalWalSize);
        }

        @Override
        public long maxTotalWalSize() {
            return this.getLong(DBOption.max_total_wal_size);
        }

        @Override
        public MutableDBOptionsBuilder setDeleteObsoleteFilesPeriodMicros(long micros) {
            return (MutableDBOptionsBuilder)this.setLong(DBOption.delete_obsolete_files_period_micros, micros);
        }

        @Override
        public long deleteObsoleteFilesPeriodMicros() {
            return this.getLong(DBOption.delete_obsolete_files_period_micros);
        }

        @Override
        public MutableDBOptionsBuilder setStatsDumpPeriodSec(int statsDumpPeriodSec) {
            return (MutableDBOptionsBuilder)this.setInt(DBOption.stats_dump_period_sec, statsDumpPeriodSec);
        }

        @Override
        public int statsDumpPeriodSec() {
            return this.getInt(DBOption.stats_dump_period_sec);
        }

        @Override
        public MutableDBOptionsBuilder setStatsPersistPeriodSec(int statsPersistPeriodSec) {
            return (MutableDBOptionsBuilder)this.setInt(DBOption.stats_persist_period_sec, statsPersistPeriodSec);
        }

        @Override
        public int statsPersistPeriodSec() {
            return this.getInt(DBOption.stats_persist_period_sec);
        }

        @Override
        public MutableDBOptionsBuilder setStatsHistoryBufferSize(long statsHistoryBufferSize) {
            return (MutableDBOptionsBuilder)this.setLong(DBOption.stats_history_buffer_size, statsHistoryBufferSize);
        }

        @Override
        public long statsHistoryBufferSize() {
            return this.getLong(DBOption.stats_history_buffer_size);
        }

        @Override
        public MutableDBOptionsBuilder setMaxOpenFiles(int maxOpenFiles) {
            return (MutableDBOptionsBuilder)this.setInt(DBOption.max_open_files, maxOpenFiles);
        }

        @Override
        public int maxOpenFiles() {
            return this.getInt(DBOption.max_open_files);
        }

        @Override
        public MutableDBOptionsBuilder setBytesPerSync(long bytesPerSync) {
            return (MutableDBOptionsBuilder)this.setLong(DBOption.bytes_per_sync, bytesPerSync);
        }

        @Override
        public long bytesPerSync() {
            return this.getLong(DBOption.bytes_per_sync);
        }

        @Override
        public MutableDBOptionsBuilder setWalBytesPerSync(long walBytesPerSync) {
            return (MutableDBOptionsBuilder)this.setLong(DBOption.wal_bytes_per_sync, walBytesPerSync);
        }

        @Override
        public long walBytesPerSync() {
            return this.getLong(DBOption.wal_bytes_per_sync);
        }

        @Override
        public MutableDBOptionsBuilder setStrictBytesPerSync(boolean strictBytesPerSync) {
            return (MutableDBOptionsBuilder)this.setBoolean(DBOption.strict_bytes_per_sync, strictBytesPerSync);
        }

        @Override
        public boolean strictBytesPerSync() {
            return this.getBoolean(DBOption.strict_bytes_per_sync);
        }

        @Override
        public MutableDBOptionsBuilder setCompactionReadaheadSize(long compactionReadaheadSize) {
            return (MutableDBOptionsBuilder)this.setLong(DBOption.compaction_readahead_size, compactionReadaheadSize);
        }

        @Override
        public long compactionReadaheadSize() {
            return this.getLong(DBOption.compaction_readahead_size);
        }

        static {
            for (DBOption key : DBOption.values()) {
                ALL_KEYS_LOOKUP.put(key.name(), key);
            }
        }
    }

    public static enum DBOption implements MutableDBOptionKey
    {
        max_background_jobs(MutableOptionKey.ValueType.INT),
        max_background_compactions(MutableOptionKey.ValueType.INT),
        avoid_flush_during_shutdown(MutableOptionKey.ValueType.BOOLEAN),
        writable_file_max_buffer_size(MutableOptionKey.ValueType.LONG),
        delayed_write_rate(MutableOptionKey.ValueType.LONG),
        max_total_wal_size(MutableOptionKey.ValueType.LONG),
        delete_obsolete_files_period_micros(MutableOptionKey.ValueType.LONG),
        stats_dump_period_sec(MutableOptionKey.ValueType.INT),
        stats_persist_period_sec(MutableOptionKey.ValueType.INT),
        stats_history_buffer_size(MutableOptionKey.ValueType.LONG),
        max_open_files(MutableOptionKey.ValueType.INT),
        bytes_per_sync(MutableOptionKey.ValueType.LONG),
        wal_bytes_per_sync(MutableOptionKey.ValueType.LONG),
        strict_bytes_per_sync(MutableOptionKey.ValueType.BOOLEAN),
        compaction_readahead_size(MutableOptionKey.ValueType.LONG);

        private final MutableOptionKey.ValueType valueType;

        private DBOption(MutableOptionKey.ValueType valueType) {
            this.valueType = valueType;
        }

        @Override
        public MutableOptionKey.ValueType getValueType() {
            return this.valueType;
        }
    }

    private static interface MutableDBOptionKey
    extends MutableOptionKey {
    }
}

