/*
 * Decompiled with CFR 0.152.
 */
package org.schwefel.kv;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rocksdb.RocksIterator;
import org.schwefel.kv.AbstractForEach;
import org.schwefel.kv.BasicOps;
import org.schwefel.kv.Stats;

class ForEachAll
extends AbstractForEach {
    private static final Logger logger = Logger.getLogger(ForEachAll.class.getName());

    ForEachAll(RocksIterator iter, Stats stats, BasicOps ops) {
        super(iter, stats, ops);
    }

    @Override
    public synchronized void forEachRemaining(BiConsumer<byte[], byte[]> action) {
        this.forEachUntilLimit(action, Long.MAX_VALUE);
    }

    @Override
    public synchronized void forEachUntilLimit(BiConsumer<byte[], byte[]> action, long limit) {
        Objects.requireNonNull(action, "action cannot be null");
        this.checkOpen();
        try {
            long count = 0L;
            while (this.iter.isValid() && count++ < limit) {
                action.accept(this.iter.key(), this.iter.value());
                this.iter.next();
            }
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "closing ForEachAll", e);
            throw e;
        }
        finally {
            this.close();
        }
    }

    @Override
    public synchronized boolean tryAdvance(BiConsumer<byte[], byte[]> action) {
        Objects.requireNonNull(action, "action cannot be null");
        this.checkOpen();
        if (this.iter.isValid()) {
            try {
                action.accept(this.iter.key(), this.iter.value());
                this.iter.next();
            }
            catch (RuntimeException e) {
                this.close();
                logger.log(Level.WARNING, "closing ForEachAll", e);
                throw e;
            }
            return true;
        }
        this.close();
        return false;
    }
}

