/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.rocksdb.AbstractTransactionNotifier;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.RocksObject;
import org.rocksdb.Snapshot;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBatchWithIndex;
import org.rocksdb.WriteOptions;

public class Transaction
extends RocksObject {
    private final RocksDB parent;

    Transaction(RocksDB parent, long transactionHandle) {
        super(transactionHandle);
        this.parent = parent;
    }

    public void setSnapshot() {
        assert (this.isOwningHandle());
        this.setSnapshot(this.nativeHandle_);
    }

    public void setSnapshotOnNextOperation() {
        assert (this.isOwningHandle());
        this.setSnapshotOnNextOperation(this.nativeHandle_);
    }

    public void setSnapshotOnNextOperation(AbstractTransactionNotifier transactionNotifier) {
        assert (this.isOwningHandle());
        this.setSnapshotOnNextOperation(this.nativeHandle_, transactionNotifier.nativeHandle_);
    }

    public Snapshot getSnapshot() {
        assert (this.isOwningHandle());
        long snapshotNativeHandle = this.getSnapshot(this.nativeHandle_);
        if (snapshotNativeHandle == 0L) {
            return null;
        }
        Snapshot snapshot = new Snapshot(snapshotNativeHandle);
        return snapshot;
    }

    public void clearSnapshot() {
        assert (this.isOwningHandle());
        this.clearSnapshot(this.nativeHandle_);
    }

    void prepare() throws RocksDBException {
        assert (this.isOwningHandle());
        this.prepare(this.nativeHandle_);
    }

    public void commit() throws RocksDBException {
        assert (this.isOwningHandle());
        this.commit(this.nativeHandle_);
    }

    public void rollback() throws RocksDBException {
        assert (this.isOwningHandle());
        this.rollback(this.nativeHandle_);
    }

    public void setSavePoint() throws RocksDBException {
        assert (this.isOwningHandle());
        this.setSavePoint(this.nativeHandle_);
    }

    public void rollbackToSavePoint() throws RocksDBException {
        assert (this.isOwningHandle());
        this.rollbackToSavePoint(this.nativeHandle_);
    }

    public byte[] get(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, byte[] key) throws RocksDBException {
        assert (this.isOwningHandle());
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, key, key.length, columnFamilyHandle.nativeHandle_);
    }

    public byte[] get(ReadOptions readOptions, byte[] key) throws RocksDBException {
        assert (this.isOwningHandle());
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, key, key.length);
    }

    @Deprecated
    public byte[][] multiGet(ReadOptions readOptions, List<ColumnFamilyHandle> columnFamilyHandles, byte[][] keys) throws RocksDBException {
        assert (this.isOwningHandle());
        if (keys.length != columnFamilyHandles.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        if (keys.length == 0) {
            return new byte[0][0];
        }
        long[] cfHandles = new long[columnFamilyHandles.size()];
        for (int i = 0; i < columnFamilyHandles.size(); ++i) {
            cfHandles[i] = columnFamilyHandles.get((int)i).nativeHandle_;
        }
        return this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, keys, cfHandles);
    }

    public List<byte[]> multiGetAsList(ReadOptions readOptions, List<ColumnFamilyHandle> columnFamilyHandles, List<byte[]> keys) throws RocksDBException {
        assert (this.isOwningHandle());
        if (keys.size() != columnFamilyHandles.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        if (keys.size() == 0) {
            return new ArrayList<byte[]>(0);
        }
        byte[][] keysArray = (byte[][])keys.toArray((T[])new byte[keys.size()][]);
        long[] cfHandles = new long[columnFamilyHandles.size()];
        for (int i = 0; i < columnFamilyHandles.size(); ++i) {
            cfHandles[i] = columnFamilyHandles.get((int)i).nativeHandle_;
        }
        return Arrays.asList(this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, keysArray, cfHandles));
    }

    @Deprecated
    public byte[][] multiGet(ReadOptions readOptions, byte[][] keys) throws RocksDBException {
        assert (this.isOwningHandle());
        if (keys.length == 0) {
            return new byte[0][0];
        }
        return this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, keys);
    }

    public List<byte[]> multiGetAsList(ReadOptions readOptions, List<byte[]> keys) throws RocksDBException {
        if (keys.size() == 0) {
            return new ArrayList<byte[]>(0);
        }
        byte[][] keysArray = (byte[][])keys.toArray((T[])new byte[keys.size()][]);
        return Arrays.asList(this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, keysArray));
    }

    public byte[] getForUpdate(ReadOptions readOptions, ColumnFamilyHandle columnFamilyHandle, byte[] key, boolean exclusive, boolean doValidate) throws RocksDBException {
        assert (this.isOwningHandle());
        return this.getForUpdate(this.nativeHandle_, readOptions.nativeHandle_, key, key.length, columnFamilyHandle.nativeHandle_, exclusive, doValidate);
    }

    public byte[] getForUpdate(ReadOptions readOptions, ColumnFamilyHandle columnFamilyHandle, byte[] key, boolean exclusive) throws RocksDBException {
        assert (this.isOwningHandle());
        return this.getForUpdate(this.nativeHandle_, readOptions.nativeHandle_, key, key.length, columnFamilyHandle.nativeHandle_, exclusive, true);
    }

    public byte[] getForUpdate(ReadOptions readOptions, byte[] key, boolean exclusive) throws RocksDBException {
        assert (this.isOwningHandle());
        return this.getForUpdate(this.nativeHandle_, readOptions.nativeHandle_, key, key.length, exclusive, true);
    }

    @Deprecated
    public byte[][] multiGetForUpdate(ReadOptions readOptions, List<ColumnFamilyHandle> columnFamilyHandles, byte[][] keys) throws RocksDBException {
        assert (this.isOwningHandle());
        if (keys.length != columnFamilyHandles.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        if (keys.length == 0) {
            return new byte[0][0];
        }
        long[] cfHandles = new long[columnFamilyHandles.size()];
        for (int i = 0; i < columnFamilyHandles.size(); ++i) {
            cfHandles[i] = columnFamilyHandles.get((int)i).nativeHandle_;
        }
        return this.multiGetForUpdate(this.nativeHandle_, readOptions.nativeHandle_, keys, cfHandles);
    }

    public List<byte[]> multiGetForUpdateAsList(ReadOptions readOptions, List<ColumnFamilyHandle> columnFamilyHandles, List<byte[]> keys) throws RocksDBException {
        assert (this.isOwningHandle());
        if (keys.size() != columnFamilyHandles.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        if (keys.size() == 0) {
            return new ArrayList<byte[]>();
        }
        byte[][] keysArray = (byte[][])keys.toArray((T[])new byte[keys.size()][]);
        long[] cfHandles = new long[columnFamilyHandles.size()];
        for (int i = 0; i < columnFamilyHandles.size(); ++i) {
            cfHandles[i] = columnFamilyHandles.get((int)i).nativeHandle_;
        }
        return Arrays.asList(this.multiGetForUpdate(this.nativeHandle_, readOptions.nativeHandle_, keysArray, cfHandles));
    }

    @Deprecated
    public byte[][] multiGetForUpdate(ReadOptions readOptions, byte[][] keys) throws RocksDBException {
        assert (this.isOwningHandle());
        if (keys.length == 0) {
            return new byte[0][0];
        }
        return this.multiGetForUpdate(this.nativeHandle_, readOptions.nativeHandle_, keys);
    }

    public List<byte[]> multiGetForUpdateAsList(ReadOptions readOptions, List<byte[]> keys) throws RocksDBException {
        assert (this.isOwningHandle());
        if (keys.size() == 0) {
            return new ArrayList<byte[]>(0);
        }
        byte[][] keysArray = (byte[][])keys.toArray((T[])new byte[keys.size()][]);
        return Arrays.asList(this.multiGetForUpdate(this.nativeHandle_, readOptions.nativeHandle_, keysArray));
    }

    public RocksIterator getIterator(ReadOptions readOptions) {
        assert (this.isOwningHandle());
        return new RocksIterator(this.parent, this.getIterator(this.nativeHandle_, readOptions.nativeHandle_));
    }

    public RocksIterator getIterator(ReadOptions readOptions, ColumnFamilyHandle columnFamilyHandle) {
        assert (this.isOwningHandle());
        return new RocksIterator(this.parent, this.getIterator(this.nativeHandle_, readOptions.nativeHandle_, columnFamilyHandle.nativeHandle_));
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[] key, byte[] value, boolean assumeTracked) throws RocksDBException {
        assert (this.isOwningHandle());
        this.put(this.nativeHandle_, key, key.length, value, value.length, columnFamilyHandle.nativeHandle_, assumeTracked);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[] key, byte[] value) throws RocksDBException {
        assert (this.isOwningHandle());
        this.put(this.nativeHandle_, key, key.length, value, value.length, columnFamilyHandle.nativeHandle_, false);
    }

    public void put(byte[] key, byte[] value) throws RocksDBException {
        assert (this.isOwningHandle());
        this.put(this.nativeHandle_, key, key.length, value, value.length);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[][] keyParts, byte[][] valueParts, boolean assumeTracked) throws RocksDBException {
        assert (this.isOwningHandle());
        this.put(this.nativeHandle_, keyParts, keyParts.length, valueParts, valueParts.length, columnFamilyHandle.nativeHandle_, assumeTracked);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[][] keyParts, byte[][] valueParts) throws RocksDBException {
        assert (this.isOwningHandle());
        this.put(this.nativeHandle_, keyParts, keyParts.length, valueParts, valueParts.length, columnFamilyHandle.nativeHandle_, false);
    }

    public void put(byte[][] keyParts, byte[][] valueParts) throws RocksDBException {
        assert (this.isOwningHandle());
        this.put(this.nativeHandle_, keyParts, keyParts.length, valueParts, valueParts.length);
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, byte[] key, byte[] value, boolean assumeTracked) throws RocksDBException {
        assert (this.isOwningHandle());
        this.merge(this.nativeHandle_, key, key.length, value, value.length, columnFamilyHandle.nativeHandle_, assumeTracked);
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, byte[] key, byte[] value) throws RocksDBException {
        assert (this.isOwningHandle());
        this.merge(this.nativeHandle_, key, key.length, value, value.length, columnFamilyHandle.nativeHandle_, false);
    }

    public void merge(byte[] key, byte[] value) throws RocksDBException {
        assert (this.isOwningHandle());
        this.merge(this.nativeHandle_, key, key.length, value, value.length);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[] key, boolean assumeTracked) throws RocksDBException {
        assert (this.isOwningHandle());
        this.delete(this.nativeHandle_, key, key.length, columnFamilyHandle.nativeHandle_, assumeTracked);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[] key) throws RocksDBException {
        assert (this.isOwningHandle());
        this.delete(this.nativeHandle_, key, key.length, columnFamilyHandle.nativeHandle_, false);
    }

    public void delete(byte[] key) throws RocksDBException {
        assert (this.isOwningHandle());
        this.delete(this.nativeHandle_, key, key.length);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[][] keyParts, boolean assumeTracked) throws RocksDBException {
        assert (this.isOwningHandle());
        this.delete(this.nativeHandle_, keyParts, keyParts.length, columnFamilyHandle.nativeHandle_, assumeTracked);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[][] keyParts) throws RocksDBException {
        assert (this.isOwningHandle());
        this.delete(this.nativeHandle_, keyParts, keyParts.length, columnFamilyHandle.nativeHandle_, false);
    }

    public void delete(byte[][] keyParts) throws RocksDBException {
        assert (this.isOwningHandle());
        this.delete(this.nativeHandle_, keyParts, keyParts.length);
    }

    public void singleDelete(ColumnFamilyHandle columnFamilyHandle, byte[] key, boolean assumeTracked) throws RocksDBException {
        assert (this.isOwningHandle());
        this.singleDelete(this.nativeHandle_, key, key.length, columnFamilyHandle.nativeHandle_, assumeTracked);
    }

    public void singleDelete(ColumnFamilyHandle columnFamilyHandle, byte[] key) throws RocksDBException {
        assert (this.isOwningHandle());
        this.singleDelete(this.nativeHandle_, key, key.length, columnFamilyHandle.nativeHandle_, false);
    }

    public void singleDelete(byte[] key) throws RocksDBException {
        assert (this.isOwningHandle());
        this.singleDelete(this.nativeHandle_, key, key.length);
    }

    public void singleDelete(ColumnFamilyHandle columnFamilyHandle, byte[][] keyParts, boolean assumeTracked) throws RocksDBException {
        assert (this.isOwningHandle());
        this.singleDelete(this.nativeHandle_, keyParts, keyParts.length, columnFamilyHandle.nativeHandle_, assumeTracked);
    }

    public void singleDelete(ColumnFamilyHandle columnFamilyHandle, byte[][] keyParts) throws RocksDBException {
        assert (this.isOwningHandle());
        this.singleDelete(this.nativeHandle_, keyParts, keyParts.length, columnFamilyHandle.nativeHandle_, false);
    }

    public void singleDelete(byte[][] keyParts) throws RocksDBException {
        assert (this.isOwningHandle());
        this.singleDelete(this.nativeHandle_, keyParts, keyParts.length);
    }

    public void putUntracked(ColumnFamilyHandle columnFamilyHandle, byte[] key, byte[] value) throws RocksDBException {
        assert (this.isOwningHandle());
        this.putUntracked(this.nativeHandle_, key, key.length, value, value.length, columnFamilyHandle.nativeHandle_);
    }

    public void putUntracked(byte[] key, byte[] value) throws RocksDBException {
        assert (this.isOwningHandle());
        this.putUntracked(this.nativeHandle_, key, key.length, value, value.length);
    }

    public void putUntracked(ColumnFamilyHandle columnFamilyHandle, byte[][] keyParts, byte[][] valueParts) throws RocksDBException {
        assert (this.isOwningHandle());
        this.putUntracked(this.nativeHandle_, keyParts, keyParts.length, valueParts, valueParts.length, columnFamilyHandle.nativeHandle_);
    }

    public void putUntracked(byte[][] keyParts, byte[][] valueParts) throws RocksDBException {
        assert (this.isOwningHandle());
        this.putUntracked(this.nativeHandle_, keyParts, keyParts.length, valueParts, valueParts.length);
    }

    public void mergeUntracked(ColumnFamilyHandle columnFamilyHandle, byte[] key, byte[] value) throws RocksDBException {
        this.mergeUntracked(this.nativeHandle_, key, key.length, value, value.length, columnFamilyHandle.nativeHandle_);
    }

    public void mergeUntracked(byte[] key, byte[] value) throws RocksDBException {
        assert (this.isOwningHandle());
        this.mergeUntracked(this.nativeHandle_, key, key.length, value, value.length);
    }

    public void deleteUntracked(ColumnFamilyHandle columnFamilyHandle, byte[] key) throws RocksDBException {
        assert (this.isOwningHandle());
        this.deleteUntracked(this.nativeHandle_, key, key.length, columnFamilyHandle.nativeHandle_);
    }

    public void deleteUntracked(byte[] key) throws RocksDBException {
        assert (this.isOwningHandle());
        this.deleteUntracked(this.nativeHandle_, key, key.length);
    }

    public void deleteUntracked(ColumnFamilyHandle columnFamilyHandle, byte[][] keyParts) throws RocksDBException {
        assert (this.isOwningHandle());
        this.deleteUntracked(this.nativeHandle_, keyParts, keyParts.length, columnFamilyHandle.nativeHandle_);
    }

    public void deleteUntracked(byte[][] keyParts) throws RocksDBException {
        assert (this.isOwningHandle());
        this.deleteUntracked(this.nativeHandle_, keyParts, keyParts.length);
    }

    public void putLogData(byte[] blob) {
        assert (this.isOwningHandle());
        this.putLogData(this.nativeHandle_, blob, blob.length);
    }

    public void disableIndexing() {
        assert (this.isOwningHandle());
        this.disableIndexing(this.nativeHandle_);
    }

    public void enableIndexing() {
        assert (this.isOwningHandle());
        this.enableIndexing(this.nativeHandle_);
    }

    public long getNumKeys() {
        assert (this.isOwningHandle());
        return this.getNumKeys(this.nativeHandle_);
    }

    public long getNumPuts() {
        assert (this.isOwningHandle());
        return this.getNumPuts(this.nativeHandle_);
    }

    public long getNumDeletes() {
        assert (this.isOwningHandle());
        return this.getNumDeletes(this.nativeHandle_);
    }

    public long getNumMerges() {
        assert (this.isOwningHandle());
        return this.getNumMerges(this.nativeHandle_);
    }

    public long getElapsedTime() {
        assert (this.isOwningHandle());
        return this.getElapsedTime(this.nativeHandle_);
    }

    public WriteBatchWithIndex getWriteBatch() {
        assert (this.isOwningHandle());
        WriteBatchWithIndex writeBatchWithIndex = new WriteBatchWithIndex(this.getWriteBatch(this.nativeHandle_));
        return writeBatchWithIndex;
    }

    public void setLockTimeout(long lockTimeout) {
        assert (this.isOwningHandle());
        this.setLockTimeout(this.nativeHandle_, lockTimeout);
    }

    public WriteOptions getWriteOptions() {
        assert (this.isOwningHandle());
        WriteOptions writeOptions = new WriteOptions(this.getWriteOptions(this.nativeHandle_));
        return writeOptions;
    }

    public void setWriteOptions(WriteOptions writeOptions) {
        assert (this.isOwningHandle());
        this.setWriteOptions(this.nativeHandle_, writeOptions.nativeHandle_);
    }

    public void undoGetForUpdate(ColumnFamilyHandle columnFamilyHandle, byte[] key) {
        assert (this.isOwningHandle());
        this.undoGetForUpdate(this.nativeHandle_, key, key.length, columnFamilyHandle.nativeHandle_);
    }

    public void undoGetForUpdate(byte[] key) {
        assert (this.isOwningHandle());
        this.undoGetForUpdate(this.nativeHandle_, key, key.length);
    }

    public void rebuildFromWriteBatch(WriteBatch writeBatch) throws RocksDBException {
        assert (this.isOwningHandle());
        this.rebuildFromWriteBatch(this.nativeHandle_, writeBatch.nativeHandle_);
    }

    public WriteBatch getCommitTimeWriteBatch() {
        assert (this.isOwningHandle());
        WriteBatch writeBatch = new WriteBatch(this.getCommitTimeWriteBatch(this.nativeHandle_));
        return writeBatch;
    }

    public void setLogNumber(long logNumber) {
        assert (this.isOwningHandle());
        this.setLogNumber(this.nativeHandle_, logNumber);
    }

    public long getLogNumber() {
        assert (this.isOwningHandle());
        return this.getLogNumber(this.nativeHandle_);
    }

    public void setName(String transactionName) throws RocksDBException {
        assert (this.isOwningHandle());
        this.setName(this.nativeHandle_, transactionName);
    }

    public String getName() {
        assert (this.isOwningHandle());
        return this.getName(this.nativeHandle_);
    }

    public long getID() {
        assert (this.isOwningHandle());
        return this.getID(this.nativeHandle_);
    }

    public boolean isDeadlockDetect() {
        assert (this.isOwningHandle());
        return this.isDeadlockDetect(this.nativeHandle_);
    }

    public WaitingTransactions getWaitingTxns() {
        assert (this.isOwningHandle());
        return this.getWaitingTxns(this.nativeHandle_);
    }

    public TransactionState getState() {
        assert (this.isOwningHandle());
        return TransactionState.getTransactionState(this.getState(this.nativeHandle_));
    }

    public long getId() {
        assert (this.isOwningHandle());
        return this.getId(this.nativeHandle_);
    }

    private static WaitingTransactions newWaitingTransactions(long columnFamilyId, String key, long[] transactionIds) {
        return new WaitingTransactions(columnFamilyId, key, transactionIds);
    }

    private native void setSnapshot(long var1);

    private native void setSnapshotOnNextOperation(long var1);

    private native void setSnapshotOnNextOperation(long var1, long var3);

    private native long getSnapshot(long var1);

    private native void clearSnapshot(long var1);

    private native void prepare(long var1) throws RocksDBException;

    private native void commit(long var1) throws RocksDBException;

    private native void rollback(long var1) throws RocksDBException;

    private native void setSavePoint(long var1) throws RocksDBException;

    private native void rollbackToSavePoint(long var1) throws RocksDBException;

    private native byte[] get(long var1, long var3, byte[] var5, int var6, long var7) throws RocksDBException;

    private native byte[] get(long var1, long var3, byte[] var5, int var6) throws RocksDBException;

    private native byte[][] multiGet(long var1, long var3, byte[][] var5, long[] var6) throws RocksDBException;

    private native byte[][] multiGet(long var1, long var3, byte[][] var5) throws RocksDBException;

    private native byte[] getForUpdate(long var1, long var3, byte[] var5, int var6, long var7, boolean var9, boolean var10) throws RocksDBException;

    private native byte[] getForUpdate(long var1, long var3, byte[] var5, int var6, boolean var7, boolean var8) throws RocksDBException;

    private native byte[][] multiGetForUpdate(long var1, long var3, byte[][] var5, long[] var6) throws RocksDBException;

    private native byte[][] multiGetForUpdate(long var1, long var3, byte[][] var5) throws RocksDBException;

    private native long getIterator(long var1, long var3);

    private native long getIterator(long var1, long var3, long var5);

    private native void put(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7, boolean var9) throws RocksDBException;

    private native void put(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    private native void put(long var1, byte[][] var3, int var4, byte[][] var5, int var6, long var7, boolean var9) throws RocksDBException;

    private native void put(long var1, byte[][] var3, int var4, byte[][] var5, int var6) throws RocksDBException;

    private native void merge(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7, boolean var9) throws RocksDBException;

    private native void merge(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    private native void delete(long var1, byte[] var3, int var4, long var5, boolean var7) throws RocksDBException;

    private native void delete(long var1, byte[] var3, int var4) throws RocksDBException;

    private native void delete(long var1, byte[][] var3, int var4, long var5, boolean var7) throws RocksDBException;

    private native void delete(long var1, byte[][] var3, int var4) throws RocksDBException;

    private native void singleDelete(long var1, byte[] var3, int var4, long var5, boolean var7) throws RocksDBException;

    private native void singleDelete(long var1, byte[] var3, int var4) throws RocksDBException;

    private native void singleDelete(long var1, byte[][] var3, int var4, long var5, boolean var7) throws RocksDBException;

    private native void singleDelete(long var1, byte[][] var3, int var4) throws RocksDBException;

    private native void putUntracked(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7) throws RocksDBException;

    private native void putUntracked(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    private native void putUntracked(long var1, byte[][] var3, int var4, byte[][] var5, int var6, long var7) throws RocksDBException;

    private native void putUntracked(long var1, byte[][] var3, int var4, byte[][] var5, int var6) throws RocksDBException;

    private native void mergeUntracked(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7) throws RocksDBException;

    private native void mergeUntracked(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    private native void deleteUntracked(long var1, byte[] var3, int var4, long var5) throws RocksDBException;

    private native void deleteUntracked(long var1, byte[] var3, int var4) throws RocksDBException;

    private native void deleteUntracked(long var1, byte[][] var3, int var4, long var5) throws RocksDBException;

    private native void deleteUntracked(long var1, byte[][] var3, int var4) throws RocksDBException;

    private native void putLogData(long var1, byte[] var3, int var4);

    private native void disableIndexing(long var1);

    private native void enableIndexing(long var1);

    private native long getNumKeys(long var1);

    private native long getNumPuts(long var1);

    private native long getNumDeletes(long var1);

    private native long getNumMerges(long var1);

    private native long getElapsedTime(long var1);

    private native long getWriteBatch(long var1);

    private native void setLockTimeout(long var1, long var3);

    private native long getWriteOptions(long var1);

    private native void setWriteOptions(long var1, long var3);

    private native void undoGetForUpdate(long var1, byte[] var3, int var4, long var5);

    private native void undoGetForUpdate(long var1, byte[] var3, int var4);

    private native void rebuildFromWriteBatch(long var1, long var3) throws RocksDBException;

    private native long getCommitTimeWriteBatch(long var1);

    private native void setLogNumber(long var1, long var3);

    private native long getLogNumber(long var1);

    private native void setName(long var1, String var3) throws RocksDBException;

    private native String getName(long var1);

    private native long getID(long var1);

    private native boolean isDeadlockDetect(long var1);

    private native WaitingTransactions getWaitingTxns(long var1);

    private native byte getState(long var1);

    private native long getId(long var1);

    @Override
    protected final native void disposeInternal(long var1);

    public static class WaitingTransactions {
        private final long columnFamilyId;
        private final String key;
        private final long[] transactionIds;

        WaitingTransactions(long columnFamilyId, String key, long[] transactionIds) {
            this.columnFamilyId = columnFamilyId;
            this.key = key;
            this.transactionIds = transactionIds;
        }

        public long getColumnFamilyId() {
            return this.columnFamilyId;
        }

        public String getKey() {
            return this.key;
        }

        public long[] getTransactionIds() {
            return this.transactionIds;
        }
    }

    public static enum TransactionState {
        STARTED(0),
        AWAITING_PREPARE(1),
        PREPARED(2),
        AWAITING_COMMIT(3),
        COMMITTED(4),
        AWAITING_ROLLBACK(5),
        ROLLEDBACK(6),
        LOCKS_STOLEN(7);

        public static final TransactionState COMMITED;
        private final byte value;

        private TransactionState(byte value) {
            this.value = value;
        }

        public static TransactionState getTransactionState(byte value) {
            for (TransactionState transactionState : TransactionState.values()) {
                if (transactionState.value != value) continue;
                return transactionState;
            }
            throw new IllegalArgumentException("Illegal value provided for TransactionState.");
        }

        static {
            COMMITED = COMMITTED;
        }
    }
}

