/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.rocksdb.AbstractCompactionFilter;
import org.rocksdb.AbstractCompactionFilterFactory;
import org.rocksdb.AbstractComparator;
import org.rocksdb.AbstractEventListener;
import org.rocksdb.AbstractSlice;
import org.rocksdb.AbstractWalFilter;
import org.rocksdb.AccessHint;
import org.rocksdb.BuiltinComparator;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.ColumnFamilyOptionsInterface;
import org.rocksdb.CompactionOptionsFIFO;
import org.rocksdb.CompactionOptionsUniversal;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.ConcurrentTaskLimiter;
import org.rocksdb.DBOptions;
import org.rocksdb.DBOptionsInterface;
import org.rocksdb.DbPath;
import org.rocksdb.Env;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Logger;
import org.rocksdb.MemTableConfig;
import org.rocksdb.MergeOperator;
import org.rocksdb.MutableColumnFamilyOptionsInterface;
import org.rocksdb.MutableDBOptionsInterface;
import org.rocksdb.RateLimiter;
import org.rocksdb.RocksCallbackObject;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksObject;
import org.rocksdb.SstFileManager;
import org.rocksdb.SstPartitionerFactory;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WALRecoveryMode;
import org.rocksdb.WalFilter;
import org.rocksdb.WriteBufferManager;

public class Options
extends RocksObject
implements DBOptionsInterface<Options>,
MutableDBOptionsInterface<Options>,
ColumnFamilyOptionsInterface<Options>,
MutableColumnFamilyOptionsInterface<Options> {
    private Env env_;
    private MemTableConfig memTableConfig_;
    private TableFormatConfig tableFormatConfig_;
    private RateLimiter rateLimiter_;
    private AbstractComparator comparator_;
    private AbstractCompactionFilter<? extends AbstractSlice<?>> compactionFilter_;
    private AbstractCompactionFilterFactory<? extends AbstractCompactionFilter<?>> compactionFilterFactory_;
    private CompactionOptionsUniversal compactionOptionsUniversal_;
    private CompactionOptionsFIFO compactionOptionsFIFO_;
    private CompressionOptions bottommostCompressionOptions_;
    private CompressionOptions compressionOptions_;
    private Cache rowCache_;
    private WalFilter walFilter_;
    private WriteBufferManager writeBufferManager_;
    private SstPartitionerFactory sstPartitionerFactory_;
    private ConcurrentTaskLimiter compactionThreadLimiter_;

    public static String getOptionStringFromProps(Properties properties) {
        if (properties == null || properties.size() == 0) {
            throw new IllegalArgumentException("Properties value must contain at least one value.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String name : properties.stringPropertyNames()) {
            stringBuilder.append(name);
            stringBuilder.append("=");
            stringBuilder.append(properties.getProperty(name));
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    public Options() {
        super(Options.newOptions());
        this.env_ = Env.getDefault();
    }

    public Options(DBOptions dbOptions, ColumnFamilyOptions columnFamilyOptions) {
        super(Options.newOptions(dbOptions.nativeHandle_, columnFamilyOptions.nativeHandle_));
        this.env_ = Env.getDefault();
    }

    public Options(Options other) {
        super(Options.copyOptions(other.nativeHandle_));
        this.env_ = other.env_;
        this.memTableConfig_ = other.memTableConfig_;
        this.tableFormatConfig_ = other.tableFormatConfig_;
        this.rateLimiter_ = other.rateLimiter_;
        this.comparator_ = other.comparator_;
        this.compactionFilter_ = other.compactionFilter_;
        this.compactionFilterFactory_ = other.compactionFilterFactory_;
        this.compactionOptionsUniversal_ = other.compactionOptionsUniversal_;
        this.compactionOptionsFIFO_ = other.compactionOptionsFIFO_;
        this.compressionOptions_ = other.compressionOptions_;
        this.rowCache_ = other.rowCache_;
        this.writeBufferManager_ = other.writeBufferManager_;
        this.compactionThreadLimiter_ = other.compactionThreadLimiter_;
        this.bottommostCompressionOptions_ = other.bottommostCompressionOptions_;
        this.walFilter_ = other.walFilter_;
        this.sstPartitionerFactory_ = other.sstPartitionerFactory_;
    }

    @Override
    public Options setIncreaseParallelism(int totalThreads) {
        assert (this.isOwningHandle());
        this.setIncreaseParallelism(this.nativeHandle_, totalThreads);
        return this;
    }

    @Override
    public Options setCreateIfMissing(boolean flag) {
        assert (this.isOwningHandle());
        this.setCreateIfMissing(this.nativeHandle_, flag);
        return this;
    }

    @Override
    public Options setCreateMissingColumnFamilies(boolean flag) {
        assert (this.isOwningHandle());
        this.setCreateMissingColumnFamilies(this.nativeHandle_, flag);
        return this;
    }

    @Override
    public Options setEnv(Env env) {
        assert (this.isOwningHandle());
        this.setEnv(this.nativeHandle_, env.nativeHandle_);
        this.env_ = env;
        return this;
    }

    @Override
    public Env getEnv() {
        return this.env_;
    }

    public Options prepareForBulkLoad() {
        this.prepareForBulkLoad(this.nativeHandle_);
        return this;
    }

    @Override
    public boolean createIfMissing() {
        assert (this.isOwningHandle());
        return this.createIfMissing(this.nativeHandle_);
    }

    @Override
    public boolean createMissingColumnFamilies() {
        assert (this.isOwningHandle());
        return this.createMissingColumnFamilies(this.nativeHandle_);
    }

    @Override
    public Options oldDefaults(int majorVersion, int minorVersion) {
        Options.oldDefaults(this.nativeHandle_, majorVersion, minorVersion);
        return this;
    }

    @Override
    public Options optimizeForSmallDb() {
        this.optimizeForSmallDb(this.nativeHandle_);
        return this;
    }

    @Override
    public Options optimizeForSmallDb(Cache cache) {
        Options.optimizeForSmallDb(this.nativeHandle_, cache.getNativeHandle());
        return this;
    }

    @Override
    public Options optimizeForPointLookup(long blockCacheSizeMb) {
        this.optimizeForPointLookup(this.nativeHandle_, blockCacheSizeMb);
        return this;
    }

    @Override
    public Options optimizeLevelStyleCompaction() {
        this.optimizeLevelStyleCompaction(this.nativeHandle_, 0x20000000L);
        return this;
    }

    @Override
    public Options optimizeLevelStyleCompaction(long memtableMemoryBudget) {
        this.optimizeLevelStyleCompaction(this.nativeHandle_, memtableMemoryBudget);
        return this;
    }

    @Override
    public Options optimizeUniversalStyleCompaction() {
        this.optimizeUniversalStyleCompaction(this.nativeHandle_, 0x20000000L);
        return this;
    }

    @Override
    public Options optimizeUniversalStyleCompaction(long memtableMemoryBudget) {
        this.optimizeUniversalStyleCompaction(this.nativeHandle_, memtableMemoryBudget);
        return this;
    }

    @Override
    public Options setComparator(BuiltinComparator builtinComparator) {
        assert (this.isOwningHandle());
        this.setComparatorHandle(this.nativeHandle_, builtinComparator.ordinal());
        return this;
    }

    @Override
    public Options setComparator(AbstractComparator comparator) {
        assert (this.isOwningHandle());
        this.setComparatorHandle(this.nativeHandle_, comparator.nativeHandle_, comparator.getComparatorType().getValue());
        this.comparator_ = comparator;
        return this;
    }

    @Override
    public Options setMergeOperatorName(String name) {
        assert (this.isOwningHandle());
        if (name == null) {
            throw new IllegalArgumentException("Merge operator name must not be null.");
        }
        this.setMergeOperatorName(this.nativeHandle_, name);
        return this;
    }

    @Override
    public Options setMergeOperator(MergeOperator mergeOperator) {
        this.setMergeOperator(this.nativeHandle_, mergeOperator.nativeHandle_);
        return this;
    }

    @Override
    public Options setCompactionFilter(AbstractCompactionFilter<? extends AbstractSlice<?>> compactionFilter) {
        this.setCompactionFilterHandle(this.nativeHandle_, compactionFilter.nativeHandle_);
        this.compactionFilter_ = compactionFilter;
        return this;
    }

    @Override
    public AbstractCompactionFilter<? extends AbstractSlice<?>> compactionFilter() {
        assert (this.isOwningHandle());
        return this.compactionFilter_;
    }

    @Override
    public Options setCompactionFilterFactory(AbstractCompactionFilterFactory<? extends AbstractCompactionFilter<?>> compactionFilterFactory) {
        assert (this.isOwningHandle());
        this.setCompactionFilterFactoryHandle(this.nativeHandle_, compactionFilterFactory.nativeHandle_);
        this.compactionFilterFactory_ = compactionFilterFactory;
        return this;
    }

    @Override
    public AbstractCompactionFilterFactory<? extends AbstractCompactionFilter<?>> compactionFilterFactory() {
        assert (this.isOwningHandle());
        return this.compactionFilterFactory_;
    }

    @Override
    public Options setWriteBufferSize(long writeBufferSize) {
        assert (this.isOwningHandle());
        this.setWriteBufferSize(this.nativeHandle_, writeBufferSize);
        return this;
    }

    @Override
    public long writeBufferSize() {
        assert (this.isOwningHandle());
        return this.writeBufferSize(this.nativeHandle_);
    }

    @Override
    public Options setMaxWriteBufferNumber(int maxWriteBufferNumber) {
        assert (this.isOwningHandle());
        this.setMaxWriteBufferNumber(this.nativeHandle_, maxWriteBufferNumber);
        return this;
    }

    @Override
    public int maxWriteBufferNumber() {
        assert (this.isOwningHandle());
        return this.maxWriteBufferNumber(this.nativeHandle_);
    }

    @Override
    public boolean errorIfExists() {
        assert (this.isOwningHandle());
        return this.errorIfExists(this.nativeHandle_);
    }

    @Override
    public Options setErrorIfExists(boolean errorIfExists) {
        assert (this.isOwningHandle());
        this.setErrorIfExists(this.nativeHandle_, errorIfExists);
        return this;
    }

    @Override
    public boolean paranoidChecks() {
        assert (this.isOwningHandle());
        return this.paranoidChecks(this.nativeHandle_);
    }

    @Override
    public Options setParanoidChecks(boolean paranoidChecks) {
        assert (this.isOwningHandle());
        this.setParanoidChecks(this.nativeHandle_, paranoidChecks);
        return this;
    }

    @Override
    public int maxOpenFiles() {
        assert (this.isOwningHandle());
        return this.maxOpenFiles(this.nativeHandle_);
    }

    @Override
    public Options setMaxFileOpeningThreads(int maxFileOpeningThreads) {
        assert (this.isOwningHandle());
        this.setMaxFileOpeningThreads(this.nativeHandle_, maxFileOpeningThreads);
        return this;
    }

    @Override
    public int maxFileOpeningThreads() {
        assert (this.isOwningHandle());
        return this.maxFileOpeningThreads(this.nativeHandle_);
    }

    @Override
    public Options setMaxTotalWalSize(long maxTotalWalSize) {
        assert (this.isOwningHandle());
        this.setMaxTotalWalSize(this.nativeHandle_, maxTotalWalSize);
        return this;
    }

    @Override
    public long maxTotalWalSize() {
        assert (this.isOwningHandle());
        return this.maxTotalWalSize(this.nativeHandle_);
    }

    @Override
    public Options setMaxOpenFiles(int maxOpenFiles) {
        assert (this.isOwningHandle());
        this.setMaxOpenFiles(this.nativeHandle_, maxOpenFiles);
        return this;
    }

    @Override
    public boolean useFsync() {
        assert (this.isOwningHandle());
        return this.useFsync(this.nativeHandle_);
    }

    @Override
    public Options setUseFsync(boolean useFsync) {
        assert (this.isOwningHandle());
        this.setUseFsync(this.nativeHandle_, useFsync);
        return this;
    }

    @Override
    public Options setDbPaths(Collection<DbPath> dbPaths) {
        assert (this.isOwningHandle());
        int len = dbPaths.size();
        String[] paths = new String[len];
        long[] targetSizes = new long[len];
        int i = 0;
        for (DbPath dbPath : dbPaths) {
            paths[i] = dbPath.path.toString();
            targetSizes[i] = dbPath.targetSize;
            ++i;
        }
        this.setDbPaths(this.nativeHandle_, paths, targetSizes);
        return this;
    }

    @Override
    public List<DbPath> dbPaths() {
        int len = (int)this.dbPathsLen(this.nativeHandle_);
        if (len == 0) {
            return Collections.emptyList();
        }
        String[] paths = new String[len];
        long[] targetSizes = new long[len];
        this.dbPaths(this.nativeHandle_, paths, targetSizes);
        ArrayList<DbPath> dbPaths = new ArrayList<DbPath>();
        for (int i = 0; i < len; ++i) {
            dbPaths.add(new DbPath(Paths.get(paths[i], new String[0]), targetSizes[i]));
        }
        return dbPaths;
    }

    @Override
    public String dbLogDir() {
        assert (this.isOwningHandle());
        return this.dbLogDir(this.nativeHandle_);
    }

    @Override
    public Options setDbLogDir(String dbLogDir) {
        assert (this.isOwningHandle());
        this.setDbLogDir(this.nativeHandle_, dbLogDir);
        return this;
    }

    @Override
    public String walDir() {
        assert (this.isOwningHandle());
        return this.walDir(this.nativeHandle_);
    }

    @Override
    public Options setWalDir(String walDir) {
        assert (this.isOwningHandle());
        this.setWalDir(this.nativeHandle_, walDir);
        return this;
    }

    @Override
    public long deleteObsoleteFilesPeriodMicros() {
        assert (this.isOwningHandle());
        return this.deleteObsoleteFilesPeriodMicros(this.nativeHandle_);
    }

    @Override
    public Options setDeleteObsoleteFilesPeriodMicros(long micros) {
        assert (this.isOwningHandle());
        this.setDeleteObsoleteFilesPeriodMicros(this.nativeHandle_, micros);
        return this;
    }

    @Override
    @Deprecated
    public int maxBackgroundCompactions() {
        assert (this.isOwningHandle());
        return this.maxBackgroundCompactions(this.nativeHandle_);
    }

    @Override
    public Options setStatistics(Statistics statistics) {
        assert (this.isOwningHandle());
        this.setStatistics(this.nativeHandle_, statistics.nativeHandle_);
        return this;
    }

    @Override
    public Statistics statistics() {
        assert (this.isOwningHandle());
        long statisticsNativeHandle = this.statistics(this.nativeHandle_);
        if (statisticsNativeHandle == 0L) {
            return null;
        }
        return new Statistics(statisticsNativeHandle);
    }

    @Override
    @Deprecated
    public Options setMaxBackgroundCompactions(int maxBackgroundCompactions) {
        assert (this.isOwningHandle());
        this.setMaxBackgroundCompactions(this.nativeHandle_, maxBackgroundCompactions);
        return this;
    }

    @Override
    public Options setMaxSubcompactions(int maxSubcompactions) {
        assert (this.isOwningHandle());
        this.setMaxSubcompactions(this.nativeHandle_, maxSubcompactions);
        return this;
    }

    @Override
    public int maxSubcompactions() {
        assert (this.isOwningHandle());
        return this.maxSubcompactions(this.nativeHandle_);
    }

    @Override
    @Deprecated
    public int maxBackgroundFlushes() {
        assert (this.isOwningHandle());
        return this.maxBackgroundFlushes(this.nativeHandle_);
    }

    @Override
    @Deprecated
    public Options setMaxBackgroundFlushes(int maxBackgroundFlushes) {
        assert (this.isOwningHandle());
        this.setMaxBackgroundFlushes(this.nativeHandle_, maxBackgroundFlushes);
        return this;
    }

    @Override
    public int maxBackgroundJobs() {
        assert (this.isOwningHandle());
        return this.maxBackgroundJobs(this.nativeHandle_);
    }

    @Override
    public Options setMaxBackgroundJobs(int maxBackgroundJobs) {
        assert (this.isOwningHandle());
        this.setMaxBackgroundJobs(this.nativeHandle_, maxBackgroundJobs);
        return this;
    }

    @Override
    public long maxLogFileSize() {
        assert (this.isOwningHandle());
        return this.maxLogFileSize(this.nativeHandle_);
    }

    @Override
    public Options setMaxLogFileSize(long maxLogFileSize) {
        assert (this.isOwningHandle());
        this.setMaxLogFileSize(this.nativeHandle_, maxLogFileSize);
        return this;
    }

    @Override
    public long logFileTimeToRoll() {
        assert (this.isOwningHandle());
        return this.logFileTimeToRoll(this.nativeHandle_);
    }

    @Override
    public Options setLogFileTimeToRoll(long logFileTimeToRoll) {
        assert (this.isOwningHandle());
        this.setLogFileTimeToRoll(this.nativeHandle_, logFileTimeToRoll);
        return this;
    }

    @Override
    public long keepLogFileNum() {
        assert (this.isOwningHandle());
        return this.keepLogFileNum(this.nativeHandle_);
    }

    @Override
    public Options setKeepLogFileNum(long keepLogFileNum) {
        assert (this.isOwningHandle());
        this.setKeepLogFileNum(this.nativeHandle_, keepLogFileNum);
        return this;
    }

    @Override
    public Options setRecycleLogFileNum(long recycleLogFileNum) {
        assert (this.isOwningHandle());
        this.setRecycleLogFileNum(this.nativeHandle_, recycleLogFileNum);
        return this;
    }

    @Override
    public long recycleLogFileNum() {
        assert (this.isOwningHandle());
        return this.recycleLogFileNum(this.nativeHandle_);
    }

    @Override
    public long maxManifestFileSize() {
        assert (this.isOwningHandle());
        return this.maxManifestFileSize(this.nativeHandle_);
    }

    @Override
    public Options setMaxManifestFileSize(long maxManifestFileSize) {
        assert (this.isOwningHandle());
        this.setMaxManifestFileSize(this.nativeHandle_, maxManifestFileSize);
        return this;
    }

    @Override
    public Options setMaxTableFilesSizeFIFO(long maxTableFilesSize) {
        assert (maxTableFilesSize > 0L);
        assert (this.isOwningHandle());
        this.setMaxTableFilesSizeFIFO(this.nativeHandle_, maxTableFilesSize);
        return this;
    }

    @Override
    public long maxTableFilesSizeFIFO() {
        return this.maxTableFilesSizeFIFO(this.nativeHandle_);
    }

    @Override
    public int tableCacheNumshardbits() {
        assert (this.isOwningHandle());
        return this.tableCacheNumshardbits(this.nativeHandle_);
    }

    @Override
    public Options setTableCacheNumshardbits(int tableCacheNumshardbits) {
        assert (this.isOwningHandle());
        this.setTableCacheNumshardbits(this.nativeHandle_, tableCacheNumshardbits);
        return this;
    }

    @Override
    public long walTtlSeconds() {
        assert (this.isOwningHandle());
        return this.walTtlSeconds(this.nativeHandle_);
    }

    @Override
    public Options setWalTtlSeconds(long walTtlSeconds) {
        assert (this.isOwningHandle());
        this.setWalTtlSeconds(this.nativeHandle_, walTtlSeconds);
        return this;
    }

    @Override
    public long walSizeLimitMB() {
        assert (this.isOwningHandle());
        return this.walSizeLimitMB(this.nativeHandle_);
    }

    @Override
    public Options setMaxWriteBatchGroupSizeBytes(long maxWriteBatchGroupSizeBytes) {
        Options.setMaxWriteBatchGroupSizeBytes(this.nativeHandle_, maxWriteBatchGroupSizeBytes);
        return this;
    }

    @Override
    public long maxWriteBatchGroupSizeBytes() {
        assert (this.isOwningHandle());
        return Options.maxWriteBatchGroupSizeBytes(this.nativeHandle_);
    }

    @Override
    public Options setWalSizeLimitMB(long sizeLimitMB) {
        assert (this.isOwningHandle());
        this.setWalSizeLimitMB(this.nativeHandle_, sizeLimitMB);
        return this;
    }

    @Override
    public long manifestPreallocationSize() {
        assert (this.isOwningHandle());
        return this.manifestPreallocationSize(this.nativeHandle_);
    }

    @Override
    public Options setManifestPreallocationSize(long size) {
        assert (this.isOwningHandle());
        this.setManifestPreallocationSize(this.nativeHandle_, size);
        return this;
    }

    @Override
    public Options setUseDirectReads(boolean useDirectReads) {
        assert (this.isOwningHandle());
        this.setUseDirectReads(this.nativeHandle_, useDirectReads);
        return this;
    }

    @Override
    public boolean useDirectReads() {
        assert (this.isOwningHandle());
        return this.useDirectReads(this.nativeHandle_);
    }

    @Override
    public Options setUseDirectIoForFlushAndCompaction(boolean useDirectIoForFlushAndCompaction) {
        assert (this.isOwningHandle());
        this.setUseDirectIoForFlushAndCompaction(this.nativeHandle_, useDirectIoForFlushAndCompaction);
        return this;
    }

    @Override
    public boolean useDirectIoForFlushAndCompaction() {
        assert (this.isOwningHandle());
        return this.useDirectIoForFlushAndCompaction(this.nativeHandle_);
    }

    @Override
    public Options setAllowFAllocate(boolean allowFAllocate) {
        assert (this.isOwningHandle());
        this.setAllowFAllocate(this.nativeHandle_, allowFAllocate);
        return this;
    }

    @Override
    public boolean allowFAllocate() {
        assert (this.isOwningHandle());
        return this.allowFAllocate(this.nativeHandle_);
    }

    @Override
    public boolean allowMmapReads() {
        assert (this.isOwningHandle());
        return this.allowMmapReads(this.nativeHandle_);
    }

    @Override
    public Options setAllowMmapReads(boolean allowMmapReads) {
        assert (this.isOwningHandle());
        this.setAllowMmapReads(this.nativeHandle_, allowMmapReads);
        return this;
    }

    @Override
    public boolean allowMmapWrites() {
        assert (this.isOwningHandle());
        return this.allowMmapWrites(this.nativeHandle_);
    }

    @Override
    public Options setAllowMmapWrites(boolean allowMmapWrites) {
        assert (this.isOwningHandle());
        this.setAllowMmapWrites(this.nativeHandle_, allowMmapWrites);
        return this;
    }

    @Override
    public boolean isFdCloseOnExec() {
        assert (this.isOwningHandle());
        return this.isFdCloseOnExec(this.nativeHandle_);
    }

    @Override
    public Options setIsFdCloseOnExec(boolean isFdCloseOnExec) {
        assert (this.isOwningHandle());
        this.setIsFdCloseOnExec(this.nativeHandle_, isFdCloseOnExec);
        return this;
    }

    @Override
    public int statsDumpPeriodSec() {
        assert (this.isOwningHandle());
        return this.statsDumpPeriodSec(this.nativeHandle_);
    }

    @Override
    public Options setStatsDumpPeriodSec(int statsDumpPeriodSec) {
        assert (this.isOwningHandle());
        this.setStatsDumpPeriodSec(this.nativeHandle_, statsDumpPeriodSec);
        return this;
    }

    @Override
    public Options setStatsPersistPeriodSec(int statsPersistPeriodSec) {
        assert (this.isOwningHandle());
        this.setStatsPersistPeriodSec(this.nativeHandle_, statsPersistPeriodSec);
        return this;
    }

    @Override
    public int statsPersistPeriodSec() {
        assert (this.isOwningHandle());
        return this.statsPersistPeriodSec(this.nativeHandle_);
    }

    @Override
    public Options setStatsHistoryBufferSize(long statsHistoryBufferSize) {
        assert (this.isOwningHandle());
        this.setStatsHistoryBufferSize(this.nativeHandle_, statsHistoryBufferSize);
        return this;
    }

    @Override
    public long statsHistoryBufferSize() {
        assert (this.isOwningHandle());
        return this.statsHistoryBufferSize(this.nativeHandle_);
    }

    @Override
    public boolean adviseRandomOnOpen() {
        return this.adviseRandomOnOpen(this.nativeHandle_);
    }

    @Override
    public Options setAdviseRandomOnOpen(boolean adviseRandomOnOpen) {
        assert (this.isOwningHandle());
        this.setAdviseRandomOnOpen(this.nativeHandle_, adviseRandomOnOpen);
        return this;
    }

    @Override
    public Options setDbWriteBufferSize(long dbWriteBufferSize) {
        assert (this.isOwningHandle());
        this.setDbWriteBufferSize(this.nativeHandle_, dbWriteBufferSize);
        return this;
    }

    @Override
    public Options setWriteBufferManager(WriteBufferManager writeBufferManager) {
        assert (this.isOwningHandle());
        this.setWriteBufferManager(this.nativeHandle_, writeBufferManager.nativeHandle_);
        this.writeBufferManager_ = writeBufferManager;
        return this;
    }

    @Override
    public WriteBufferManager writeBufferManager() {
        assert (this.isOwningHandle());
        return this.writeBufferManager_;
    }

    @Override
    public long dbWriteBufferSize() {
        assert (this.isOwningHandle());
        return this.dbWriteBufferSize(this.nativeHandle_);
    }

    @Override
    public Options setAccessHintOnCompactionStart(AccessHint accessHint) {
        assert (this.isOwningHandle());
        this.setAccessHintOnCompactionStart(this.nativeHandle_, accessHint.getValue());
        return this;
    }

    @Override
    public AccessHint accessHintOnCompactionStart() {
        assert (this.isOwningHandle());
        return AccessHint.getAccessHint(this.accessHintOnCompactionStart(this.nativeHandle_));
    }

    @Override
    public Options setCompactionReadaheadSize(long compactionReadaheadSize) {
        assert (this.isOwningHandle());
        this.setCompactionReadaheadSize(this.nativeHandle_, compactionReadaheadSize);
        return this;
    }

    @Override
    public long compactionReadaheadSize() {
        assert (this.isOwningHandle());
        return this.compactionReadaheadSize(this.nativeHandle_);
    }

    @Override
    public Options setRandomAccessMaxBufferSize(long randomAccessMaxBufferSize) {
        assert (this.isOwningHandle());
        this.setRandomAccessMaxBufferSize(this.nativeHandle_, randomAccessMaxBufferSize);
        return this;
    }

    @Override
    public long randomAccessMaxBufferSize() {
        assert (this.isOwningHandle());
        return this.randomAccessMaxBufferSize(this.nativeHandle_);
    }

    @Override
    public Options setWritableFileMaxBufferSize(long writableFileMaxBufferSize) {
        assert (this.isOwningHandle());
        this.setWritableFileMaxBufferSize(this.nativeHandle_, writableFileMaxBufferSize);
        return this;
    }

    @Override
    public long writableFileMaxBufferSize() {
        assert (this.isOwningHandle());
        return this.writableFileMaxBufferSize(this.nativeHandle_);
    }

    @Override
    public boolean useAdaptiveMutex() {
        assert (this.isOwningHandle());
        return this.useAdaptiveMutex(this.nativeHandle_);
    }

    @Override
    public Options setUseAdaptiveMutex(boolean useAdaptiveMutex) {
        assert (this.isOwningHandle());
        this.setUseAdaptiveMutex(this.nativeHandle_, useAdaptiveMutex);
        return this;
    }

    @Override
    public long bytesPerSync() {
        return this.bytesPerSync(this.nativeHandle_);
    }

    @Override
    public Options setBytesPerSync(long bytesPerSync) {
        assert (this.isOwningHandle());
        this.setBytesPerSync(this.nativeHandle_, bytesPerSync);
        return this;
    }

    @Override
    public Options setWalBytesPerSync(long walBytesPerSync) {
        assert (this.isOwningHandle());
        this.setWalBytesPerSync(this.nativeHandle_, walBytesPerSync);
        return this;
    }

    @Override
    public long walBytesPerSync() {
        assert (this.isOwningHandle());
        return this.walBytesPerSync(this.nativeHandle_);
    }

    @Override
    public Options setStrictBytesPerSync(boolean strictBytesPerSync) {
        assert (this.isOwningHandle());
        this.setStrictBytesPerSync(this.nativeHandle_, strictBytesPerSync);
        return this;
    }

    @Override
    public boolean strictBytesPerSync() {
        assert (this.isOwningHandle());
        return this.strictBytesPerSync(this.nativeHandle_);
    }

    @Override
    public Options setListeners(List<AbstractEventListener> listeners) {
        assert (this.isOwningHandle());
        Options.setEventListeners(this.nativeHandle_, RocksCallbackObject.toNativeHandleList(listeners));
        return this;
    }

    @Override
    public List<AbstractEventListener> listeners() {
        assert (this.isOwningHandle());
        return Arrays.asList(Options.eventListeners(this.nativeHandle_));
    }

    @Override
    public Options setEnableThreadTracking(boolean enableThreadTracking) {
        assert (this.isOwningHandle());
        this.setEnableThreadTracking(this.nativeHandle_, enableThreadTracking);
        return this;
    }

    @Override
    public boolean enableThreadTracking() {
        assert (this.isOwningHandle());
        return this.enableThreadTracking(this.nativeHandle_);
    }

    @Override
    public Options setDelayedWriteRate(long delayedWriteRate) {
        assert (this.isOwningHandle());
        this.setDelayedWriteRate(this.nativeHandle_, delayedWriteRate);
        return this;
    }

    @Override
    public long delayedWriteRate() {
        return this.delayedWriteRate(this.nativeHandle_);
    }

    @Override
    public Options setEnablePipelinedWrite(boolean enablePipelinedWrite) {
        this.setEnablePipelinedWrite(this.nativeHandle_, enablePipelinedWrite);
        return this;
    }

    @Override
    public boolean enablePipelinedWrite() {
        return this.enablePipelinedWrite(this.nativeHandle_);
    }

    @Override
    public Options setUnorderedWrite(boolean unorderedWrite) {
        this.setUnorderedWrite(this.nativeHandle_, unorderedWrite);
        return this;
    }

    @Override
    public boolean unorderedWrite() {
        return this.unorderedWrite(this.nativeHandle_);
    }

    @Override
    public Options setAllowConcurrentMemtableWrite(boolean allowConcurrentMemtableWrite) {
        this.setAllowConcurrentMemtableWrite(this.nativeHandle_, allowConcurrentMemtableWrite);
        return this;
    }

    @Override
    public boolean allowConcurrentMemtableWrite() {
        return this.allowConcurrentMemtableWrite(this.nativeHandle_);
    }

    @Override
    public Options setEnableWriteThreadAdaptiveYield(boolean enableWriteThreadAdaptiveYield) {
        this.setEnableWriteThreadAdaptiveYield(this.nativeHandle_, enableWriteThreadAdaptiveYield);
        return this;
    }

    @Override
    public boolean enableWriteThreadAdaptiveYield() {
        return this.enableWriteThreadAdaptiveYield(this.nativeHandle_);
    }

    @Override
    public Options setWriteThreadMaxYieldUsec(long writeThreadMaxYieldUsec) {
        this.setWriteThreadMaxYieldUsec(this.nativeHandle_, writeThreadMaxYieldUsec);
        return this;
    }

    @Override
    public long writeThreadMaxYieldUsec() {
        return this.writeThreadMaxYieldUsec(this.nativeHandle_);
    }

    @Override
    public Options setWriteThreadSlowYieldUsec(long writeThreadSlowYieldUsec) {
        this.setWriteThreadSlowYieldUsec(this.nativeHandle_, writeThreadSlowYieldUsec);
        return this;
    }

    @Override
    public long writeThreadSlowYieldUsec() {
        return this.writeThreadSlowYieldUsec(this.nativeHandle_);
    }

    @Override
    public Options setSkipStatsUpdateOnDbOpen(boolean skipStatsUpdateOnDbOpen) {
        assert (this.isOwningHandle());
        this.setSkipStatsUpdateOnDbOpen(this.nativeHandle_, skipStatsUpdateOnDbOpen);
        return this;
    }

    @Override
    public boolean skipStatsUpdateOnDbOpen() {
        assert (this.isOwningHandle());
        return this.skipStatsUpdateOnDbOpen(this.nativeHandle_);
    }

    @Override
    public Options setSkipCheckingSstFileSizesOnDbOpen(boolean skipCheckingSstFileSizesOnDbOpen) {
        Options.setSkipCheckingSstFileSizesOnDbOpen(this.nativeHandle_, skipCheckingSstFileSizesOnDbOpen);
        return this;
    }

    @Override
    public boolean skipCheckingSstFileSizesOnDbOpen() {
        assert (this.isOwningHandle());
        return Options.skipCheckingSstFileSizesOnDbOpen(this.nativeHandle_);
    }

    @Override
    public Options setWalRecoveryMode(WALRecoveryMode walRecoveryMode) {
        assert (this.isOwningHandle());
        this.setWalRecoveryMode(this.nativeHandle_, walRecoveryMode.getValue());
        return this;
    }

    @Override
    public WALRecoveryMode walRecoveryMode() {
        assert (this.isOwningHandle());
        return WALRecoveryMode.getWALRecoveryMode(this.walRecoveryMode(this.nativeHandle_));
    }

    @Override
    public Options setAllow2pc(boolean allow2pc) {
        assert (this.isOwningHandle());
        this.setAllow2pc(this.nativeHandle_, allow2pc);
        return this;
    }

    @Override
    public boolean allow2pc() {
        assert (this.isOwningHandle());
        return this.allow2pc(this.nativeHandle_);
    }

    @Override
    public Options setRowCache(Cache rowCache) {
        assert (this.isOwningHandle());
        this.setRowCache(this.nativeHandle_, rowCache.nativeHandle_);
        this.rowCache_ = rowCache;
        return this;
    }

    @Override
    public Cache rowCache() {
        assert (this.isOwningHandle());
        return this.rowCache_;
    }

    @Override
    public Options setWalFilter(AbstractWalFilter walFilter) {
        assert (this.isOwningHandle());
        this.setWalFilter(this.nativeHandle_, walFilter.nativeHandle_);
        this.walFilter_ = walFilter;
        return this;
    }

    @Override
    public WalFilter walFilter() {
        assert (this.isOwningHandle());
        return this.walFilter_;
    }

    @Override
    public Options setFailIfOptionsFileError(boolean failIfOptionsFileError) {
        assert (this.isOwningHandle());
        this.setFailIfOptionsFileError(this.nativeHandle_, failIfOptionsFileError);
        return this;
    }

    @Override
    public boolean failIfOptionsFileError() {
        assert (this.isOwningHandle());
        return this.failIfOptionsFileError(this.nativeHandle_);
    }

    @Override
    public Options setDumpMallocStats(boolean dumpMallocStats) {
        assert (this.isOwningHandle());
        this.setDumpMallocStats(this.nativeHandle_, dumpMallocStats);
        return this;
    }

    @Override
    public boolean dumpMallocStats() {
        assert (this.isOwningHandle());
        return this.dumpMallocStats(this.nativeHandle_);
    }

    @Override
    public Options setAvoidFlushDuringRecovery(boolean avoidFlushDuringRecovery) {
        assert (this.isOwningHandle());
        this.setAvoidFlushDuringRecovery(this.nativeHandle_, avoidFlushDuringRecovery);
        return this;
    }

    @Override
    public boolean avoidFlushDuringRecovery() {
        assert (this.isOwningHandle());
        return this.avoidFlushDuringRecovery(this.nativeHandle_);
    }

    @Override
    public Options setAvoidFlushDuringShutdown(boolean avoidFlushDuringShutdown) {
        assert (this.isOwningHandle());
        this.setAvoidFlushDuringShutdown(this.nativeHandle_, avoidFlushDuringShutdown);
        return this;
    }

    @Override
    public boolean avoidFlushDuringShutdown() {
        assert (this.isOwningHandle());
        return this.avoidFlushDuringShutdown(this.nativeHandle_);
    }

    @Override
    public Options setAllowIngestBehind(boolean allowIngestBehind) {
        assert (this.isOwningHandle());
        this.setAllowIngestBehind(this.nativeHandle_, allowIngestBehind);
        return this;
    }

    @Override
    public boolean allowIngestBehind() {
        assert (this.isOwningHandle());
        return this.allowIngestBehind(this.nativeHandle_);
    }

    @Override
    public Options setTwoWriteQueues(boolean twoWriteQueues) {
        assert (this.isOwningHandle());
        this.setTwoWriteQueues(this.nativeHandle_, twoWriteQueues);
        return this;
    }

    @Override
    public boolean twoWriteQueues() {
        assert (this.isOwningHandle());
        return this.twoWriteQueues(this.nativeHandle_);
    }

    @Override
    public Options setManualWalFlush(boolean manualWalFlush) {
        assert (this.isOwningHandle());
        this.setManualWalFlush(this.nativeHandle_, manualWalFlush);
        return this;
    }

    @Override
    public boolean manualWalFlush() {
        assert (this.isOwningHandle());
        return this.manualWalFlush(this.nativeHandle_);
    }

    @Override
    public MemTableConfig memTableConfig() {
        return this.memTableConfig_;
    }

    @Override
    public Options setMemTableConfig(MemTableConfig config) {
        this.memTableConfig_ = config;
        this.setMemTableFactory(this.nativeHandle_, config.newMemTableFactoryHandle());
        return this;
    }

    @Override
    public Options setRateLimiter(RateLimiter rateLimiter) {
        assert (this.isOwningHandle());
        this.rateLimiter_ = rateLimiter;
        this.setRateLimiter(this.nativeHandle_, rateLimiter.nativeHandle_);
        return this;
    }

    @Override
    public Options setSstFileManager(SstFileManager sstFileManager) {
        assert (this.isOwningHandle());
        this.setSstFileManager(this.nativeHandle_, sstFileManager.nativeHandle_);
        return this;
    }

    @Override
    public Options setLogger(Logger logger) {
        assert (this.isOwningHandle());
        this.setLogger(this.nativeHandle_, logger.nativeHandle_);
        return this;
    }

    @Override
    public Options setInfoLogLevel(InfoLogLevel infoLogLevel) {
        assert (this.isOwningHandle());
        this.setInfoLogLevel(this.nativeHandle_, infoLogLevel.getValue());
        return this;
    }

    @Override
    public InfoLogLevel infoLogLevel() {
        assert (this.isOwningHandle());
        return InfoLogLevel.getInfoLogLevel(this.infoLogLevel(this.nativeHandle_));
    }

    @Override
    public String memTableFactoryName() {
        assert (this.isOwningHandle());
        return this.memTableFactoryName(this.nativeHandle_);
    }

    @Override
    public TableFormatConfig tableFormatConfig() {
        return this.tableFormatConfig_;
    }

    @Override
    public Options setTableFormatConfig(TableFormatConfig config) {
        this.tableFormatConfig_ = config;
        this.setTableFactory(this.nativeHandle_, config.newTableFactoryHandle());
        return this;
    }

    @Override
    public String tableFactoryName() {
        assert (this.isOwningHandle());
        return this.tableFactoryName(this.nativeHandle_);
    }

    @Override
    public Options setCfPaths(Collection<DbPath> cfPaths) {
        assert (this.isOwningHandle());
        int len = cfPaths.size();
        String[] paths = new String[len];
        long[] targetSizes = new long[len];
        int i = 0;
        for (DbPath dbPath : cfPaths) {
            paths[i] = dbPath.path.toString();
            targetSizes[i] = dbPath.targetSize;
            ++i;
        }
        Options.setCfPaths(this.nativeHandle_, paths, targetSizes);
        return this;
    }

    @Override
    public List<DbPath> cfPaths() {
        int len = (int)Options.cfPathsLen(this.nativeHandle_);
        if (len == 0) {
            return Collections.emptyList();
        }
        String[] paths = new String[len];
        long[] targetSizes = new long[len];
        Options.cfPaths(this.nativeHandle_, paths, targetSizes);
        ArrayList<DbPath> cfPaths = new ArrayList<DbPath>();
        for (int i = 0; i < len; ++i) {
            cfPaths.add(new DbPath(Paths.get(paths[i], new String[0]), targetSizes[i]));
        }
        return cfPaths;
    }

    @Override
    public Options useFixedLengthPrefixExtractor(int n) {
        assert (this.isOwningHandle());
        this.useFixedLengthPrefixExtractor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public Options useCappedPrefixExtractor(int n) {
        assert (this.isOwningHandle());
        this.useCappedPrefixExtractor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public CompressionType compressionType() {
        return CompressionType.getCompressionType(this.compressionType(this.nativeHandle_));
    }

    @Override
    public Options setCompressionPerLevel(List<CompressionType> compressionLevels) {
        byte[] byteCompressionTypes = new byte[compressionLevels.size()];
        for (int i = 0; i < compressionLevels.size(); ++i) {
            byteCompressionTypes[i] = compressionLevels.get(i).getValue();
        }
        this.setCompressionPerLevel(this.nativeHandle_, byteCompressionTypes);
        return this;
    }

    @Override
    public List<CompressionType> compressionPerLevel() {
        byte[] byteCompressionTypes = this.compressionPerLevel(this.nativeHandle_);
        ArrayList<CompressionType> compressionLevels = new ArrayList<CompressionType>();
        for (byte byteCompressionType : byteCompressionTypes) {
            compressionLevels.add(CompressionType.getCompressionType(byteCompressionType));
        }
        return compressionLevels;
    }

    @Override
    public Options setCompressionType(CompressionType compressionType) {
        this.setCompressionType(this.nativeHandle_, compressionType.getValue());
        return this;
    }

    @Override
    public Options setBottommostCompressionType(CompressionType bottommostCompressionType) {
        this.setBottommostCompressionType(this.nativeHandle_, bottommostCompressionType.getValue());
        return this;
    }

    @Override
    public CompressionType bottommostCompressionType() {
        return CompressionType.getCompressionType(this.bottommostCompressionType(this.nativeHandle_));
    }

    @Override
    public Options setBottommostCompressionOptions(CompressionOptions bottommostCompressionOptions) {
        this.setBottommostCompressionOptions(this.nativeHandle_, bottommostCompressionOptions.nativeHandle_);
        this.bottommostCompressionOptions_ = bottommostCompressionOptions;
        return this;
    }

    @Override
    public CompressionOptions bottommostCompressionOptions() {
        return this.bottommostCompressionOptions_;
    }

    @Override
    public Options setCompressionOptions(CompressionOptions compressionOptions) {
        this.setCompressionOptions(this.nativeHandle_, compressionOptions.nativeHandle_);
        this.compressionOptions_ = compressionOptions;
        return this;
    }

    @Override
    public CompressionOptions compressionOptions() {
        return this.compressionOptions_;
    }

    @Override
    public CompactionStyle compactionStyle() {
        return CompactionStyle.fromValue(this.compactionStyle(this.nativeHandle_));
    }

    public Options setCompactionStyle(CompactionStyle compactionStyle) {
        this.setCompactionStyle(this.nativeHandle_, compactionStyle.getValue());
        return this;
    }

    @Override
    public int numLevels() {
        return this.numLevels(this.nativeHandle_);
    }

    @Override
    public Options setNumLevels(int numLevels) {
        this.setNumLevels(this.nativeHandle_, numLevels);
        return this;
    }

    @Override
    public int levelZeroFileNumCompactionTrigger() {
        return this.levelZeroFileNumCompactionTrigger(this.nativeHandle_);
    }

    @Override
    public Options setLevelZeroFileNumCompactionTrigger(int numFiles) {
        this.setLevelZeroFileNumCompactionTrigger(this.nativeHandle_, numFiles);
        return this;
    }

    @Override
    public int levelZeroSlowdownWritesTrigger() {
        return this.levelZeroSlowdownWritesTrigger(this.nativeHandle_);
    }

    @Override
    public Options setLevelZeroSlowdownWritesTrigger(int numFiles) {
        this.setLevelZeroSlowdownWritesTrigger(this.nativeHandle_, numFiles);
        return this;
    }

    @Override
    public int levelZeroStopWritesTrigger() {
        return this.levelZeroStopWritesTrigger(this.nativeHandle_);
    }

    @Override
    public Options setLevelZeroStopWritesTrigger(int numFiles) {
        this.setLevelZeroStopWritesTrigger(this.nativeHandle_, numFiles);
        return this;
    }

    @Override
    public long targetFileSizeBase() {
        return this.targetFileSizeBase(this.nativeHandle_);
    }

    @Override
    public Options setTargetFileSizeBase(long targetFileSizeBase) {
        this.setTargetFileSizeBase(this.nativeHandle_, targetFileSizeBase);
        return this;
    }

    @Override
    public int targetFileSizeMultiplier() {
        return this.targetFileSizeMultiplier(this.nativeHandle_);
    }

    @Override
    public Options setTargetFileSizeMultiplier(int multiplier) {
        this.setTargetFileSizeMultiplier(this.nativeHandle_, multiplier);
        return this;
    }

    @Override
    public Options setMaxBytesForLevelBase(long maxBytesForLevelBase) {
        this.setMaxBytesForLevelBase(this.nativeHandle_, maxBytesForLevelBase);
        return this;
    }

    @Override
    public long maxBytesForLevelBase() {
        return this.maxBytesForLevelBase(this.nativeHandle_);
    }

    @Override
    public Options setLevelCompactionDynamicLevelBytes(boolean enableLevelCompactionDynamicLevelBytes) {
        this.setLevelCompactionDynamicLevelBytes(this.nativeHandle_, enableLevelCompactionDynamicLevelBytes);
        return this;
    }

    @Override
    public boolean levelCompactionDynamicLevelBytes() {
        return this.levelCompactionDynamicLevelBytes(this.nativeHandle_);
    }

    @Override
    public double maxBytesForLevelMultiplier() {
        return this.maxBytesForLevelMultiplier(this.nativeHandle_);
    }

    @Override
    public Options setMaxBytesForLevelMultiplier(double multiplier) {
        this.setMaxBytesForLevelMultiplier(this.nativeHandle_, multiplier);
        return this;
    }

    @Override
    public long maxCompactionBytes() {
        return this.maxCompactionBytes(this.nativeHandle_);
    }

    @Override
    public Options setMaxCompactionBytes(long maxCompactionBytes) {
        this.setMaxCompactionBytes(this.nativeHandle_, maxCompactionBytes);
        return this;
    }

    @Override
    public long arenaBlockSize() {
        return this.arenaBlockSize(this.nativeHandle_);
    }

    @Override
    public Options setArenaBlockSize(long arenaBlockSize) {
        this.setArenaBlockSize(this.nativeHandle_, arenaBlockSize);
        return this;
    }

    @Override
    public boolean disableAutoCompactions() {
        return this.disableAutoCompactions(this.nativeHandle_);
    }

    @Override
    public Options setDisableAutoCompactions(boolean disableAutoCompactions) {
        this.setDisableAutoCompactions(this.nativeHandle_, disableAutoCompactions);
        return this;
    }

    @Override
    public long maxSequentialSkipInIterations() {
        return this.maxSequentialSkipInIterations(this.nativeHandle_);
    }

    @Override
    public Options setMaxSequentialSkipInIterations(long maxSequentialSkipInIterations) {
        this.setMaxSequentialSkipInIterations(this.nativeHandle_, maxSequentialSkipInIterations);
        return this;
    }

    @Override
    public boolean inplaceUpdateSupport() {
        return this.inplaceUpdateSupport(this.nativeHandle_);
    }

    @Override
    public Options setInplaceUpdateSupport(boolean inplaceUpdateSupport) {
        this.setInplaceUpdateSupport(this.nativeHandle_, inplaceUpdateSupport);
        return this;
    }

    @Override
    public long inplaceUpdateNumLocks() {
        return this.inplaceUpdateNumLocks(this.nativeHandle_);
    }

    @Override
    public Options setInplaceUpdateNumLocks(long inplaceUpdateNumLocks) {
        this.setInplaceUpdateNumLocks(this.nativeHandle_, inplaceUpdateNumLocks);
        return this;
    }

    @Override
    public double memtablePrefixBloomSizeRatio() {
        return this.memtablePrefixBloomSizeRatio(this.nativeHandle_);
    }

    @Override
    public Options setMemtablePrefixBloomSizeRatio(double memtablePrefixBloomSizeRatio) {
        this.setMemtablePrefixBloomSizeRatio(this.nativeHandle_, memtablePrefixBloomSizeRatio);
        return this;
    }

    @Override
    public boolean memtableWholeKeyFiltering() {
        return this.memtableWholeKeyFiltering(this.nativeHandle_);
    }

    @Override
    public Options setMemtableWholeKeyFiltering(boolean memtableWholeKeyFiltering) {
        this.setMemtableWholeKeyFiltering(this.nativeHandle_, memtableWholeKeyFiltering);
        return this;
    }

    @Override
    public int bloomLocality() {
        return this.bloomLocality(this.nativeHandle_);
    }

    @Override
    public Options setBloomLocality(int bloomLocality) {
        this.setBloomLocality(this.nativeHandle_, bloomLocality);
        return this;
    }

    @Override
    public long maxSuccessiveMerges() {
        return this.maxSuccessiveMerges(this.nativeHandle_);
    }

    @Override
    public Options setMaxSuccessiveMerges(long maxSuccessiveMerges) {
        this.setMaxSuccessiveMerges(this.nativeHandle_, maxSuccessiveMerges);
        return this;
    }

    @Override
    public int minWriteBufferNumberToMerge() {
        return this.minWriteBufferNumberToMerge(this.nativeHandle_);
    }

    @Override
    public Options setMinWriteBufferNumberToMerge(int minWriteBufferNumberToMerge) {
        this.setMinWriteBufferNumberToMerge(this.nativeHandle_, minWriteBufferNumberToMerge);
        return this;
    }

    @Override
    public Options setOptimizeFiltersForHits(boolean optimizeFiltersForHits) {
        this.setOptimizeFiltersForHits(this.nativeHandle_, optimizeFiltersForHits);
        return this;
    }

    @Override
    public boolean optimizeFiltersForHits() {
        return this.optimizeFiltersForHits(this.nativeHandle_);
    }

    @Override
    public Options setMemtableHugePageSize(long memtableHugePageSize) {
        this.setMemtableHugePageSize(this.nativeHandle_, memtableHugePageSize);
        return this;
    }

    @Override
    public long memtableHugePageSize() {
        return this.memtableHugePageSize(this.nativeHandle_);
    }

    @Override
    public Options setSoftPendingCompactionBytesLimit(long softPendingCompactionBytesLimit) {
        this.setSoftPendingCompactionBytesLimit(this.nativeHandle_, softPendingCompactionBytesLimit);
        return this;
    }

    @Override
    public long softPendingCompactionBytesLimit() {
        return this.softPendingCompactionBytesLimit(this.nativeHandle_);
    }

    @Override
    public Options setHardPendingCompactionBytesLimit(long hardPendingCompactionBytesLimit) {
        this.setHardPendingCompactionBytesLimit(this.nativeHandle_, hardPendingCompactionBytesLimit);
        return this;
    }

    @Override
    public long hardPendingCompactionBytesLimit() {
        return this.hardPendingCompactionBytesLimit(this.nativeHandle_);
    }

    @Override
    public Options setLevel0FileNumCompactionTrigger(int level0FileNumCompactionTrigger) {
        this.setLevel0FileNumCompactionTrigger(this.nativeHandle_, level0FileNumCompactionTrigger);
        return this;
    }

    @Override
    public int level0FileNumCompactionTrigger() {
        return this.level0FileNumCompactionTrigger(this.nativeHandle_);
    }

    @Override
    public Options setLevel0SlowdownWritesTrigger(int level0SlowdownWritesTrigger) {
        this.setLevel0SlowdownWritesTrigger(this.nativeHandle_, level0SlowdownWritesTrigger);
        return this;
    }

    @Override
    public int level0SlowdownWritesTrigger() {
        return this.level0SlowdownWritesTrigger(this.nativeHandle_);
    }

    @Override
    public Options setLevel0StopWritesTrigger(int level0StopWritesTrigger) {
        this.setLevel0StopWritesTrigger(this.nativeHandle_, level0StopWritesTrigger);
        return this;
    }

    @Override
    public int level0StopWritesTrigger() {
        return this.level0StopWritesTrigger(this.nativeHandle_);
    }

    @Override
    public Options setMaxBytesForLevelMultiplierAdditional(int[] maxBytesForLevelMultiplierAdditional) {
        this.setMaxBytesForLevelMultiplierAdditional(this.nativeHandle_, maxBytesForLevelMultiplierAdditional);
        return this;
    }

    @Override
    public int[] maxBytesForLevelMultiplierAdditional() {
        return this.maxBytesForLevelMultiplierAdditional(this.nativeHandle_);
    }

    @Override
    public Options setParanoidFileChecks(boolean paranoidFileChecks) {
        this.setParanoidFileChecks(this.nativeHandle_, paranoidFileChecks);
        return this;
    }

    @Override
    public boolean paranoidFileChecks() {
        return this.paranoidFileChecks(this.nativeHandle_);
    }

    @Override
    public Options setMaxWriteBufferNumberToMaintain(int maxWriteBufferNumberToMaintain) {
        this.setMaxWriteBufferNumberToMaintain(this.nativeHandle_, maxWriteBufferNumberToMaintain);
        return this;
    }

    @Override
    public int maxWriteBufferNumberToMaintain() {
        return this.maxWriteBufferNumberToMaintain(this.nativeHandle_);
    }

    @Override
    public Options setCompactionPriority(CompactionPriority compactionPriority) {
        this.setCompactionPriority(this.nativeHandle_, compactionPriority.getValue());
        return this;
    }

    @Override
    public CompactionPriority compactionPriority() {
        return CompactionPriority.getCompactionPriority(this.compactionPriority(this.nativeHandle_));
    }

    @Override
    public Options setReportBgIoStats(boolean reportBgIoStats) {
        this.setReportBgIoStats(this.nativeHandle_, reportBgIoStats);
        return this;
    }

    @Override
    public boolean reportBgIoStats() {
        return this.reportBgIoStats(this.nativeHandle_);
    }

    @Override
    public Options setTtl(long ttl) {
        this.setTtl(this.nativeHandle_, ttl);
        return this;
    }

    @Override
    public long ttl() {
        return this.ttl(this.nativeHandle_);
    }

    @Override
    public Options setPeriodicCompactionSeconds(long periodicCompactionSeconds) {
        this.setPeriodicCompactionSeconds(this.nativeHandle_, periodicCompactionSeconds);
        return this;
    }

    @Override
    public long periodicCompactionSeconds() {
        return this.periodicCompactionSeconds(this.nativeHandle_);
    }

    @Override
    public Options setCompactionOptionsUniversal(CompactionOptionsUniversal compactionOptionsUniversal) {
        this.setCompactionOptionsUniversal(this.nativeHandle_, compactionOptionsUniversal.nativeHandle_);
        this.compactionOptionsUniversal_ = compactionOptionsUniversal;
        return this;
    }

    @Override
    public CompactionOptionsUniversal compactionOptionsUniversal() {
        return this.compactionOptionsUniversal_;
    }

    @Override
    public Options setCompactionOptionsFIFO(CompactionOptionsFIFO compactionOptionsFIFO) {
        this.setCompactionOptionsFIFO(this.nativeHandle_, compactionOptionsFIFO.nativeHandle_);
        this.compactionOptionsFIFO_ = compactionOptionsFIFO;
        return this;
    }

    @Override
    public CompactionOptionsFIFO compactionOptionsFIFO() {
        return this.compactionOptionsFIFO_;
    }

    @Override
    public Options setForceConsistencyChecks(boolean forceConsistencyChecks) {
        this.setForceConsistencyChecks(this.nativeHandle_, forceConsistencyChecks);
        return this;
    }

    @Override
    public boolean forceConsistencyChecks() {
        return this.forceConsistencyChecks(this.nativeHandle_);
    }

    @Override
    public Options setAtomicFlush(boolean atomicFlush) {
        this.setAtomicFlush(this.nativeHandle_, atomicFlush);
        return this;
    }

    @Override
    public boolean atomicFlush() {
        return this.atomicFlush(this.nativeHandle_);
    }

    @Override
    public Options setAvoidUnnecessaryBlockingIO(boolean avoidUnnecessaryBlockingIO) {
        Options.setAvoidUnnecessaryBlockingIO(this.nativeHandle_, avoidUnnecessaryBlockingIO);
        return this;
    }

    @Override
    public boolean avoidUnnecessaryBlockingIO() {
        assert (this.isOwningHandle());
        return Options.avoidUnnecessaryBlockingIO(this.nativeHandle_);
    }

    @Override
    public Options setPersistStatsToDisk(boolean persistStatsToDisk) {
        Options.setPersistStatsToDisk(this.nativeHandle_, persistStatsToDisk);
        return this;
    }

    @Override
    public boolean persistStatsToDisk() {
        assert (this.isOwningHandle());
        return Options.persistStatsToDisk(this.nativeHandle_);
    }

    @Override
    public Options setWriteDbidToManifest(boolean writeDbidToManifest) {
        Options.setWriteDbidToManifest(this.nativeHandle_, writeDbidToManifest);
        return this;
    }

    @Override
    public boolean writeDbidToManifest() {
        assert (this.isOwningHandle());
        return Options.writeDbidToManifest(this.nativeHandle_);
    }

    @Override
    public Options setLogReadaheadSize(long logReadaheadSize) {
        Options.setLogReadaheadSize(this.nativeHandle_, logReadaheadSize);
        return this;
    }

    @Override
    public long logReadaheadSize() {
        assert (this.isOwningHandle());
        return Options.logReadaheadSize(this.nativeHandle_);
    }

    @Override
    public Options setBestEffortsRecovery(boolean bestEffortsRecovery) {
        Options.setBestEffortsRecovery(this.nativeHandle_, bestEffortsRecovery);
        return this;
    }

    @Override
    public boolean bestEffortsRecovery() {
        assert (this.isOwningHandle());
        return Options.bestEffortsRecovery(this.nativeHandle_);
    }

    @Override
    public Options setMaxBgErrorResumeCount(int maxBgerrorResumeCount) {
        Options.setMaxBgErrorResumeCount(this.nativeHandle_, maxBgerrorResumeCount);
        return this;
    }

    @Override
    public int maxBgerrorResumeCount() {
        assert (this.isOwningHandle());
        return Options.maxBgerrorResumeCount(this.nativeHandle_);
    }

    @Override
    public Options setBgerrorResumeRetryInterval(long bgerrorResumeRetryInterval) {
        Options.setBgerrorResumeRetryInterval(this.nativeHandle_, bgerrorResumeRetryInterval);
        return this;
    }

    @Override
    public long bgerrorResumeRetryInterval() {
        assert (this.isOwningHandle());
        return Options.bgerrorResumeRetryInterval(this.nativeHandle_);
    }

    @Override
    public Options setSstPartitionerFactory(SstPartitionerFactory sstPartitionerFactory) {
        this.setSstPartitionerFactory(this.nativeHandle_, sstPartitionerFactory.nativeHandle_);
        this.sstPartitionerFactory_ = sstPartitionerFactory;
        return this;
    }

    @Override
    public SstPartitionerFactory sstPartitionerFactory() {
        return this.sstPartitionerFactory_;
    }

    @Override
    public Options setCompactionThreadLimiter(ConcurrentTaskLimiter compactionThreadLimiter) {
        Options.setCompactionThreadLimiter(this.nativeHandle_, compactionThreadLimiter.nativeHandle_);
        this.compactionThreadLimiter_ = compactionThreadLimiter;
        return this;
    }

    @Override
    public ConcurrentTaskLimiter compactionThreadLimiter() {
        assert (this.isOwningHandle());
        return this.compactionThreadLimiter_;
    }

    @Override
    public Options setEnableBlobFiles(boolean enableBlobFiles) {
        this.setEnableBlobFiles(this.nativeHandle_, enableBlobFiles);
        return this;
    }

    @Override
    public boolean enableBlobFiles() {
        return this.enableBlobFiles(this.nativeHandle_);
    }

    @Override
    public Options setMinBlobSize(long minBlobSize) {
        this.setMinBlobSize(this.nativeHandle_, minBlobSize);
        return this;
    }

    @Override
    public long minBlobSize() {
        return this.minBlobSize(this.nativeHandle_);
    }

    @Override
    public Options setBlobFileSize(long blobFileSize) {
        this.setBlobFileSize(this.nativeHandle_, blobFileSize);
        return this;
    }

    @Override
    public long blobFileSize() {
        return this.blobFileSize(this.nativeHandle_);
    }

    @Override
    public Options setBlobCompressionType(CompressionType compressionType) {
        this.setBlobCompressionType(this.nativeHandle_, compressionType.getValue());
        return this;
    }

    @Override
    public CompressionType blobCompressionType() {
        return CompressionType.values()[this.blobCompressionType(this.nativeHandle_)];
    }

    @Override
    public Options setEnableBlobGarbageCollection(boolean enableBlobGarbageCollection) {
        this.setEnableBlobGarbageCollection(this.nativeHandle_, enableBlobGarbageCollection);
        return this;
    }

    @Override
    public boolean enableBlobGarbageCollection() {
        return this.enableBlobGarbageCollection(this.nativeHandle_);
    }

    @Override
    public Options setBlobGarbageCollectionAgeCutoff(double blobGarbageCollectionAgeCutoff) {
        this.setBlobGarbageCollectionAgeCutoff(this.nativeHandle_, blobGarbageCollectionAgeCutoff);
        return this;
    }

    @Override
    public double blobGarbageCollectionAgeCutoff() {
        return this.blobGarbageCollectionAgeCutoff(this.nativeHandle_);
    }

    @Override
    public Options setBlobGarbageCollectionForceThreshold(double blobGarbageCollectionForceThreshold) {
        this.setBlobGarbageCollectionForceThreshold(this.nativeHandle_, blobGarbageCollectionForceThreshold);
        return this;
    }

    @Override
    public double blobGarbageCollectionForceThreshold() {
        return this.blobGarbageCollectionForceThreshold(this.nativeHandle_);
    }

    @Override
    public Options setBlobCompactionReadaheadSize(long blobCompactionReadaheadSize) {
        this.setBlobCompactionReadaheadSize(this.nativeHandle_, blobCompactionReadaheadSize);
        return this;
    }

    @Override
    public long blobCompactionReadaheadSize() {
        return this.blobCompactionReadaheadSize(this.nativeHandle_);
    }

    private static native long newOptions();

    private static native long newOptions(long var0, long var2);

    private static native long copyOptions(long var0);

    @Override
    protected final native void disposeInternal(long var1);

    private native void setEnv(long var1, long var3);

    private native void prepareForBulkLoad(long var1);

    private native void setIncreaseParallelism(long var1, int var3);

    private native void setCreateIfMissing(long var1, boolean var3);

    private native boolean createIfMissing(long var1);

    private native void setCreateMissingColumnFamilies(long var1, boolean var3);

    private native boolean createMissingColumnFamilies(long var1);

    private native void setErrorIfExists(long var1, boolean var3);

    private native boolean errorIfExists(long var1);

    private native void setParanoidChecks(long var1, boolean var3);

    private native boolean paranoidChecks(long var1);

    private native void setRateLimiter(long var1, long var3);

    private native void setSstFileManager(long var1, long var3);

    private native void setLogger(long var1, long var3);

    private native void setInfoLogLevel(long var1, byte var3);

    private native byte infoLogLevel(long var1);

    private native void setMaxOpenFiles(long var1, int var3);

    private native int maxOpenFiles(long var1);

    private native void setMaxTotalWalSize(long var1, long var3);

    private native void setMaxFileOpeningThreads(long var1, int var3);

    private native int maxFileOpeningThreads(long var1);

    private native long maxTotalWalSize(long var1);

    private native void setStatistics(long var1, long var3);

    private native long statistics(long var1);

    private native boolean useFsync(long var1);

    private native void setUseFsync(long var1, boolean var3);

    private native void setDbPaths(long var1, String[] var3, long[] var4);

    private native long dbPathsLen(long var1);

    private native void dbPaths(long var1, String[] var3, long[] var4);

    private native void setDbLogDir(long var1, String var3);

    private native String dbLogDir(long var1);

    private native void setWalDir(long var1, String var3);

    private native String walDir(long var1);

    private native void setDeleteObsoleteFilesPeriodMicros(long var1, long var3);

    private native long deleteObsoleteFilesPeriodMicros(long var1);

    private native void setMaxBackgroundCompactions(long var1, int var3);

    private native int maxBackgroundCompactions(long var1);

    private native void setMaxSubcompactions(long var1, int var3);

    private native int maxSubcompactions(long var1);

    private native void setMaxBackgroundFlushes(long var1, int var3);

    private native int maxBackgroundFlushes(long var1);

    private native void setMaxBackgroundJobs(long var1, int var3);

    private native int maxBackgroundJobs(long var1);

    private native void setMaxLogFileSize(long var1, long var3) throws IllegalArgumentException;

    private native long maxLogFileSize(long var1);

    private native void setLogFileTimeToRoll(long var1, long var3) throws IllegalArgumentException;

    private native long logFileTimeToRoll(long var1);

    private native void setKeepLogFileNum(long var1, long var3) throws IllegalArgumentException;

    private native long keepLogFileNum(long var1);

    private native void setRecycleLogFileNum(long var1, long var3);

    private native long recycleLogFileNum(long var1);

    private native void setMaxManifestFileSize(long var1, long var3);

    private native long maxManifestFileSize(long var1);

    private native void setMaxTableFilesSizeFIFO(long var1, long var3);

    private native long maxTableFilesSizeFIFO(long var1);

    private native void setTableCacheNumshardbits(long var1, int var3);

    private native int tableCacheNumshardbits(long var1);

    private native void setWalTtlSeconds(long var1, long var3);

    private native long walTtlSeconds(long var1);

    private native void setWalSizeLimitMB(long var1, long var3);

    private native long walSizeLimitMB(long var1);

    private static native void setMaxWriteBatchGroupSizeBytes(long var0, long var2);

    private static native long maxWriteBatchGroupSizeBytes(long var0);

    private native void setManifestPreallocationSize(long var1, long var3) throws IllegalArgumentException;

    private native long manifestPreallocationSize(long var1);

    private native void setUseDirectReads(long var1, boolean var3);

    private native boolean useDirectReads(long var1);

    private native void setUseDirectIoForFlushAndCompaction(long var1, boolean var3);

    private native boolean useDirectIoForFlushAndCompaction(long var1);

    private native void setAllowFAllocate(long var1, boolean var3);

    private native boolean allowFAllocate(long var1);

    private native void setAllowMmapReads(long var1, boolean var3);

    private native boolean allowMmapReads(long var1);

    private native void setAllowMmapWrites(long var1, boolean var3);

    private native boolean allowMmapWrites(long var1);

    private native void setIsFdCloseOnExec(long var1, boolean var3);

    private native boolean isFdCloseOnExec(long var1);

    private native void setStatsDumpPeriodSec(long var1, int var3);

    private native int statsDumpPeriodSec(long var1);

    private native void setStatsPersistPeriodSec(long var1, int var3);

    private native int statsPersistPeriodSec(long var1);

    private native void setStatsHistoryBufferSize(long var1, long var3);

    private native long statsHistoryBufferSize(long var1);

    private native void setAdviseRandomOnOpen(long var1, boolean var3);

    private native boolean adviseRandomOnOpen(long var1);

    private native void setDbWriteBufferSize(long var1, long var3);

    private native void setWriteBufferManager(long var1, long var3);

    private native long dbWriteBufferSize(long var1);

    private native void setAccessHintOnCompactionStart(long var1, byte var3);

    private native byte accessHintOnCompactionStart(long var1);

    private native void setCompactionReadaheadSize(long var1, long var3);

    private native long compactionReadaheadSize(long var1);

    private native void setRandomAccessMaxBufferSize(long var1, long var3);

    private native long randomAccessMaxBufferSize(long var1);

    private native void setWritableFileMaxBufferSize(long var1, long var3);

    private native long writableFileMaxBufferSize(long var1);

    private native void setUseAdaptiveMutex(long var1, boolean var3);

    private native boolean useAdaptiveMutex(long var1);

    private native void setBytesPerSync(long var1, long var3);

    private native long bytesPerSync(long var1);

    private native void setWalBytesPerSync(long var1, long var3);

    private native long walBytesPerSync(long var1);

    private native void setStrictBytesPerSync(long var1, boolean var3);

    private native boolean strictBytesPerSync(long var1);

    private static native void setEventListeners(long var0, long[] var2);

    private static native AbstractEventListener[] eventListeners(long var0);

    private native void setEnableThreadTracking(long var1, boolean var3);

    private native boolean enableThreadTracking(long var1);

    private native void setDelayedWriteRate(long var1, long var3);

    private native long delayedWriteRate(long var1);

    private native void setEnablePipelinedWrite(long var1, boolean var3);

    private native boolean enablePipelinedWrite(long var1);

    private native void setUnorderedWrite(long var1, boolean var3);

    private native boolean unorderedWrite(long var1);

    private native void setAllowConcurrentMemtableWrite(long var1, boolean var3);

    private native boolean allowConcurrentMemtableWrite(long var1);

    private native void setEnableWriteThreadAdaptiveYield(long var1, boolean var3);

    private native boolean enableWriteThreadAdaptiveYield(long var1);

    private native void setWriteThreadMaxYieldUsec(long var1, long var3);

    private native long writeThreadMaxYieldUsec(long var1);

    private native void setWriteThreadSlowYieldUsec(long var1, long var3);

    private native long writeThreadSlowYieldUsec(long var1);

    private native void setSkipStatsUpdateOnDbOpen(long var1, boolean var3);

    private native boolean skipStatsUpdateOnDbOpen(long var1);

    private static native void setSkipCheckingSstFileSizesOnDbOpen(long var0, boolean var2);

    private static native boolean skipCheckingSstFileSizesOnDbOpen(long var0);

    private native void setWalRecoveryMode(long var1, byte var3);

    private native byte walRecoveryMode(long var1);

    private native void setAllow2pc(long var1, boolean var3);

    private native boolean allow2pc(long var1);

    private native void setRowCache(long var1, long var3);

    private native void setWalFilter(long var1, long var3);

    private native void setFailIfOptionsFileError(long var1, boolean var3);

    private native boolean failIfOptionsFileError(long var1);

    private native void setDumpMallocStats(long var1, boolean var3);

    private native boolean dumpMallocStats(long var1);

    private native void setAvoidFlushDuringRecovery(long var1, boolean var3);

    private native boolean avoidFlushDuringRecovery(long var1);

    private native void setAvoidFlushDuringShutdown(long var1, boolean var3);

    private native boolean avoidFlushDuringShutdown(long var1);

    private native void setAllowIngestBehind(long var1, boolean var3);

    private native boolean allowIngestBehind(long var1);

    private native void setTwoWriteQueues(long var1, boolean var3);

    private native boolean twoWriteQueues(long var1);

    private native void setManualWalFlush(long var1, boolean var3);

    private native boolean manualWalFlush(long var1);

    private static native void oldDefaults(long var0, int var2, int var3);

    private native void optimizeForSmallDb(long var1);

    private static native void optimizeForSmallDb(long var0, long var2);

    private native void optimizeForPointLookup(long var1, long var3);

    private native void optimizeLevelStyleCompaction(long var1, long var3);

    private native void optimizeUniversalStyleCompaction(long var1, long var3);

    private native void setComparatorHandle(long var1, int var3);

    private native void setComparatorHandle(long var1, long var3, byte var5);

    private native void setMergeOperatorName(long var1, String var3);

    private native void setMergeOperator(long var1, long var3);

    private native void setCompactionFilterHandle(long var1, long var3);

    private native void setCompactionFilterFactoryHandle(long var1, long var3);

    private native void setWriteBufferSize(long var1, long var3) throws IllegalArgumentException;

    private native long writeBufferSize(long var1);

    private native void setMaxWriteBufferNumber(long var1, int var3);

    private native int maxWriteBufferNumber(long var1);

    private native void setMinWriteBufferNumberToMerge(long var1, int var3);

    private native int minWriteBufferNumberToMerge(long var1);

    private native void setCompressionType(long var1, byte var3);

    private native byte compressionType(long var1);

    private native void setCompressionPerLevel(long var1, byte[] var3);

    private native byte[] compressionPerLevel(long var1);

    private native void setBottommostCompressionType(long var1, byte var3);

    private native byte bottommostCompressionType(long var1);

    private native void setBottommostCompressionOptions(long var1, long var3);

    private native void setCompressionOptions(long var1, long var3);

    private native void useFixedLengthPrefixExtractor(long var1, int var3);

    private native void useCappedPrefixExtractor(long var1, int var3);

    private native void setNumLevels(long var1, int var3);

    private native int numLevels(long var1);

    private native void setLevelZeroFileNumCompactionTrigger(long var1, int var3);

    private native int levelZeroFileNumCompactionTrigger(long var1);

    private native void setLevelZeroSlowdownWritesTrigger(long var1, int var3);

    private native int levelZeroSlowdownWritesTrigger(long var1);

    private native void setLevelZeroStopWritesTrigger(long var1, int var3);

    private native int levelZeroStopWritesTrigger(long var1);

    private native void setTargetFileSizeBase(long var1, long var3);

    private native long targetFileSizeBase(long var1);

    private native void setTargetFileSizeMultiplier(long var1, int var3);

    private native int targetFileSizeMultiplier(long var1);

    private native void setMaxBytesForLevelBase(long var1, long var3);

    private native long maxBytesForLevelBase(long var1);

    private native void setLevelCompactionDynamicLevelBytes(long var1, boolean var3);

    private native boolean levelCompactionDynamicLevelBytes(long var1);

    private native void setMaxBytesForLevelMultiplier(long var1, double var3);

    private native double maxBytesForLevelMultiplier(long var1);

    private native void setMaxCompactionBytes(long var1, long var3);

    private native long maxCompactionBytes(long var1);

    private native void setArenaBlockSize(long var1, long var3) throws IllegalArgumentException;

    private native long arenaBlockSize(long var1);

    private native void setDisableAutoCompactions(long var1, boolean var3);

    private native boolean disableAutoCompactions(long var1);

    private native void setCompactionStyle(long var1, byte var3);

    private native byte compactionStyle(long var1);

    private native void setMaxSequentialSkipInIterations(long var1, long var3);

    private native long maxSequentialSkipInIterations(long var1);

    private native void setMemTableFactory(long var1, long var3);

    private native String memTableFactoryName(long var1);

    private native void setTableFactory(long var1, long var3);

    private native String tableFactoryName(long var1);

    private static native void setCfPaths(long var0, String[] var2, long[] var3);

    private static native long cfPathsLen(long var0);

    private static native void cfPaths(long var0, String[] var2, long[] var3);

    private native void setInplaceUpdateSupport(long var1, boolean var3);

    private native boolean inplaceUpdateSupport(long var1);

    private native void setInplaceUpdateNumLocks(long var1, long var3) throws IllegalArgumentException;

    private native long inplaceUpdateNumLocks(long var1);

    private native void setMemtablePrefixBloomSizeRatio(long var1, double var3);

    private native double memtablePrefixBloomSizeRatio(long var1);

    private native void setMemtableWholeKeyFiltering(long var1, boolean var3);

    private native boolean memtableWholeKeyFiltering(long var1);

    private native void setBloomLocality(long var1, int var3);

    private native int bloomLocality(long var1);

    private native void setMaxSuccessiveMerges(long var1, long var3) throws IllegalArgumentException;

    private native long maxSuccessiveMerges(long var1);

    private native void setOptimizeFiltersForHits(long var1, boolean var3);

    private native boolean optimizeFiltersForHits(long var1);

    private native void setMemtableHugePageSize(long var1, long var3);

    private native long memtableHugePageSize(long var1);

    private native void setSoftPendingCompactionBytesLimit(long var1, long var3);

    private native long softPendingCompactionBytesLimit(long var1);

    private native void setHardPendingCompactionBytesLimit(long var1, long var3);

    private native long hardPendingCompactionBytesLimit(long var1);

    private native void setLevel0FileNumCompactionTrigger(long var1, int var3);

    private native int level0FileNumCompactionTrigger(long var1);

    private native void setLevel0SlowdownWritesTrigger(long var1, int var3);

    private native int level0SlowdownWritesTrigger(long var1);

    private native void setLevel0StopWritesTrigger(long var1, int var3);

    private native int level0StopWritesTrigger(long var1);

    private native void setMaxBytesForLevelMultiplierAdditional(long var1, int[] var3);

    private native int[] maxBytesForLevelMultiplierAdditional(long var1);

    private native void setParanoidFileChecks(long var1, boolean var3);

    private native boolean paranoidFileChecks(long var1);

    private native void setMaxWriteBufferNumberToMaintain(long var1, int var3);

    private native int maxWriteBufferNumberToMaintain(long var1);

    private native void setCompactionPriority(long var1, byte var3);

    private native byte compactionPriority(long var1);

    private native void setReportBgIoStats(long var1, boolean var3);

    private native boolean reportBgIoStats(long var1);

    private native void setTtl(long var1, long var3);

    private native long ttl(long var1);

    private native void setPeriodicCompactionSeconds(long var1, long var3);

    private native long periodicCompactionSeconds(long var1);

    private native void setCompactionOptionsUniversal(long var1, long var3);

    private native void setCompactionOptionsFIFO(long var1, long var3);

    private native void setForceConsistencyChecks(long var1, boolean var3);

    private native boolean forceConsistencyChecks(long var1);

    private native void setAtomicFlush(long var1, boolean var3);

    private native boolean atomicFlush(long var1);

    private native void setSstPartitionerFactory(long var1, long var3);

    private static native void setCompactionThreadLimiter(long var0, long var2);

    private static native void setAvoidUnnecessaryBlockingIO(long var0, boolean var2);

    private static native boolean avoidUnnecessaryBlockingIO(long var0);

    private static native void setPersistStatsToDisk(long var0, boolean var2);

    private static native boolean persistStatsToDisk(long var0);

    private static native void setWriteDbidToManifest(long var0, boolean var2);

    private static native boolean writeDbidToManifest(long var0);

    private static native void setLogReadaheadSize(long var0, long var2);

    private static native long logReadaheadSize(long var0);

    private static native void setBestEffortsRecovery(long var0, boolean var2);

    private static native boolean bestEffortsRecovery(long var0);

    private static native void setMaxBgErrorResumeCount(long var0, int var2);

    private static native int maxBgerrorResumeCount(long var0);

    private static native void setBgerrorResumeRetryInterval(long var0, long var2);

    private static native long bgerrorResumeRetryInterval(long var0);

    private native void setEnableBlobFiles(long var1, boolean var3);

    private native boolean enableBlobFiles(long var1);

    private native void setMinBlobSize(long var1, long var3);

    private native long minBlobSize(long var1);

    private native void setBlobFileSize(long var1, long var3);

    private native long blobFileSize(long var1);

    private native void setBlobCompressionType(long var1, byte var3);

    private native byte blobCompressionType(long var1);

    private native void setEnableBlobGarbageCollection(long var1, boolean var3);

    private native boolean enableBlobGarbageCollection(long var1);

    private native void setBlobGarbageCollectionAgeCutoff(long var1, double var3);

    private native double blobGarbageCollectionAgeCutoff(long var1);

    private native void setBlobGarbageCollectionForceThreshold(long var1, double var3);

    private native double blobGarbageCollectionForceThreshold(long var1);

    private native void setBlobCompactionReadaheadSize(long var1, long var3);

    private native long blobCompactionReadaheadSize(long var1);

    static {
        RocksDB.loadLibrary();
    }
}

