/*
 * Decompiled with CFR 0.152.
 */
package net.volcanite.util;

import java.util.Objects;
import net.volcanite.util.DoubleStatistics;

public class DoubleStatisticsNoSync
implements DoubleStatistics {
    private long count;
    private double sum;
    private double sumCompensation;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private double sumDiffFromCurrMeanSquared;
    private double sumDiffFromCurrMeanSquaredCompensation;
    private double variance;

    public DoubleStatisticsNoSync() {
    }

    public DoubleStatisticsNoSync(DoubleStatisticsNoSync other) throws IllegalArgumentException {
        Objects.requireNonNull(other);
        if (other.count < 0L) {
            throw new IllegalArgumentException("Negative count value");
        }
        if (other.count > 0L) {
            if (other.min > other.max) {
                throw new IllegalArgumentException("Minimum greater than maximum");
            }
            int ncount = 0;
            if (Double.isNaN(other.min)) {
                ++ncount;
            }
            if (Double.isNaN(other.max)) {
                ++ncount;
            }
            if (Double.isNaN(other.sum)) {
                ++ncount;
            }
            if (ncount > 0 && ncount < 3) {
                throw new IllegalArgumentException("Some, not all, of the minimum, maximum, or sum is NaN");
            }
            this.count = other.count;
            this.sum = other.sum;
            this.sumCompensation = 0.0;
            this.min = other.min;
            this.max = other.max;
            this.sumDiffFromCurrMeanSquared = other.sumDiffFromCurrMeanSquared;
            this.sumDiffFromCurrMeanSquaredCompensation = other.sumDiffFromCurrMeanSquaredCompensation;
            this.variance = other.variance;
        }
    }

    @Override
    public void accept(double value) {
        long countSoFar = this.count++;
        double average = this.getAverage();
        this.sumWithCompensation(value);
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
        double delta = value - average;
        average = (double)countSoFar * average / (double)this.count + value / (double)this.count;
        this.sumDiffFromCurrMeanSquaredWithCompensation(delta * (value - average));
        if (this.count > 1L) {
            this.variance = (this.sumDiffFromCurrMeanSquared - this.sumDiffFromCurrMeanSquaredCompensation) / (double)countSoFar;
        }
    }

    private void sumWithCompensation(double value) {
        double tmp = value - this.sumCompensation;
        double velvel = this.sum + tmp;
        this.sumCompensation = velvel - this.sum - tmp;
        this.sum = velvel;
    }

    private void sumDiffFromCurrMeanSquaredWithCompensation(double value) {
        double tmp = value - this.sumDiffFromCurrMeanSquaredCompensation;
        double velvel = this.sumDiffFromCurrMeanSquared + tmp;
        this.sumDiffFromCurrMeanSquaredCompensation = velvel - this.sumDiffFromCurrMeanSquared - tmp;
        this.sumDiffFromCurrMeanSquared = velvel;
    }

    @Override
    public final long getCount() {
        return this.count;
    }

    @Override
    public final double getSum() {
        return this.sum - this.sumCompensation;
    }

    @Override
    public final double getMin() {
        return this.min;
    }

    @Override
    public final double getMax() {
        return this.max;
    }

    @Override
    public final double getAverage() {
        return this.getCount() > 0L ? this.getSum() / (double)this.getCount() : 0.0;
    }

    @Override
    public final double getVariance() {
        double var = this.variance;
        if (var < 0.0) {
            var = 0.0;
        }
        return var;
    }

    @Override
    public final double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    @Override
    public String toString() {
        return String.format("%s{count=%d, sum=%f, min=%f, average=%f, max=%f, stddev=%f}", this.getClass().getSimpleName(), this.getCount(), this.getSum(), this.getMin(), this.getAverage(), this.getMax(), this.getStandardDeviation());
    }
}

