/*
 * Decompiled with CFR 0.152.
 */
package net.volcanite.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DiscardOverflowsQueue
extends LinkedBlockingQueue<Runnable> {
    private static final long serialVersionUID = 3052494991610810267L;
    private static final Logger logger = Logger.getLogger(DiscardOverflowsQueue.class.getName());
    public static final int DEFAULT_MAX_CAPACITY = 15000000;
    private final int capacity;

    public DiscardOverflowsQueue() {
        this(15000000);
    }

    public DiscardOverflowsQueue(int capacity) {
        super(capacity);
        this.capacity = capacity;
    }

    @Override
    public void put(Runnable o) throws InterruptedException {
        this.offer(o);
    }

    @Override
    public boolean add(Runnable o) {
        return this.offer(o);
    }

    @Override
    public boolean offer(Runnable o) {
        boolean couldAdd = super.offer(o);
        if (!couldAdd) {
            logger.log(Level.WARNING, "Rejected Runnable: " + o.toString() + " (reached queue max. capacity of " + this.capacity + ")");
        }
        return couldAdd;
    }
}

