/*
 * Decompiled with CFR 0.152.
 */
package org.schwefel.kv;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rocksdb.RocksIterator;
import org.schwefel.kv.AbstractForEach;
import org.schwefel.kv.BasicOps;
import org.schwefel.kv.LexicographicByteArrayComparator;
import org.schwefel.kv.Stats;

class ForEachRange
extends AbstractForEach {
    private static final Logger logger = Logger.getLogger(ForEachRange.class.getName());
    private final byte[] endExclusive;

    ForEachRange(RocksIterator iter, byte[] endKey, Stats stats, BasicOps ops) {
        super(iter, stats, ops);
        this.endExclusive = Objects.requireNonNull(endKey, "endKey cannot be null");
    }

    @Override
    public synchronized void forEachRemaining(BiConsumer<byte[], byte[]> action) {
        this.forEachUntilLimit(action, Long.MAX_VALUE);
    }

    @Override
    public synchronized void forEachUntilLimit(BiConsumer<byte[], byte[]> action, long limit) {
        Objects.requireNonNull(action, "action cannot be null");
        this.checkOpen();
        try {
            byte[] currentKey;
            long count = 0L;
            while (this.iter.isValid() && count++ < limit && ForEachRange.compare(currentKey = this.iter.key(), this.endExclusive) < 0) {
                action.accept(currentKey, this.iter.value());
                this.iter.next();
            }
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "closing ForEachRange", e);
            throw e;
        }
        finally {
            this.close();
        }
    }

    @Override
    public synchronized boolean tryAdvance(BiConsumer<byte[], byte[]> action) {
        byte[] currentKey;
        Objects.requireNonNull(action, "action cannot be null");
        this.checkOpen();
        if (this.iter.isValid() && ForEachRange.compare(currentKey = this.iter.key(), this.endExclusive) < 0) {
            try {
                action.accept(currentKey, this.iter.value());
                this.iter.next();
            }
            catch (RuntimeException e) {
                this.close();
                logger.log(Level.WARNING, "closing ForEachRange", e);
                throw e;
            }
            return true;
        }
        this.close();
        return false;
    }

    private static int compare(byte[] a, byte[] b) {
        return LexicographicByteArrayComparator.lexicographicalCompare(a, b);
    }
}

