/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb.util;

import java.io.IOException;

public class Environment {
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static String ARCH = System.getProperty("os.arch").toLowerCase();
    private static boolean MUSL_LIBC;

    public static boolean isAarch64() {
        return ARCH.contains("aarch64");
    }

    public static boolean isPowerPC() {
        return ARCH.contains("ppc");
    }

    public static boolean isS390x() {
        return ARCH.contains("s390x");
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isFreeBSD() {
        return OS.contains("freebsd");
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isAix() {
        return OS.contains("aix");
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux");
    }

    public static boolean isMuslLibc() {
        return MUSL_LIBC;
    }

    public static boolean isSolaris() {
        return OS.contains("sunos");
    }

    public static boolean isOpenBSD() {
        return OS.contains("openbsd");
    }

    public static boolean is64Bit() {
        if (ARCH.indexOf("sparcv9") >= 0) {
            return true;
        }
        return ARCH.indexOf("64") > 0;
    }

    public static String getSharedLibraryName(String name) {
        return name + "jni";
    }

    public static String getSharedLibraryFileName(String name) {
        return Environment.appendLibOsSuffix("lib" + Environment.getSharedLibraryName(name), true);
    }

    public static String getLibcName() {
        if (Environment.isMuslLibc()) {
            return "musl";
        }
        return null;
    }

    private static String getLibcPostfix() {
        String libcName = Environment.getLibcName();
        if (libcName == null) {
            return "";
        }
        return "-" + libcName;
    }

    public static String getJniLibraryName(String name) {
        if (Environment.isUnix()) {
            String arch;
            String string = arch = Environment.is64Bit() ? "64" : "32";
            if (Environment.isPowerPC() || Environment.isAarch64()) {
                return String.format("%sjni-linux-%s%s", name, ARCH, Environment.getLibcPostfix());
            }
            if (Environment.isS390x()) {
                return String.format("%sjni-linux-%s", name, ARCH);
            }
            return String.format("%sjni-linux%s%s", name, arch, Environment.getLibcPostfix());
        }
        if (Environment.isMac()) {
            if (Environment.is64Bit()) {
                String arch = Environment.isAarch64() ? "arm64" : "x86_64";
                return String.format("%sjni-osx-%s", name, arch);
            }
            return String.format("%sjni-osx", name);
        }
        if (Environment.isFreeBSD()) {
            return String.format("%sjni-freebsd%s", name, Environment.is64Bit() ? "64" : "32");
        }
        if (Environment.isAix() && Environment.is64Bit()) {
            return String.format("%sjni-aix64", name);
        }
        if (Environment.isSolaris()) {
            String arch = Environment.is64Bit() ? "64" : "32";
            return String.format("%sjni-solaris%s", name, arch);
        }
        if (Environment.isWindows() && Environment.is64Bit()) {
            return String.format("%sjni-win64", name);
        }
        if (Environment.isOpenBSD()) {
            return String.format("%sjni-openbsd%s", name, Environment.is64Bit() ? "64" : "32");
        }
        throw new UnsupportedOperationException(String.format("Cannot determine JNI library name for ARCH='%s' OS='%s' name='%s'", ARCH, OS, name));
    }

    public static String getFallbackJniLibraryName(String name) {
        if (Environment.isMac() && Environment.is64Bit()) {
            return String.format("%sjni-osx", name);
        }
        return null;
    }

    public static String getJniLibraryFileName(String name) {
        return Environment.appendLibOsSuffix("lib" + Environment.getJniLibraryName(name), false);
    }

    public static String getFallbackJniLibraryFileName(String name) {
        String fallbackJniLibraryName = Environment.getFallbackJniLibraryName(name);
        if (fallbackJniLibraryName == null) {
            return null;
        }
        return Environment.appendLibOsSuffix("lib" + fallbackJniLibraryName, false);
    }

    private static String appendLibOsSuffix(String libraryFileName, boolean shared) {
        if (Environment.isUnix() || Environment.isAix() || Environment.isSolaris() || Environment.isFreeBSD() || Environment.isOpenBSD()) {
            return libraryFileName + ".so";
        }
        if (Environment.isMac()) {
            return libraryFileName + (shared ? ".dylib" : ".jnilib");
        }
        if (Environment.isWindows()) {
            return libraryFileName + ".dll";
        }
        throw new UnsupportedOperationException();
    }

    public static String getJniLibraryExtension() {
        if (Environment.isWindows()) {
            return ".dll";
        }
        return Environment.isMac() ? ".jnilib" : ".so";
    }

    static {
        try {
            Process p = new ProcessBuilder("/usr/bin/env", "sh", "-c", "ldd /usr/bin/env | grep -q musl").start();
            MUSL_LIBC = p.waitFor() == 0;
        }
        catch (IOException | InterruptedException e) {
            MUSL_LIBC = false;
        }
    }
}

